/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.youtrack.YouTrackRepository;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;

public class YouTrackIntellisense {
    public static final Key<YouTrackIntellisense> INTELLISENSE_KEY = Key.create((String)"youtrack.intellisense");
    private static final Logger LOG = Logger.getInstance(YouTrackIntellisense.class);
    public static final String INTELLISENSE_RESOURCE = "/rest/issue/intellisense";
    private static final Map<String, TextAttributes> TEXT_ATTRIBUTES = ContainerUtil.newHashMap((Pair)Pair.create((Object)"field", (Object)DefaultLanguageHighlighterColors.CONSTANT.getDefaultAttributes()), (Pair[])new Pair[]{Pair.create((Object)"keyword", (Object)DefaultLanguageHighlighterColors.KEYWORD.getDefaultAttributes()), Pair.create((Object)"string", (Object)DefaultLanguageHighlighterColors.STRING.getDefaultAttributes()), Pair.create((Object)"error", (Object)HighlighterColors.BAD_CHARACTER.getDefaultAttributes())});
    private static final int CACHE_SIZE = 30;
    private static final Map<Pair<String, Integer>, Response> ourCache = Collections.synchronizedMap(new SizeLimitedCache(30));
    private final YouTrackRepository myRepository;

    @NotNull
    private static TextAttributes getAttributeByStyleClass(@NotNull String styleClass) {
        if (styleClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleClass", "com/intellij/tasks/youtrack/YouTrackIntellisense", "getAttributeByStyleClass"));
        }
        TextAttributes attr = TEXT_ATTRIBUTES.get(styleClass);
        TextAttributes textAttributes = attr == null ? HighlighterColors.TEXT.getDefaultAttributes() : attr;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense", "getAttributeByStyleClass"));
        }
        return textAttributes;
    }

    @NotNull
    public List<HighlightRange> fetchHighlighting(@NotNull String query, int caret) throws Exception {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/tasks/youtrack/YouTrackIntellisense", "fetchHighlighting"));
        }
        LOG.debug("Requesting highlighting");
        List<HighlightRange> list = this.fetch(query, caret, true).getHighlightRanges();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense", "fetchHighlighting"));
        }
        return list;
    }

    @NotNull
    public List<CompletionItem> fetchCompletion(@NotNull String query, int caret) throws Exception {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/tasks/youtrack/YouTrackIntellisense", "fetchCompletion"));
        }
        LOG.debug("Requesting completion");
        List<CompletionItem> list = this.fetch(query, caret, false).getCompletionItems();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense", "fetchCompletion"));
        }
        return list;
    }

    public YouTrackIntellisense(@NotNull YouTrackRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/youtrack/YouTrackIntellisense", "<init>"));
        }
        this.myRepository = repository;
    }

    @NotNull
    private Response fetch(@NotNull String query, int caret, boolean ignoreCaret) throws Exception {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/tasks/youtrack/YouTrackIntellisense", "fetch"));
        }
        LOG.debug("Query: '" + query + "' caret at: " + caret);
        Pair lookup = Pair.create((Object)query, (Object)caret);
        Response response = null;
        if (ignoreCaret) {
            for (Pair<String, Integer> pair : ourCache.keySet()) {
                if (!((String)pair.getFirst()).equals(query)) continue;
                response = ourCache.get(pair);
                break;
            }
        } else {
            response = ourCache.get(lookup);
        }
        LOG.debug("Cache " + (response != null ? "hit" : "miss"));
        if (response == null) {
            String url = String.format("%s?filter=%s&caret=%d", INTELLISENSE_RESOURCE, URLEncoder.encode(query, "utf-8"), caret);
            long startTime = System.currentTimeMillis();
            response = new Response(this.myRepository.doREST(url, false).getResponseBodyAsStream());
            LOG.debug(String.format("Intellisense request to YouTrack took %d ms to complete", System.currentTimeMillis() - startTime));
            ourCache.put((Pair<String, Integer>)lookup, response);
        }
        Response response2 = response;
        if (response2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense", "fetch"));
        }
        return response2;
    }

    public YouTrackRepository getRepository() {
        return this.myRepository;
    }

    public static class CompletionItem {
        private TextRange myMatchRange;
        private TextRange myCompletionRange;
        private int myCaretPosition;
        private String myDescription;
        private String mySuffix;
        private String myPrefix;
        private String myOption;
        private String myStyleClass;

        public CompletionItem(@NotNull Element item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem", "<init>"));
            }
            Element match = item.getChild("match");
            this.myMatchRange = new TextRange(Integer.parseInt(match.getAttributeValue("start")), Integer.parseInt(match.getAttributeValue("end")));
            Element completion = item.getChild("completion");
            this.myCompletionRange = new TextRange(Integer.parseInt(completion.getAttributeValue("start")), Integer.parseInt(completion.getAttributeValue("end")));
            this.myDescription = item.getChildText("description");
            this.myOption = item.getChildText("option");
            this.mySuffix = item.getChildText("suffix");
            this.myPrefix = item.getChildText("prefix");
            this.myStyleClass = item.getChildText("styleClass");
            this.myCaretPosition = Integer.valueOf(item.getChildText("caret"));
        }

        @NotNull
        public TextRange getMatchRange() {
            TextRange textRange = this.myMatchRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem", "getMatchRange"));
            }
            return textRange;
        }

        @NotNull
        public TextRange getCompletionRange() {
            TextRange textRange = this.myCompletionRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem", "getCompletionRange"));
            }
            return textRange;
        }

        public int getCaretPosition() {
            return this.myCaretPosition;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem", "getDescription"));
            }
            return string;
        }

        @NotNull
        public String getSuffix() {
            String string = StringUtil.notNullize((String)this.mySuffix);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem", "getSuffix"));
            }
            return string;
        }

        @NotNull
        public String getPrefix() {
            String string = StringUtil.notNullize((String)this.myPrefix);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem", "getPrefix"));
            }
            return string;
        }

        @NotNull
        public String getOption() {
            String string = this.myOption;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem", "getOption"));
            }
            return string;
        }

        @NotNull
        public String getStyleClass() {
            String string = StringUtil.notNullize((String)this.myStyleClass);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem", "getStyleClass"));
            }
            return string;
        }

        @NotNull
        TextAttributes getTextAttributes() {
            TextAttributes textAttributes = YouTrackIntellisense.getAttributeByStyleClass(this.myStyleClass);
            if (textAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem", "getTextAttributes"));
            }
            return textAttributes;
        }
    }

    public static class HighlightRange {
        private int myStart;
        private int myEnd;
        private String myStyleClass;

        public HighlightRange(@NotNull Element rangeElement) {
            if (rangeElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeElement", "com/intellij/tasks/youtrack/YouTrackIntellisense$HighlightRange", "<init>"));
            }
            this.myStart = Integer.valueOf(rangeElement.getChildText("start"));
            this.myEnd = Integer.valueOf(rangeElement.getChildText("end"));
            this.myStyleClass = rangeElement.getChildText("styleClass");
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        @NotNull
        public String getStyleClass() {
            String string = StringUtil.notNullize((String)this.myStyleClass);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$HighlightRange", "getStyleClass"));
            }
            return string;
        }

        @NotNull
        public TextRange getRange() {
            TextRange textRange = new TextRange(this.myStart, this.myEnd);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$HighlightRange", "getRange"));
            }
            return textRange;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = TextRange.create((int)this.myStart, (int)this.myEnd);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$HighlightRange", "getTextRange"));
            }
            return textRange;
        }

        @NotNull
        public TextAttributes getTextAttributes() {
            TextAttributes textAttributes = YouTrackIntellisense.getAttributeByStyleClass(this.myStyleClass);
            if (textAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$HighlightRange", "getTextAttributes"));
            }
            return textAttributes;
        }
    }

    public static class Response {
        private List<HighlightRange> myHighlightRanges;
        private List<CompletionItem> myCompletionItems;

        public Response(@NotNull InputStream stream) throws Exception {
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/tasks/youtrack/YouTrackIntellisense$Response", "<init>"));
            }
            Element root = new SAXBuilder().build(stream).getRootElement();
            TaskUtil.prettyFormatXmlToLog(LOG, root);
            Element highlight = root.getChild("highlight");
            this.myHighlightRanges = ContainerUtil.map((Collection)highlight.getChildren("range"), (Function)new Function<Element, HighlightRange>(){

                public HighlightRange fun(Element range) {
                    return new HighlightRange(range);
                }
            });
            Element suggest = root.getChild("suggest");
            this.myCompletionItems = ContainerUtil.map((Collection)suggest.getChildren("item"), (Function)new Function<Element, CompletionItem>(){

                public CompletionItem fun(Element item) {
                    return new CompletionItem(item);
                }
            });
        }

        @NotNull
        public List<HighlightRange> getHighlightRanges() {
            List<HighlightRange> list = this.myHighlightRanges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$Response", "getHighlightRanges"));
            }
            return list;
        }

        @NotNull
        public List<CompletionItem> getCompletionItems() {
            List<CompletionItem> list = this.myCompletionItems;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackIntellisense$Response", "getCompletionItems"));
            }
            return list;
        }
    }

    private static class SizeLimitedCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int myMaxSize;

        private SizeLimitedCache(int max) {
            super((int)((double)max / 0.75) + 1, true);
            this.myMaxSize = max;
        }

        protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
            return this.size() > this.myMaxSize;
        }
    }
}

