/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ThrowableConsumer;
import org.jetbrains.idea.svn.history.LogEntry;
import org.tmatesoft.svn.core.SVNException;

public class SvnMergeSourceTracker {
    private int myMergeLevel;
    private ThrowableConsumer<Pair<LogEntry, Integer>, SVNException> myConsumer;

    public SvnMergeSourceTracker(ThrowableConsumer<Pair<LogEntry, Integer>, SVNException> consumer) {
        this.myConsumer = consumer;
        this.myMergeLevel = -1;
    }

    public void consume(LogEntry logEntry) throws SVNException {
        if (logEntry.getRevision() < 0L) {
            --this.myMergeLevel;
            return;
        }
        this.myConsumer.consume((Object)new Pair((Object)logEntry, (Object)this.myMergeLevel));
        if (logEntry.hasChildren()) {
            ++this.myMergeLevel;
        }
    }
}

