/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.metal.MetalIconFactory;

public class BasicFileChooserUI
extends FileChooserUI {
    protected int cancelButtonMnemonic;
    protected String cancelButtonText;
    protected String cancelButtonToolTipText;
    protected Icon computerIcon;
    protected Icon detailsViewIcon;
    protected Icon directoryIcon;
    protected int directoryOpenButtonMnemonic;
    protected String directoryOpenButtonText;
    protected String directoryOpenButtonToolTipText;
    protected Icon fileIcon;
    protected Icon floppyDriveIcon;
    protected Icon hardDriveIcon;
    protected int helpButtonMnemonic;
    protected String helpButtonText;
    protected String helpButtonToolTipText;
    protected Icon homeFolderIcon;
    protected Icon listViewIcon;
    protected Icon newFolderIcon;
    protected int openButtonMnemonic;
    protected String openButtonText;
    protected String openButtonToolTipText;
    protected int saveButtonMnemonic;
    protected String saveButtonText;
    protected String saveButtonToolTipText;
    protected int updateButtonMnemonic;
    protected String updateButtonText;
    protected String updateButtonToolTipText;
    protected Icon upFolderIcon;
    JFileChooser filechooser;
    BasicDirectoryModel model;
    FileFilter acceptAll;
    FileView fv;
    JButton accept;
    JPanel accessoryPanel;
    PropertyChangeListener propertyChangeListener;
    String acceptAllFileFilterText;
    String dirDescText;
    String fileDescText;
    boolean dirSelected;
    File currDir;
    JPanel bottomPanel;
    JPanel closePanel;
    JTextField entry;
    String parentPath;
    private ApproveSelectionAction approveSelectionAction;
    private CancelSelectionAction cancelSelectionAction;
    private GoHomeAction goHomeAction;
    private ChangeToParentDirectoryAction changeToParentDirectoryAction;
    private NewFolderAction newFolderAction;
    private UpdateAction updateAction;
    private File selectedDir;

    void closeDialog() {
        Window owner = SwingUtilities.windowForComponent(this.filechooser);
        if (owner instanceof JDialog) {
            ((JDialog)owner).dispose();
        }
    }

    public BasicFileChooserUI(JFileChooser b) {
        this.newFolderIcon = this.directoryIcon;
        this.acceptAll = new AcceptAllFileFilter();
        this.fv = new BasicFileView();
        this.accessoryPanel = new JPanel();
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicFileChooserUI((JFileChooser)c);
    }

    public void installUI(JComponent c) {
        if (c instanceof JFileChooser) {
            JFileChooser fc;
            this.filechooser = fc = (JFileChooser)c;
            fc.resetChoosableFileFilters();
            this.createModel();
            this.clearIconCache();
            this.installDefaults(fc);
            this.installComponents(fc);
            this.installListeners(fc);
            File path = this.filechooser.getCurrentDirectory();
            if (path != null) {
                this.parentPath = path.getParent();
            }
        }
    }

    public void uninstallUI(JComponent c) {
        this.model = null;
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        this.filechooser = null;
    }

    void boxEntries() {
        ArrayList<String> parentFiles = new ArrayList<String>();
        File parent = this.filechooser.getCurrentDirectory();
        if (parent == null) {
            parent = this.filechooser.getFileSystemView().getDefaultDirectory();
        }
        while (parent != null) {
            String name = parent.getName();
            if (name.equals("")) {
                name = parent.getAbsolutePath();
            }
            parentFiles.add(parentFiles.size(), name);
            parent = parent.getParentFile();
        }
        if (parentFiles.size() == 0) {
            return;
        }
    }

    public void installComponents(JFileChooser fc) {
    }

    public void uninstallComponents(JFileChooser fc) {
    }

    protected void installListeners(JFileChooser fc) {
        this.propertyChangeListener = this.createPropertyChangeListener(this.filechooser);
        if (this.propertyChangeListener != null) {
            this.filechooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        fc.addPropertyChangeListener(this.getModel());
    }

    protected void uninstallListeners(JFileChooser fc) {
        if (this.propertyChangeListener != null) {
            this.filechooser.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        fc.removePropertyChangeListener(this.getModel());
    }

    protected void installDefaults(JFileChooser fc) {
        this.installIcons(fc);
        this.installStrings(fc);
    }

    protected void uninstallDefaults(JFileChooser fc) {
        this.uninstallStrings(fc);
        this.uninstallIcons(fc);
    }

    protected void installIcons(JFileChooser fc) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.computerIcon = MetalIconFactory.getTreeComputerIcon();
        this.detailsViewIcon = defaults.getIcon("FileChooser.detailsViewIcon");
        this.directoryIcon = new MetalIconFactory.TreeFolderIcon();
        this.fileIcon = new MetalIconFactory.TreeLeafIcon();
        this.floppyDriveIcon = MetalIconFactory.getTreeFloppyDriveIcon();
        this.hardDriveIcon = MetalIconFactory.getTreeHardDriveIcon();
        this.homeFolderIcon = defaults.getIcon("FileChooser.homeFolderIcon");
        this.listViewIcon = defaults.getIcon("FileChooser.listViewIcon");
        this.newFolderIcon = defaults.getIcon("FileChooser.newFolderIcon");
        this.upFolderIcon = defaults.getIcon("FileChooser.upFolderIcon");
    }

    protected void uninstallIcons(JFileChooser fc) {
        this.computerIcon = null;
        this.detailsViewIcon = null;
        this.directoryIcon = null;
        this.fileIcon = null;
        this.floppyDriveIcon = null;
        this.hardDriveIcon = null;
        this.homeFolderIcon = null;
        this.listViewIcon = null;
        this.newFolderIcon = null;
        this.upFolderIcon = null;
    }

    protected void installStrings(JFileChooser fc) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.dirDescText = defaults.getString("FileChooser.directoryDescriptionText");
        this.fileDescText = defaults.getString("FileChooser.fileDescriptionText");
        this.acceptAllFileFilterText = defaults.getString("FileChooser.acceptAllFileFilterText");
        this.cancelButtonText = "Cancel";
        this.cancelButtonToolTipText = "Abort file chooser dialog";
        this.cancelButtonMnemonic = new Integer((String)UIManager.get("FileChooser.cancelButtonMnemonic"));
        this.directoryOpenButtonText = "Open";
        this.directoryOpenButtonToolTipText = "Open selected directory";
        this.directoryOpenButtonMnemonic = new Integer((String)UIManager.get("FileChooser.directoryOpenButtonMnemonic"));
        this.helpButtonText = "Help";
        this.helpButtonToolTipText = "FileChooser help";
        this.helpButtonMnemonic = new Integer((String)UIManager.get("FileChooser.helpButtonMnemonic"));
        this.openButtonText = "Open";
        this.openButtonToolTipText = "Open selected file";
        this.openButtonMnemonic = new Integer((String)UIManager.get("FileChooser.openButtonMnemonic"));
        this.saveButtonText = "Save";
        this.saveButtonToolTipText = "Save selected file";
        this.saveButtonMnemonic = new Integer((String)UIManager.get("FileChooser.saveButtonMnemonic"));
        this.updateButtonText = "Update";
        this.updateButtonToolTipText = "Update directory listing";
        this.updateButtonMnemonic = new Integer((String)UIManager.get("FileChooser.updateButtonMnemonic"));
    }

    protected void uninstallStrings(JFileChooser fc) {
        this.acceptAllFileFilterText = null;
        this.dirDescText = null;
        this.fileDescText = null;
        this.cancelButtonText = null;
        this.cancelButtonToolTipText = null;
        this.directoryOpenButtonText = null;
        this.directoryOpenButtonToolTipText = null;
        this.helpButtonText = null;
        this.helpButtonToolTipText = null;
        this.openButtonText = null;
        this.openButtonToolTipText = null;
        this.saveButtonText = null;
        this.saveButtonToolTipText = null;
        this.updateButtonText = null;
        this.updateButtonToolTipText = null;
    }

    protected void createModel() {
        this.model = new BasicDirectoryModel(this.filechooser);
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return null;
    }

    public String getFileName() {
        return this.entry.getText();
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String filename) {
    }

    public void setDirectoryName(String dirname) {
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().validateFileCache();
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.accept;
    }

    public String getApproveButtonToolTipText(JFileChooser fc) {
        if (fc.getApproveButtonToolTipText() != null) {
            return fc.getApproveButtonToolTipText();
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return this.openButtonToolTipText;
    }

    public void clearIconCache() {
        if (this.fv instanceof BasicFileView) {
            ((BasicFileView)this.fv).clearIconCache();
        }
    }

    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new SelectionListener();
    }

    protected MouseListener createDoubleClickListener(JFileChooser fc, JList list2) {
        return new DoubleClickListener(list2);
    }

    protected boolean isDirectorySelected() {
        return this.dirSelected;
    }

    protected void setDirectorySelected(boolean selected) {
        this.dirSelected = selected;
    }

    protected File getDirectory() {
        return this.currDir;
    }

    protected void setDirectory(File f) {
        this.currDir = f;
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser fc) {
        return this.acceptAll;
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fv;
    }

    public String getDialogTitle(JFileChooser fc) {
        String result = fc.getDialogTitle();
        if (result == null) {
            result = this.getApproveButtonText(fc);
        }
        return result;
    }

    public int getApproveButtonMnemonic(JFileChooser fc) {
        if (fc.getApproveButtonMnemonic() != 0) {
            return fc.getApproveButtonMnemonic();
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        return this.openButtonMnemonic;
    }

    public String getApproveButtonText(JFileChooser fc) {
        String result = fc.getApproveButtonText();
        if (result == null) {
            result = fc.getDialogType() == 1 ? this.saveButtonText : this.openButtonText;
        }
        return result;
    }

    public Action getNewFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new NewFolderAction();
        }
        return this.newFolderAction;
    }

    public Action getGoHomeAction() {
        if (this.goHomeAction == null) {
            this.goHomeAction = new GoHomeAction();
        }
        return this.goHomeAction;
    }

    public Action getChangeToParentDirectoryAction() {
        if (this.changeToParentDirectoryAction == null) {
            this.changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
        }
        return this.changeToParentDirectoryAction;
    }

    public Action getApproveSelectionAction() {
        if (this.approveSelectionAction == null) {
            this.approveSelectionAction = new ApproveSelectionAction();
        }
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        if (this.cancelSelectionAction == null) {
            this.cancelSelectionAction = new CancelSelectionAction();
        }
        return this.cancelSelectionAction;
    }

    public Action getUpdateAction() {
        if (this.updateAction == null) {
            this.updateAction = new UpdateAction();
        }
        return this.updateAction;
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return BasicFileChooserUI.this.acceptAllFileFilterText;
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
            super("approveSelection");
        }

        public void actionPerformed(ActionEvent e) {
            Object obj = null;
            obj = BasicFileChooserUI.this.parentPath != null ? new String(String.valueOf(BasicFileChooserUI.this.parentPath) + BasicFileChooserUI.this.getFileName()) : BasicFileChooserUI.this.filechooser.getSelectedFile();
            if (obj != null) {
                File f = BasicFileChooserUI.this.filechooser.getFileSystemView().createFileObject(obj.toString());
                File currSelected = BasicFileChooserUI.this.filechooser.getSelectedFile();
                if (BasicFileChooserUI.this.filechooser.isTraversable(f)) {
                    BasicFileChooserUI.this.filechooser.setCurrentDirectory(currSelected);
                    BasicFileChooserUI.this.filechooser.rescanCurrentDirectory();
                } else {
                    BasicFileChooserUI.this.filechooser.approveSelection();
                    BasicFileChooserUI.this.closeDialog();
                }
            } else {
                File f = new File(BasicFileChooserUI.this.filechooser.getCurrentDirectory(), BasicFileChooserUI.this.getFileName());
                if (BasicFileChooserUI.this.selectedDir != null) {
                    f = BasicFileChooserUI.this.selectedDir;
                }
                if (BasicFileChooserUI.this.filechooser.isTraversable(f)) {
                    BasicFileChooserUI.this.filechooser.setCurrentDirectory(f);
                    BasicFileChooserUI.this.filechooser.rescanCurrentDirectory();
                } else {
                    BasicFileChooserUI.this.filechooser.setSelectedFile(f);
                    BasicFileChooserUI.this.filechooser.approveSelection();
                    BasicFileChooserUI.this.closeDialog();
                }
            }
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable<File, Icon> iconCache = new Hashtable();

        public void cacheIcon(File f, Icon i) {
            this.iconCache.put(f, i);
        }

        public void clearIconCache() {
            this.iconCache.clear();
        }

        public Icon getCachedIcon(File f) {
            return this.iconCache.get(f);
        }

        public String getDescription(File f) {
            return this.getName(f);
        }

        public Icon getIcon(File f) {
            Icon val = this.getCachedIcon(f);
            if (val != null) {
                return val;
            }
            val = BasicFileChooserUI.this.filechooser.isTraversable(f) ? BasicFileChooserUI.this.directoryIcon : BasicFileChooserUI.this.fileIcon;
            this.cacheIcon(f, val);
            return val;
        }

        public String getName(File f) {
            String name = null;
            if (f != null) {
                JFileChooser c = BasicFileChooserUI.this.getFileChooser();
                FileSystemView v = c.getFileSystemView();
                name = v.getSystemDisplayName(f);
            }
            return name;
        }

        public String getTypeDescription(File f) {
            if (BasicFileChooserUI.this.filechooser.isTraversable(f)) {
                return BasicFileChooserUI.this.dirDescText;
            }
            return BasicFileChooserUI.this.fileDescText;
        }

        public Boolean isHidden(File f) {
            return BasicFileChooserUI.this.filechooser.getFileSystemView().isHiddenFile(f);
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
            super(null);
        }

        public void actionPerformed(ActionEvent e) {
            BasicFileChooserUI.this.filechooser.setSelectedFile(null);
            BasicFileChooserUI.this.filechooser.setSelectedFiles(null);
            BasicFileChooserUI.this.filechooser.cancelSelection();
            BasicFileChooserUI.this.closeDialog();
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
        }

        public void actionPerformed(ActionEvent e) {
            BasicFileChooserUI.this.filechooser.changeToParentDirectory();
            BasicFileChooserUI.this.filechooser.revalidate();
            BasicFileChooserUI.this.filechooser.repaint();
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        private Object lastSelected;
        private JList list;

        public DoubleClickListener(JList list2) {
            this.list = list2;
            this.lastSelected = list2.getSelectedValue();
            BasicFileChooserUI.this.setDirectorySelected(false);
        }

        public void mouseClicked(MouseEvent e) {
            Object p = this.list.getSelectedValue();
            if (p == null) {
                return;
            }
            FileSystemView fsv = BasicFileChooserUI.this.filechooser.getFileSystemView();
            if (e.getClickCount() >= 2 && this.lastSelected != null && p.toString().equals(this.lastSelected.toString())) {
                File f = fsv.createFileObject(this.lastSelected.toString());
                if (BasicFileChooserUI.this.filechooser.isTraversable(f)) {
                    BasicFileChooserUI.this.filechooser.setCurrentDirectory(f);
                    BasicFileChooserUI.this.filechooser.rescanCurrentDirectory();
                } else {
                    BasicFileChooserUI.this.filechooser.setSelectedFile(f);
                    BasicFileChooserUI.this.filechooser.approveSelection();
                    BasicFileChooserUI.this.closeDialog();
                }
            } else {
                String path = p.toString();
                File f = fsv.createFileObject(path);
                BasicFileChooserUI.this.filechooser.setSelectedFile(f);
                if (BasicFileChooserUI.this.filechooser.isMultiSelectionEnabled()) {
                    int[] inds = this.list.getSelectedIndices();
                    File[] allFiles = new File[inds.length];
                    int i = 0;
                    while (i < inds.length) {
                        allFiles[i] = (File)this.list.getModel().getElementAt(inds[i]);
                        ++i;
                    }
                    BasicFileChooserUI.this.filechooser.setSelectedFiles(allFiles);
                }
                if (BasicFileChooserUI.this.filechooser.isTraversable(f)) {
                    BasicFileChooserUI.this.setDirectorySelected(true);
                    BasicFileChooserUI.this.setDirectory(f);
                } else {
                    BasicFileChooserUI.this.setDirectorySelected(false);
                    BasicFileChooserUI.this.setDirectory(null);
                }
                this.lastSelected = path;
                BasicFileChooserUI.this.parentPath = f.getParent();
                if (f.isFile()) {
                    BasicFileChooserUI.this.setFileName(f.getName());
                } else if (BasicFileChooserUI.this.filechooser.getFileSelectionMode() != 0) {
                    BasicFileChooserUI.this.setFileName(path);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
        }

        public void actionPerformed(ActionEvent e) {
            BasicFileChooserUI.this.filechooser.setCurrentDirectory(BasicFileChooserUI.this.filechooser.getFileSystemView().getHomeDirectory());
            BasicFileChooserUI.this.filechooser.revalidate();
            BasicFileChooserUI.this.filechooser.repaint();
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                BasicFileChooserUI.this.filechooser.getFileSystemView().createNewFolder(BasicFileChooserUI.this.filechooser.getCurrentDirectory());
            }
            catch (IOException iOException) {
                return;
            }
            BasicFileChooserUI.this.filechooser.rescanCurrentDirectory();
            BasicFileChooserUI.this.filechooser.repaint();
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            JList list2 = (JList)e.getSource();
            Object f = list2.getSelectedValue();
            if (f == null) {
                return;
            }
            File file = BasicFileChooserUI.this.filechooser.getFileSystemView().createFileObject(f.toString());
            if (!BasicFileChooserUI.this.filechooser.isTraversable(file)) {
                BasicFileChooserUI.this.selectedDir = null;
                BasicFileChooserUI.this.filechooser.setSelectedFile(file);
            } else {
                BasicFileChooserUI.this.selectedDir = file;
                BasicFileChooserUI.this.filechooser.setSelectedFile(null);
            }
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
            super(null);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

