/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.LightweightPeer;
import java.util.WeakHashMap;

final class LightweightDispatcher {
    private static WeakHashMap instances = new WeakHashMap();
    private Component lastTarget;
    private Component mouseEventTarget;

    static LightweightDispatcher getInstance() {
        Thread t = Thread.currentThread();
        ThreadGroup tg = t.getThreadGroup();
        LightweightDispatcher instance = (LightweightDispatcher)instances.get(tg);
        if (instance == null) {
            instance = new LightweightDispatcher();
            instances.put(tg, instance);
        }
        return instance;
    }

    private LightweightDispatcher() {
    }

    public boolean dispatchEvent(AWTEvent event) {
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            return this.handleMouseEvent(mouseEvent);
        }
        return false;
    }

    private boolean handleMouseEvent(MouseEvent ev) {
        Container container = (Container)ev.getSource();
        Component target = this.findTarget(container, ev.getX(), ev.getY());
        this.trackEnterExit(target, ev);
        int id = ev.getID();
        if (!this.isDragging(ev) && id != 500) {
            Component component = this.mouseEventTarget = target != container ? target : null;
        }
        if (this.mouseEventTarget != null) {
            switch (id) {
                case 504: 
                case 505: {
                    break;
                }
                case 501: 
                case 502: 
                case 503: {
                    this.redispatch(ev, this.mouseEventTarget, id);
                    break;
                }
                case 500: {
                    if (target != this.mouseEventTarget) break;
                    this.redispatch(ev, this.mouseEventTarget, id);
                    break;
                }
                case 506: {
                    if (!this.isDragging(ev)) break;
                    this.redispatch(ev, this.mouseEventTarget, id);
                    break;
                }
                case 507: {
                    this.redispatch(ev, this.mouseEventTarget, id);
                }
            }
            ev.consume();
        }
        return ev.isConsumed();
    }

    private Component findTarget(Container c, int x, int y) {
        Component target = null;
        int nChildren = c.ncomponents;
        int i = 0;
        while (i < nChildren && target == null) {
            Component child = c.component[i];
            int childX = x - child.x;
            int childY = y - child.y;
            if (child != null && child.visible && child.peer instanceof LightweightPeer && child.contains(childX, childY)) {
                if (child instanceof Container) {
                    Component deeper = this.findTarget((Container)child, childX, childY);
                    if (deeper != null) {
                        target = deeper;
                    }
                } else if (this.isMouseListening(child)) {
                    target = child;
                }
            }
            ++i;
        }
        if (target == null && c.contains(x, y) && this.isMouseListening(c)) {
            target = c;
        }
        return target;
    }

    private boolean isMouseListening(Component c) {
        return c.mouseListener != null || c.mouseMotionListener != null || c.mouseWheelListener != null || (c.eventMask & 0x10L) != 0L || (c.eventMask & 0x20L) != 0L || (c.eventMask & 0x20000L) != 0L;
    }

    private void trackEnterExit(Component target, MouseEvent ev) {
        int id = ev.getID();
        if (target != this.lastTarget) {
            if (this.lastTarget != null) {
                this.redispatch(ev, this.lastTarget, 505);
            }
            if (id == 505) {
                ev.consume();
            }
            if (target != null) {
                this.redispatch(ev, target, 504);
            }
            if (id == 504) {
                ev.consume();
            }
            this.lastTarget = target;
        }
    }

    private void redispatch(MouseEvent ev, Component target, int id) {
        Component source = ev.getComponent();
        assert (target != null);
        if (target.isShowing()) {
            MouseEvent retargeted;
            int x = ev.getX();
            int y = ev.getY();
            Component c = target;
            while (c != null && c != source) {
                x -= c.x;
                y -= c.y;
                c = c.getParent();
            }
            if (id == 507) {
                MouseWheelEvent mwe = (MouseWheelEvent)ev;
                retargeted = new MouseWheelEvent(target, id, ev.getWhen(), ev.getModifiers() | ev.getModifiersEx(), x, y, ev.getClickCount(), ev.isPopupTrigger(), mwe.getScrollType(), mwe.getScrollAmount(), mwe.getWheelRotation());
            } else {
                retargeted = new MouseEvent(target, id, ev.getWhen(), ev.getModifiers() | ev.getModifiersEx(), x, y, ev.getClickCount(), ev.isPopupTrigger(), ev.getButton());
            }
            if (target == source) {
                ((Container)target).dispatchNoLightweight(retargeted);
            } else {
                target.dispatchEvent(retargeted);
            }
        }
    }

    private boolean isDragging(MouseEvent ev) {
        int mods = ev.getModifiersEx();
        int id = ev.getID();
        if (id == 501 || id == 502) {
            switch (ev.getButton()) {
                case 1: {
                    mods ^= 0x400;
                    break;
                }
                case 2: {
                    mods ^= 0x800;
                    break;
                }
                case 3: {
                    mods ^= 0x1000;
                }
            }
        }
        return (mods & 0x1C00) != 0;
    }
}

