/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Choice
extends Component
implements ItemSelectable,
Serializable,
Accessible {
    private static transient long next_choice_number;
    private static final long serialVersionUID = -4075310674757313071L;
    Vector pItems = new Vector();
    private int selectedIndex = -1;
    private ItemListener item_listeners;

    public Choice() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int index) {
        return (String)this.pItems.elementAt(index);
    }

    public synchronized void add(String item) {
        if (item == null) {
            throw new NullPointerException("item must be non-null");
        }
        this.pItems.addElement(item);
        if (this.peer != null) {
            ((ChoicePeer)this.peer).add(item, this.getItemCount() - 1);
        }
        if (this.selectedIndex == -1) {
            this.select(0);
        }
    }

    public synchronized void addItem(String item) {
        this.add(item);
    }

    public synchronized void insert(String item, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index may not be less then 0");
        }
        if (index > this.getItemCount()) {
            index = this.getItemCount();
        }
        this.pItems.insertElementAt(item, index);
        if (this.peer != null) {
            ((ChoicePeer)this.peer).add(item, index);
        }
        if (this.selectedIndex == -1 || this.selectedIndex >= index) {
            this.select(0);
        }
    }

    public synchronized void remove(String item) {
        int index = this.pItems.indexOf(item);
        if (index == -1) {
            throw new IllegalArgumentException("item \"" + item + "\" not found in Choice");
        }
        this.remove(index);
    }

    public synchronized void remove(int index) {
        this.pItems.removeElementAt(index);
        if (this.peer != null) {
            ((ChoicePeer)this.peer).remove(index);
        }
        if (this.getItemCount() == 0) {
            this.selectedIndex = -1;
        } else {
            if (this.selectedIndex > index) {
                --this.selectedIndex;
            } else if (this.selectedIndex == index) {
                this.selectedIndex = 0;
            }
            if (this.peer != null) {
                ((ChoicePeer)this.peer).select(this.selectedIndex);
            }
        }
    }

    public synchronized void removeAll() {
        if (this.getItemCount() <= 0) {
            return;
        }
        this.pItems.removeAllElements();
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.removeAll();
        }
        this.selectedIndex = -1;
    }

    public synchronized String getSelectedItem() {
        return this.selectedIndex == -1 ? null : (String)this.pItems.elementAt(this.selectedIndex);
    }

    @Override
    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex == -1) {
            return null;
        }
        Object[] objs = new Object[]{this.pItems.elementAt(this.selectedIndex)};
        return objs;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + index);
        }
        if (this.selectedIndex == index) {
            return;
        }
        this.selectedIndex = index;
        if (this.peer != null) {
            ((ChoicePeer)this.peer).select(index);
        }
    }

    public synchronized void select(String item) {
        int index = this.pItems.indexOf(item);
        if (index >= 0) {
            this.select(index);
        }
    }

    @Override
    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createChoice(this);
        }
        super.addNotify();
    }

    @Override
    public synchronized void addItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, listener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, listener);
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    @Override
    void dispatchEventImpl(AWTEvent e) {
        super.dispatchEventImpl(e);
        if (e.id <= 701 && e.id >= 701 && (this.item_listeners != null || (this.eventMask & 0x200L) != 0L)) {
            this.processEvent(e);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        this.pItems.indexOf((String)event.getItem());
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(event);
        }
    }

    @Override
    protected String paramString() {
        return "selectedIndex=" + this.selectedIndex + "," + super.paramString();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == ItemListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.item_listeners, listenerType);
        }
        return super.getListeners(listenerType);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTChoice();
        }
        return this.accessibleContext;
    }

    @Override
    String generateName() {
        return "choice" + Choice.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_choice_number++;
    }

    protected class AccessibleAWTChoice
    extends Component.AccessibleAWTComponent
    implements AccessibleAction {
        private static final long serialVersionUID = 7175603582428509322L;

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public int getAccessibleActionCount() {
            return Choice.this.pItems.size();
        }

        public String getAccessibleActionDescription(int i) {
            return (String)Choice.this.pItems.get(i);
        }

        public boolean doAccessibleAction(int i) {
            if (i < 0 || i >= Choice.this.pItems.size()) {
                return false;
            }
            Choice.this.select(i);
            return true;
        }
    }
}

