/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.util.Enumeration;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public final class DomParser
implements XMLReader {
    private DefaultHandler2 defaultHandler = new DefaultHandler2();
    private ContentHandler contentHandler = this.defaultHandler;
    private DTDHandler dtdHandler = this.defaultHandler;
    private DeclHandler declHandler = this.defaultHandler;
    private LexicalHandler lexicalHandler = this.defaultHandler;
    private ErrorHandler errHandler = this.defaultHandler;
    private EntityResolver resolver = this.defaultHandler;
    private Locale locale = Locale.getDefault();
    private Node start;
    private Node current;
    private boolean isL2;
    private boolean showNamespaces = true;
    private boolean showXML1_0 = false;
    private NamespaceSupport prefixStack = new NamespaceSupport();
    private boolean isDocument;
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String HANDLERS = "http://xml.org/sax/properties/";

    public DomParser() {
    }

    public DomParser(Node node2) {
        this.setStart(node2);
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        if (resolver == null) {
            resolver = this.defaultHandler;
        }
        this.resolver = resolver;
    }

    public void setLocale(Locale locale) throws SAXException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            handler = this.defaultHandler;
        }
        this.errHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            handler = this.defaultHandler;
        }
        this.contentHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler handler) {
        if (handler == null) {
            handler = this.defaultHandler;
        }
        this.dtdHandler = handler;
    }

    public void parse(String uri) throws SAXException {
        this.parse();
    }

    public void parse(InputSource input) throws SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        try {
            this.walk();
        }
        finally {
            if (this.isDocument) {
                this.contentHandler.endDocument();
            }
            this.current = null;
            this.prefixStack.reset();
        }
    }

    private boolean getIsL2(Node node2) {
        Document doc = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
        if (doc == null) {
            throw new RuntimeException("? unowned node - L2 DTD ?");
        }
        DOMImplementation impl = doc.getImplementation();
        return impl.hasFeature("XML", "2.0");
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(name) || "http://xml.org/sax/features/external-general-entities".equals(name) || "http://xml.org/sax/features/external-parameter-entities".equals(name) || "http://xml.org/sax/features/string-interning".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.showNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.showXML1_0;
        }
        throw new SAXNotRecognizedException(name);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            return this.declHandler == this.defaultHandler ? null : this.declHandler;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.lexicalHandler == this.defaultHandler ? null : this.lexicalHandler;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(name)) {
            return this.current;
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setFeature(String name, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.current != null) {
            throw new IllegalStateException("feature change midparse");
        }
        boolean value = this.getFeature(name);
        if (value == state) {
            return;
        }
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            if (!this.showXML1_0 && !state) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showNamespaces = state;
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            if (!this.showNamespaces && !state) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showXML1_0 = state;
            return;
        }
        throw new SAXNotSupportedException(name);
    }

    public void setProperty(String name, Object state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            if (!(state instanceof DeclHandler) && state != null) {
                throw new SAXNotSupportedException(name);
            }
            this.declHandler = (DeclHandler)state;
            return;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            if (!(state instanceof LexicalHandler) && state != null) {
                throw new SAXNotSupportedException(name);
            }
            this.lexicalHandler = (LexicalHandler)state;
            return;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(name)) {
            if (state == null || state instanceof Node) {
                if (this.current != null) {
                    throw new SAXNotSupportedException("property is readonly during parse:  " + name);
                }
                this.setStart((Node)state);
                return;
            }
            throw new SAXNotSupportedException("not a DOM Node");
        }
        throw new SAXNotRecognizedException(name);
    }

    private void setStart(Node property) {
        this.start = property;
        if (this.start != null) {
            this.isL2 = this.getIsL2(this.start);
            this.isDocument = this.start instanceof Document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void walk() throws SAXException {
        attrs = new AttributesImpl();
        var8_2 = this;
        synchronized (var8_2) {
            if (this.current != null) {
                throw new IllegalStateException("already walking tree");
            }
            this.current = this.start;
        }
        block17: while (true) {
            type = this.current.getNodeType();
            switch (type) {
                case 9: {
                    this.contentHandler.startDocument();
                    break;
                }
                case 1: {
                    nodes = this.current.getAttributes();
                    length = nodes.getLength();
                    this.prefixStack.pushContext();
                    i = 0;
                    while (i < length) {
                        attr = (Attr)nodes.item(i);
                        name = attr.getNodeName();
                        if (!this.showNamespaces || !name.startsWith("xmlns")) ** GOTO lbl32
                        prefix = "xmlns".equals(name) != false ? "" : name.substring(6);
                        uri = attr.getNodeValue();
                        this.prefixStack.declarePrefix(prefix, uri);
                        this.contentHandler.startPrefixMapping(prefix, uri);
                        if (!this.showXML1_0) ** GOTO lbl44
lbl32:
                        // 2 sources

                        if (!this.showNamespaces) ** GOTO lbl41
                        if (this.isL2) {
                            ns = attr.getNamespaceURI();
                            if (ns == null) {
                                ns = "";
                            }
                            if ((local = attr.getLocalName()) == null) {
                                local = name;
                            }
                        } else {
                            throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
lbl41:
                            // 1 sources

                            local = "";
                            ns = "";
                        }
                        attrs.addAttribute(ns, local, name, "CDATA", attr.getNodeValue());
lbl44:
                        // 2 sources

                        ++i;
                    }
                    if (!this.showNamespaces) ** GOTO lbl55
                    if (this.isL2) {
                        ns = this.current.getNamespaceURI();
                        if (ns == null) {
                            ns = "";
                        }
                        if ((local = this.current.getLocalName()) == null) {
                            local = this.current.getNodeName();
                        }
                    } else {
                        throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
lbl55:
                        // 1 sources

                        local = "";
                        ns = "";
                    }
                    this.contentHandler.startElement(ns, local, this.current.getNodeName(), attrs);
                    if (length == 0) break;
                    attrs.clear();
                    break;
                }
                case 4: {
                    this.lexicalHandler.startCDATA();
                    chars = this.current.getNodeValue().toCharArray();
                    this.contentHandler.characters(chars, 0, chars.length);
                    this.lexicalHandler.endCDATA();
                    break;
                }
                case 8: {
                    chars = this.current.getNodeValue().toCharArray();
                    this.lexicalHandler.comment(chars, 0, chars.length);
                    break;
                }
                case 10: {
                    doctype = (DocumentType)this.current;
                    if (this.isL2) {
                        this.lexicalHandler.startDTD(doctype.getName(), doctype.getPublicId(), doctype.getSystemId());
                    } else {
                        this.lexicalHandler.startDTD(doctype.getName(), null, null);
                    }
                    message = this.isL2 != false && doctype.getInternalSubset() != null ? " Full DTD known; can't be shown using SAX2. " : " This DTD was was recreated using incomplete DOM L2 records. ";
                    buf = message.toCharArray();
                    this.lexicalHandler.comment(buf, 0, buf.length);
                    nodes = doctype.getNotations();
                    length = nodes.getLength();
                    i = 0;
                    while (i < length) {
                        notation = (Notation)nodes.item(i);
                        this.dtdHandler.notationDecl(notation.getNodeName(), notation.getPublicId(), notation.getSystemId());
                        ++i;
                    }
                    nodes = doctype.getEntities();
                    length = nodes.getLength();
                    i = 0;
                    while (i < length) {
                        entity = (Entity)nodes.item(i);
                        notation = entity.getNotationName();
                        if (notation != null) {
                            this.dtdHandler.unparsedEntityDecl(entity.getNodeName(), entity.getPublicId(), entity.getSystemId(), notation);
                        } else if (entity.getSystemId() != null) {
                            this.declHandler.externalEntityDecl(entity.getNodeName(), entity.getPublicId(), entity.getSystemId());
                        }
                        ++i;
                    }
                    this.lexicalHandler.endDTD();
                    break;
                }
                case 5: {
                    this.lexicalHandler.startEntity(this.current.getNodeName());
                    break;
                }
                case 7: {
                    this.contentHandler.processingInstruction(this.current.getNodeName(), this.current.getNodeValue());
                    break;
                }
                case 3: {
                    chars = this.current.getNodeValue().toCharArray();
                    this.contentHandler.characters(chars, 0, chars.length);
                    break;
                }
                default: {
                    throw new SAXException("Illegal DOM Node type in Document:  " + this.current.getNodeType());
                }
            }
            switch (type) {
                case 1: 
                case 5: 
                case 9: {
                    next = this.current.getFirstChild();
                    if (next != null) {
                        this.current = next;
                        continue block17;
                    }
                    this.callEnd(this.current);
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    while ((next = this.current.getNextSibling()) == null) {
                        this.current = this.current.getParentNode();
                        if (this.current == null || this.current == this.start) {
                            return;
                        }
                        this.callEnd(this.current);
                    }
                    this.current = next;
                    continue block17;
                }
            }
            break;
        }
        throw new SAXException("Illegal DOM Node type found:  " + this.current.getNodeType());
    }

    private void callEnd(Node node2) throws SAXException {
        switch (node2.getNodeType()) {
            case 9: {
                return;
            }
            case 1: {
                if (this.showNamespaces) {
                    if (!this.isL2) {
                        throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                    }
                    this.contentHandler.endElement(node2.getNamespaceURI(), node2.getLocalName(), node2.getNodeName());
                    Enumeration e = this.prefixStack.getDeclaredPrefixes();
                    while (e.hasMoreElements()) {
                        this.contentHandler.endPrefixMapping((String)e.nextElement());
                    }
                } else {
                    this.contentHandler.endElement("", "", node2.getNodeName());
                }
                this.prefixStack.popContext();
                return;
            }
            case 5: {
                this.lexicalHandler.endEntity(node2.getNodeName());
                return;
            }
            case 2: 
            case 11: {
                return;
            }
        }
        throw new SAXException("Illegal DOM container type found:  " + this.current.getNodeType());
    }
}

