/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.pkcs;

import gnu.java.security.OID;
import gnu.java.security.ber.BER;
import gnu.java.security.ber.BEREncodingException;
import gnu.java.security.ber.BERReader;
import gnu.java.security.ber.BERValue;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.pkcs.PKCS7Data;
import gnu.java.security.pkcs.SignerInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;

public class PKCS7SignedData {
    private static final Logger log = null;
    public static final OID PKCS7_SIGNED_DATA = new OID("1.2.840.113549.1.7.2");
    private BigInteger version;
    private Set digestAlgorithms;
    private OID contentType;
    private byte[] content;
    private Certificate[] certificates;
    private CRL[] crls;
    private Set signerInfos;

    public PKCS7SignedData(InputStream in) throws CRLException, CertificateException, IOException {
        this(new BERReader(in));
    }

    public PKCS7SignedData(BERReader ber) throws CRLException, CertificateException, IOException {
        int i;
        CertificateFactory x509 = CertificateFactory.getInstance("X509");
        DERValue val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed ContentInfo");
        }
        val = ber.read();
        if (val.getTag() != 6) {
            throw new BEREncodingException("malformed ContentType");
        }
        if (!PKCS7_SIGNED_DATA.equals(val.getValue())) {
            throw new BEREncodingException("content is not SignedData");
        }
        val = ber.read();
        if (val.getTag() != 0) {
            throw new BEREncodingException("malformed Content");
        }
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed SignedData");
        }
        val = ber.read();
        if (val.getTag() != 2) {
            throw new BEREncodingException("expecting Version");
        }
        this.version = (BigInteger)val.getValue();
        this.digestAlgorithms = new HashSet();
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed DigestAlgorithmIdentifiers");
        }
        int count = 0;
        DERValue val2 = ber.read();
        while (val2 != BER.END_OF_SEQUENCE && val.getLength() > 0 && val.getLength() > count) {
            if (!val2.isConstructed()) {
                throw new BEREncodingException("malformed AlgorithmIdentifier");
            }
            count += val2.getEncodedLength();
            val2 = ber.read();
            if (val2.getTag() != 6) {
                throw new BEREncodingException("malformed AlgorithmIdentifier");
            }
            ArrayList<Object> algId = new ArrayList<Object>(2);
            algId.add(val2.getValue());
            val2 = ber.read();
            if (val2 != BER.END_OF_SEQUENCE) {
                count += val2.getEncodedLength();
                if (val2.getTag() == 5) {
                    algId.add(null);
                } else {
                    algId.add(val2.getEncoded());
                }
                if (val2.isConstructed()) {
                    ber.skip(val2.getLength());
                }
                if (BERValue.isIndefinite(val)) {
                    val2 = ber.read();
                }
            } else {
                algId.add(null);
            }
            this.digestAlgorithms.add(algId);
        }
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed ContentInfo");
        }
        val2 = ber.read();
        if (val2.getTag() != 6) {
            throw new BEREncodingException("malformed ContentType");
        }
        this.contentType = (OID)val2.getValue();
        if ((BERValue.isIndefinite(val) || val.getLength() > 0 && val.getLength() > val2.getEncodedLength()) && (val2 = ber.read()) != BER.END_OF_SEQUENCE) {
            this.content = val2.getEncoded();
            if (BERValue.isIndefinite(val)) {
                val2 = ber.read();
            }
        }
        if ((val = ber.read()).getTag() == 0) {
            if (!val.isConstructed()) {
                throw new BEREncodingException("malformed ExtendedCertificatesAndCertificates");
            }
            count = 0;
            val2 = ber.read();
            LinkedList<Certificate> certs = new LinkedList<Certificate>();
            while (val2 != BER.END_OF_SEQUENCE && val.getLength() > 0 && val.getLength() > count) {
                Certificate cert = x509.generateCertificate(new ByteArrayInputStream(val2.getEncoded()));
                certs.add(cert);
                ber.skip(val2.getLength());
                if (!BERValue.isIndefinite(val) && val.getLength() <= (count += val2.getEncodedLength())) continue;
                val2 = ber.read();
            }
            this.certificates = certs.toArray((T[])new Certificate[certs.size()]);
            val = ber.read();
        }
        if (val.getTag() == 1) {
            if (!val.isConstructed()) {
                throw new BEREncodingException("malformed CertificateRevocationLists");
            }
            count = 0;
            val2 = ber.read();
            LinkedList<CRL> crls = new LinkedList<CRL>();
            while (val2 != BER.END_OF_SEQUENCE && val.getLength() > 0 && val.getLength() > count) {
                CRL crl = x509.generateCRL(new ByteArrayInputStream(val2.getEncoded()));
                crls.add(crl);
                ber.skip(val2.getLength());
                if (!BERValue.isIndefinite(val) && val.getLength() <= (count += val2.getEncodedLength())) continue;
                val2 = ber.read();
            }
            this.crls = crls.toArray((T[])new CRL[crls.size()]);
            val = ber.read();
        }
        this.signerInfos = new HashSet();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed SignerInfos");
        }
        while ((i = ber.peek()) != 0 && i != -1) {
            this.signerInfos.add(new SignerInfo(ber));
        }
    }

    public PKCS7SignedData(Set digestAlgorithms, PKCS7Data data, Certificate[] certificates, X509CRL[] crls, Set signerInfos) {
        this.version = BigInteger.ONE;
        this.digestAlgorithms = digestAlgorithms;
        this.contentType = PKCS7_SIGNED_DATA;
        this.content = data == null ? null : data.getEncoded();
        this.certificates = certificates;
        this.crls = crls;
        this.signerInfos = signerInfos;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public Certificate[] getCertificates() {
        return this.certificates != null ? (Certificate[])this.certificates.clone() : null;
    }

    public OID getContentType() {
        return this.contentType;
    }

    public byte[] getContent() {
        return this.content != null ? (byte[])this.content.clone() : null;
    }

    public Set getDigestAlgorithms() {
        return Collections.unmodifiableSet(this.digestAlgorithms);
    }

    public Set getSignerInfos() {
        HashSet copy = new HashSet();
        Iterator it = this.signerInfos.iterator();
        while (it.hasNext()) {
            copy.add(it.next());
        }
        return Collections.unmodifiableSet(copy);
    }

    public void encode(OutputStream out) throws IOException, CRLException, CertificateEncodingException {
        DERValue derVersion = new DERValue(2, this.version);
        DERValue derDigestAlgorithms = new DERValue(49, this.digestAlgorithms);
        DERValue derContentType = new DERValue(6, PKCS7Data.PKCS7_DATA);
        ArrayList<Object> contentInfo = new ArrayList<Object>(2);
        contentInfo.add(derContentType);
        if (this.content == null) {
            contentInfo.add(new DERValue(5, null));
        } else {
            contentInfo.add(this.content);
        }
        DERValue derContentInfo = new DERValue(48, contentInfo);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        int i = 0;
        while (i < this.certificates.length) {
            baos.write(this.certificates[i].getEncoded());
            ++i;
        }
        baos.flush();
        byte[] b = baos.toByteArray();
        DERValue derExtendedCertificatesAndCertificates = new DERValue(160, b.length, b, null);
        DERValue derCertificateRevocationLists = null;
        if (this.crls != null && this.crls.length > 0) {
            baos.reset();
            int i2 = 0;
            while (i2 < this.crls.length) {
                baos.write(((X509CRL)this.crls[i2]).getEncoded());
                ++i2;
            }
            baos.flush();
            byte[] b2 = baos.toByteArray();
            derCertificateRevocationLists = new DERValue(161, b2.length, b2, null);
        }
        baos.reset();
        for (SignerInfo signerInfo : this.signerInfos) {
            signerInfo.encode(baos);
        }
        baos.flush();
        byte[] b3 = baos.toByteArray();
        DERValue derSignerInfos = new DERValue(49, b3.length, b3, null);
        ArrayList<DERValue> signedData = new ArrayList<DERValue>(6);
        signedData.add(derVersion);
        signedData.add(derDigestAlgorithms);
        signedData.add(derContentInfo);
        signedData.add(derExtendedCertificatesAndCertificates);
        if (derCertificateRevocationLists != null) {
            signedData.add(derCertificateRevocationLists);
        }
        signedData.add(derSignerInfos);
        DERValue derSignedData = new DERValue(48, signedData);
        ArrayList<DERValue> outer = new ArrayList<DERValue>(3);
        outer.add(new DERValue(6, PKCS7_SIGNED_DATA));
        outer.add(new DERValue(128, null));
        outer.add(derSignedData);
        DERValue derOuter = new DERValue(48, outer);
        DERWriter.write(out, derOuter);
    }
}

