/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.EventManager;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.processor.PacketProcessor;
import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.JdwpConnection;
import gnu.classpath.jdwp.transport.TransportException;
import gnu.classpath.jdwp.transport.TransportFactory;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;

public class Jdwp
extends Thread {
    private static Jdwp _instance = null;
    public static boolean isDebugging = false;
    private PacketProcessor _packetProcessor;
    private Thread _ppThread;
    private HashMap _properties;
    private static final String _PROPERTY_SUSPEND = "suspend";
    private JdwpConnection _connection;
    private boolean _shutdown = false;
    private ThreadGroup _group;
    private Object _initLock = new Object();
    private int _initCount = 0;

    public Jdwp() {
        _instance = this;
    }

    public static Jdwp getDefault() {
        return _instance;
    }

    public ThreadGroup getJdwpThreadGroup() {
        return this._group;
    }

    public static boolean suspendOnStartup() {
        String suspend;
        Jdwp jdwp = Jdwp.getDefault();
        return jdwp != null && (suspend = (String)jdwp._properties.get(_PROPERTY_SUSPEND)) != null && suspend.equals("y");
    }

    public void configure(String configArgs) {
        this._processConfigury(configArgs);
    }

    private void _doInitialization() throws TransportException {
        this._group = new ThreadGroup("JDWP threads");
        ITransport transport = TransportFactory.newInstance(this._properties);
        this._connection = new JdwpConnection(this._group, transport);
        this._connection.initialize();
        this._connection.start();
        this._packetProcessor = new PacketProcessor(this._connection);
        this._ppThread = new Thread(this._group, new Runnable(){

            public void run() {
                AccessController.doPrivileged(Jdwp.this._packetProcessor);
            }
        }, "packet processor");
        this._ppThread.start();
    }

    public void shutdown() {
        if (!this._shutdown) {
            this._packetProcessor.shutdown();
            this._ppThread.interrupt();
            this._connection.shutdown();
            this._shutdown = true;
            isDebugging = false;
            this.interrupt();
        }
    }

    public static void notify(Event event) {
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp != null) {
            EventManager em = EventManager.getDefault();
            EventRequest[] requests = em.getEventRequests(event);
            int i = 0;
            while (i < requests.length) {
                try {
                    Jdwp.sendEvent(requests[i], event);
                    jdwp._enforceSuspendPolicy(requests[i].getSuspendPolicy());
                }
                catch (Exception e) {
                    System.out.println("Jdwp.notify: caught exception: " + e);
                }
                ++i;
            }
        }
    }

    public static void notify(Event[] events) {
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp != null) {
            EventRequest[] r;
            byte suspendPolicy = 0;
            EventManager em = EventManager.getDefault();
            ArrayList<Event> allEvents = new ArrayList<Event>();
            ArrayList<EventRequest> allRequests = new ArrayList<EventRequest>();
            int i = 0;
            while (i < events.length) {
                r = em.getEventRequests(events[i]);
                int j = 0;
                while (j < r.length) {
                    allEvents.add(events[i]);
                    allRequests.add(r[j]);
                    if (r[j].getSuspendPolicy() > suspendPolicy) {
                        suspendPolicy = r[j].getSuspendPolicy();
                    }
                    ++j;
                }
                ++i;
            }
            try {
                Event[] e = new Event[allEvents.size()];
                allEvents.toArray(e);
                r = new EventRequest[allRequests.size()];
                allRequests.toArray(r);
                Jdwp.sendEvents(r, e, suspendPolicy);
                jdwp._enforceSuspendPolicy(suspendPolicy);
            }
            catch (Exception e) {
                System.out.println("Jdwp.notify: caught exception: " + e);
            }
        }
    }

    public static void sendEvent(EventRequest request, Event event) throws IOException {
        Jdwp.sendEvents(new EventRequest[]{request}, new Event[]{event}, request.getSuspendPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendEvents(EventRequest[] requests, Event[] events, byte suspendPolicy) throws IOException {
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp != null) {
            JdwpConnection jdwpConnection = jdwp._connection;
            synchronized (jdwpConnection) {
                jdwp._connection.sendEvents(requests, events, suspendPolicy);
            }
        }
    }

    private void _enforceSuspendPolicy(byte suspendPolicy) throws JdwpException {
        switch (suspendPolicy) {
            case 0: {
                break;
            }
            case 1: {
                VMVirtualMachine.suspendThread(Thread.currentThread());
                break;
            }
            case 2: {
                VMVirtualMachine.suspendAllThreads();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subcomponentInitialized() {
        Object object = this._initLock;
        synchronized (object) {
            ++this._initCount;
            this._initLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this._doInitialization();
            Object object = this._initLock;
            synchronized (object) {
                while (this._initCount != 2) {
                    this._initLock.wait();
                }
            }
            this._initLock = null;
        }
        catch (Throwable t) {
            System.out.println("Exception in JDWP back-end: " + t);
            System.exit(1);
        }
        EventManager.getDefault();
        isDebugging = true;
    }

    private void _processConfigury(String configString) {
        this._properties = new HashMap();
        String[] options = configString.split(",");
        int i = 0;
        while (i < options.length) {
            String[] property = options[i].split("=");
            if (property.length == 2) {
                this._properties.put(property[0], property[1]);
            }
            ++i;
        }
    }
}

