/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.eval.EvaluationManager;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;

public class JavaEvaluationEngineManager
implements IDebugEventSetListener {
    HashMap fTargetMap = new HashMap();

    public JavaEvaluationEngineManager() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        int numEvents = events.length;
        while (i < numEvents) {
            HashMap map;
            DebugEvent event = events[i];
            if (event.getKind() == 8 && event.getSource() instanceof IJavaDebugTarget && (map = (HashMap)this.fTargetMap.remove(event.getSource())) != null) {
                Iterator iter = map.values().iterator();
                while (iter.hasNext()) {
                    ((IAstEvaluationEngine)iter.next()).dispose();
                }
                map.clear();
            }
            ++i;
        }
    }

    public IAstEvaluationEngine getEvaluationEngine(IJavaProject project, IJavaDebugTarget target) {
        IAstEvaluationEngine engine = null;
        HashMap<IJavaProject, IAstEvaluationEngine> map = (HashMap<IJavaProject, IAstEvaluationEngine>)this.fTargetMap.get(target);
        if (map == null) {
            map = new HashMap<IJavaProject, IAstEvaluationEngine>();
            this.fTargetMap.put(target, map);
        }
        if ((engine = (IAstEvaluationEngine)map.get(project)) == null) {
            engine = EvaluationManager.newAstEvaluationEngine(project, target);
            map.put(project, engine);
        }
        return engine;
    }

    public void dispose() {
        for (HashMap engines : this.fTargetMap.values()) {
            for (IAstEvaluationEngine engine : engines.values()) {
                engine.dispose();
            }
            engines.clear();
        }
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }
}

