/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.io.IOException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaCodeReader;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.SourceViewerInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public class JavaSourceHover
extends AbstractJavaEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    protected String getHoverInfo(IJavaElement[] result) {
        int nResults = result.length;
        if (nResults > 1) {
            return null;
        }
        IJavaElement curr = result[0];
        if ((curr instanceof IMember || curr instanceof ILocalVariable || curr instanceof ITypeParameter) && curr instanceof ISourceReference) {
            String source;
            block7: {
                try {
                    source = ((ISourceReference)curr).getSource();
                    if (source != null) break block7;
                    return null;
                }
                catch (JavaModelException javaModelException) {}
            }
            source = this.removeLeadingComments(source);
            String delim = StubUtility.getLineDelimiterUsed(result[0]);
            String[] sourceLines = Strings.convertIntoLines(source);
            String firstLine = sourceLines[0];
            if (!Character.isWhitespace(firstLine.charAt(0))) {
                sourceLines[0] = "";
            }
            Strings.trimIndentation(sourceLines, curr.getJavaProject());
            if (!Character.isWhitespace(firstLine.charAt(0))) {
                sourceLines[0] = firstLine;
            }
            source = Strings.concatenate(sourceLines, delim);
            return source;
        }
        return null;
    }

    private String removeLeadingComments(String source) {
        int i;
        JavaCodeReader reader = new JavaCodeReader();
        Document document = new Document(source);
        try {
            try {
                reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                int c = reader.read();
                while (c != -1 && (c == 13 || c == 10)) {
                    c = reader.read();
                }
                i = reader.getOffset();
                reader.close();
            }
            catch (IOException iOException) {
                i = 0;
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                JavaPlugin.log(ex);
            }
        }
        if (i < 0) {
            return source;
        }
        return source.substring(i);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                IEditorPart editor = JavaSourceHover.this.getEditor();
                int shellStyle = 12;
                if (editor instanceof IWorkbenchPartOrientation) {
                    shellStyle |= ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                return new SourceViewerInformationControl(parent, shellStyle, 0, JavaSourceHover.this.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = 768;
                int shellStyle = 20;
                IEditorPart editor = JavaSourceHover.this.getEditor();
                if (editor instanceof IWorkbenchPartOrientation) {
                    shellStyle |= ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                return new SourceViewerInformationControl(parent, shellStyle, style);
            }
        };
    }
}

