/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.text.edits.TextEditGroup;

public class VariableDeclarationRewrite {
    public static void rewriteModifiers(SingleVariableDeclaration declarationNode, int includedModifiers, int excludedModifiers, ASTRewrite rewrite, TextEditGroup group) {
        ModifierRewrite listRewrite = ModifierRewrite.create(rewrite, (ASTNode)declarationNode);
        listRewrite.setModifiers(includedModifiers, excludedModifiers, group);
    }

    public static void rewriteModifiers(VariableDeclarationExpression declarationNode, int includedModifiers, int excludedModifiers, ASTRewrite rewrite, TextEditGroup group) {
        ModifierRewrite listRewrite = ModifierRewrite.create(rewrite, (ASTNode)declarationNode);
        listRewrite.setModifiers(includedModifiers, excludedModifiers, group);
    }

    public static void rewriteModifiers(FieldDeclaration declarationNode, VariableDeclarationFragment[] toChange, int includedModifiers, int excludedModifiers, ASTRewrite rewrite, TextEditGroup group) {
        List<VariableDeclarationFragment> fragmentsToChange = Arrays.asList(toChange);
        AST ast = declarationNode.getAST();
        List fragments = declarationNode.fragments();
        Iterator iter = fragments.iterator();
        ListRewrite blockRewrite = declarationNode.getParent() instanceof AbstractTypeDeclaration ? rewrite.getListRewrite(declarationNode.getParent(), ((AbstractTypeDeclaration)declarationNode.getParent()).getBodyDeclarationsProperty()) : rewrite.getListRewrite(declarationNode.getParent(), AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
        VariableDeclarationFragment lastFragment = (VariableDeclarationFragment)iter.next();
        FieldDeclaration lastStatement = declarationNode;
        int orginalModifiers = declarationNode.getModifiers();
        if (fragmentsToChange.contains(lastFragment)) {
            ListRewrite modifierRewrite = rewrite.getListRewrite((ASTNode)declarationNode, FieldDeclaration.MODIFIERS2_PROPERTY);
            for (ASTNode node : declarationNode.modifiers()) {
                modifierRewrite.remove(node, group);
            }
            List newModifiers = ast.newModifiers(orginalModifiers & ~excludedModifiers | includedModifiers);
            Iterator iterator = newModifiers.iterator();
            while (iterator.hasNext()) {
                modifierRewrite.insertLast((ASTNode)iterator.next(), group);
            }
        }
        ListRewrite fragmentsRewrite = null;
        while (iter.hasNext()) {
            VariableDeclarationFragment currentFragment = (VariableDeclarationFragment)iter.next();
            if (fragmentsToChange.contains(lastFragment) != fragmentsToChange.contains(currentFragment)) {
                FieldDeclaration newStatement = ast.newFieldDeclaration((VariableDeclarationFragment)rewrite.createMoveTarget((ASTNode)currentFragment));
                newStatement.setType((Type)rewrite.createCopyTarget((ASTNode)declarationNode.getType()));
                if (fragmentsToChange.contains(currentFragment)) {
                    newStatement.modifiers().addAll(ast.newModifiers(orginalModifiers & ~excludedModifiers | includedModifiers));
                } else {
                    newStatement.modifiers().addAll(ast.newModifiers(orginalModifiers));
                }
                blockRewrite.insertAfter((ASTNode)newStatement, (ASTNode)lastStatement, group);
                fragmentsRewrite = rewrite.getListRewrite((ASTNode)newStatement, FieldDeclaration.FRAGMENTS_PROPERTY);
                lastStatement = newStatement;
            } else if (fragmentsRewrite != null) {
                ASTNode fragment0 = rewrite.createMoveTarget((ASTNode)currentFragment);
                fragmentsRewrite.insertLast(fragment0, group);
            }
            lastFragment = currentFragment;
        }
    }

    public static void rewriteModifiers(VariableDeclarationStatement declarationNode, VariableDeclarationFragment[] toChange, int includedModifiers, int excludedModifiers, ASTRewrite rewrite, TextEditGroup group) {
        List<VariableDeclarationFragment> fragmentsToChange = Arrays.asList(toChange);
        AST ast = declarationNode.getAST();
        List fragments = declarationNode.fragments();
        Iterator iter = fragments.iterator();
        ListRewrite blockRewrite = rewrite.getListRewrite(declarationNode.getParent(), Block.STATEMENTS_PROPERTY);
        VariableDeclarationFragment lastFragment = (VariableDeclarationFragment)iter.next();
        VariableDeclarationStatement lastStatement = declarationNode;
        int orginalModifiers = declarationNode.getModifiers();
        if (fragmentsToChange.contains(lastFragment)) {
            ListRewrite modifierRewrite = rewrite.getListRewrite((ASTNode)declarationNode, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
            for (ASTNode node : declarationNode.modifiers()) {
                modifierRewrite.remove(node, group);
            }
            List newModifiers = ast.newModifiers(orginalModifiers & ~excludedModifiers | includedModifiers);
            Iterator iterator = newModifiers.iterator();
            while (iterator.hasNext()) {
                modifierRewrite.insertLast((ASTNode)iterator.next(), group);
            }
        }
        ListRewrite fragmentsRewrite = null;
        while (iter.hasNext()) {
            VariableDeclarationFragment currentFragment = (VariableDeclarationFragment)iter.next();
            if (fragmentsToChange.contains(lastFragment) != fragmentsToChange.contains(currentFragment)) {
                VariableDeclarationStatement newStatement = ast.newVariableDeclarationStatement((VariableDeclarationFragment)rewrite.createMoveTarget((ASTNode)currentFragment));
                newStatement.setType((Type)rewrite.createCopyTarget((ASTNode)declarationNode.getType()));
                if (fragmentsToChange.contains(currentFragment)) {
                    newStatement.modifiers().addAll(ast.newModifiers(orginalModifiers & ~excludedModifiers | includedModifiers));
                } else {
                    newStatement.modifiers().addAll(ast.newModifiers(orginalModifiers));
                }
                blockRewrite.insertAfter((ASTNode)newStatement, (ASTNode)lastStatement, group);
                fragmentsRewrite = rewrite.getListRewrite((ASTNode)newStatement, VariableDeclarationStatement.FRAGMENTS_PROPERTY);
                lastStatement = newStatement;
            } else if (fragmentsRewrite != null) {
                ASTNode fragment0 = rewrite.createMoveTarget((ASTNode)currentFragment);
                fragmentsRewrite.insertLast(fragment0, group);
            }
            lastFragment = currentFragment;
        }
    }
}

