/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.settings;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.util.LinkList;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class ProjectProperties {
    protected String label = "Issue Number:";
    protected String message;
    protected boolean number = false;
    protected String url;
    protected boolean warnIfNoIssue = false;
    protected boolean append = true;
    private static final String URL = "://";

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isNumber() {
        return this.number;
    }

    public void setNumber(boolean number) {
        this.number = number;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isWarnIfNoIssue() {
        return this.warnIfNoIssue;
    }

    public void setWarnIfNoIssue(boolean warnIfNoIssue) {
        this.warnIfNoIssue = warnIfNoIssue;
    }

    public String getResolvedMessage(String issue) {
        if (this.message == null) {
            return null;
        }
        return this.message.replaceAll("%BUGID%", issue);
    }

    public String getResolvedUrl(String issue) {
        if (this.url == null) {
            return null;
        }
        return this.url.replaceAll("%BUGID%", issue);
    }

    public LinkList getLinkList(String commitMessage) {
        int index;
        ArrayList<int[]> links = new ArrayList<int[]>();
        ArrayList<String> urls = new ArrayList<String>();
        String bugID = "%BUGID%";
        if (this.message != null && (index = this.message.indexOf(bugID)) != -1) {
            String remainder = null;
            remainder = this.message.length() > index + bugID.length() ? this.message.substring(index + bugID.length()) : "";
            String tag = this.message.substring(0, index);
            if ((index = commitMessage.indexOf(tag)) != -1) {
                String url;
                int start = index += tag.length();
                StringBuffer issue = new StringBuffer();
                while (index < commitMessage.length()) {
                    if (commitMessage.substring(index, index + 1).equals(",")) {
                        int[] range = new int[]{start, issue.length()};
                        url = this.getResolvedUrl(issue.toString());
                        if (url != null && url.trim().length() > 0) {
                            links.add(range);
                            urls.add(url);
                        }
                        start = index + 1;
                        issue = new StringBuffer();
                    } else {
                        if (commitMessage.substring(index, index + 1).equals("\n") || commitMessage.substring(index, index + 1).equals("\r") || commitMessage.substring(index).trim().equals(remainder.trim())) break;
                        if (commitMessage.substring(index, index + 1).equals(" ")) {
                            int lineIndex = commitMessage.indexOf("\n", index);
                            if (lineIndex == -1) {
                                lineIndex = commitMessage.indexOf("\r", index);
                            }
                            if (lineIndex != -1 && commitMessage.substring(index, lineIndex - 1).trim().length() == 0) break;
                        }
                        issue.append(commitMessage.substring(index, index + 1));
                    }
                    ++index;
                }
                int[] range = new int[]{start, issue.length()};
                url = this.getResolvedUrl(issue.toString());
                if (url != null && url.trim().length() > 0) {
                    links.add(range);
                    urls.add(url);
                }
            }
        }
        LinkList urlLinks = ProjectProperties.getUrls(commitMessage);
        int[][] urlRanges = urlLinks.getLinkRanges();
        String[] urlUrls = urlLinks.getUrls();
        int i = 0;
        while (i < urlRanges.length) {
            links.add(urlRanges[i]);
            urls.add(urlUrls[i]);
            ++i;
        }
        int[][] linkRanges = new int[links.size()][2];
        links.toArray((T[])linkRanges);
        String[] urlArray = new String[urls.size()];
        urls.toArray(urlArray);
        LinkList linkList = new LinkList(linkRanges, urlArray);
        return linkList;
    }

    /*
     * Unable to fully structure code
     */
    public static LinkList getUrls(String s) {
        max = 0;
        i = -1;
        if (s != null) {
            max = s.length();
            i = s.indexOf("://");
        }
        linkRanges = new ArrayList<int[]>();
        links = new ArrayList<String>();
        ** GOTO lbl30
        {
            block5: {
                if (!Character.isWhitespace(s.charAt(i)) && !s.substring(i, i + 1).equals("\n")) break block5;
                ++i;
                ** GOTO lbl16
            }
            --i;
            do {
                if (i != -1) continue block0;
lbl16:
                // 2 sources

                start = i < 0 ? 0 : i;
                found = false;
                i += "://".length();
                while (!found && i < max) {
                    found = Character.isWhitespace(s.charAt(i)) != false || s.substring(i, i + 1).equals("\n") != false;
                    ++i;
                }
                if (i != max) {
                    --i;
                }
                linkRanges.add(new int[]{start, i - start});
                links.add(s.substring(start, i));
                i = s.indexOf("://", i);
lbl30:
                // 2 sources

            } while (i != -1);
        }
        return new LinkList((int[][])linkRanges.toArray((T[])new int[linkRanges.size()][2]), links.toArray(new String[links.size()]));
    }

    public String validateIssue(String issue) {
        if (this.number && !this.hasOnlyDigits(issue)) {
            return Policy.bind("CommitDialog.number", this.label);
        }
        return null;
    }

    private boolean hasOnlyDigits(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != ',' && !Character.isDigit(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return "bugtraq:label: " + this.label + "\n" + "bugtraq:message: " + this.message + "\n" + "bugtraq:number: " + this.number + "\n" + "bugtraq:url: " + this.url + "\n" + "bugtraq:warnifnoissue: " + this.warnIfNoIssue + "\n" + "bugtraq:append: " + this.append;
    }

    public static ProjectProperties getProjectProperties(IResource resource) throws SVNException {
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        ISVNProperty property = null;
        ISVNProperty labelProperty = null;
        if (svnResource != null && svnResource.isManaged()) {
            try {
                property = svnResource.getSvnProperty("bugtraq:message");
                labelProperty = svnResource.getSvnProperty("bugtraq:label");
            }
            catch (SVNException sVNException) {}
        }
        if (property != null && property.getValue() != null && property.getValue().trim().length() > 0) {
            ProjectProperties projectProperties = new ProjectProperties();
            projectProperties.setMessage(property.getValue());
            if (labelProperty != null && labelProperty.getValue() != null && labelProperty.getValue().trim().length() != 0) {
                projectProperties.setLabel(labelProperty.getValue());
            }
            if ((property = svnResource.getSvnProperty("bugtraq:url")) != null) {
                projectProperties.setUrl(property.getValue());
            }
            if ((property = svnResource.getSvnProperty("bugtraq:number")) != null && property.getValue() != null) {
                projectProperties.setNumber(property.getValue().equalsIgnoreCase("true"));
            }
            if ((property = svnResource.getSvnProperty("bugtraq:warnifnoissue")) != null && property.getValue() != null) {
                projectProperties.setWarnIfNoIssue(property.getValue().equalsIgnoreCase("true"));
            }
            if ((property = svnResource.getSvnProperty("bugtraq:append")) != null && property.getValue() != null) {
                projectProperties.setAppend(property.getValue().equalsIgnoreCase("true"));
            }
            return projectProperties;
        }
        IResource checkResource = resource;
        while (checkResource.getParent() != null) {
            if ((checkResource = checkResource.getParent()).getParent() == null) {
                return null;
            }
            try {
                svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)checkResource);
                if (svnResource.isManaged()) {
                    property = svnResource.getSvnProperty("bugtraq:message");
                }
                if (property == null) continue;
                return ProjectProperties.getProjectProperties(checkResource);
            }
            catch (SVNException sVNException) {}
        }
        return null;
    }

    public static ProjectProperties getProjectProperties(ISVNRemoteResource remoteResource) {
        return null;
    }
}

