/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ConditionCheck;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IMarkerResolution;

public abstract class BugResolution
implements IMarkerResolution {
    private static final String MISSING_BUG_INSTANCE = "This bug is no longer in the system. The bugs somehow got out of sync with the memory representation. Try running FindBugs again. If that does not work, check the error log and remove the *.fbwarnings files.";
    private String label = TigerSubstitutes.getSimpleName(this.getClass());
    private IProgressMonitor monitor = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    @CheckForNull
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        ConditionCheck.checkForNull(label, "label");
        this.label = label;
    }

    @CheckForNull
    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void run(IMarker marker) {
        ConditionCheck.checkForNull(marker, "marker");
        try {
            this.runInternal(marker);
        }
        catch (BugResolutionException e) {
            this.reportException(e);
        }
        catch (JavaModelException e) {
            this.reportException((Exception)((Object)e));
        }
        catch (BadLocationException e) {
            this.reportException((Exception)((Object)e));
        }
        catch (CoreException e) {
            this.reportException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInternal(IMarker marker) throws BugResolutionException, BadLocationException, CoreException {
        if (!$assertionsDisabled && marker == null) {
            throw new AssertionError();
        }
        BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
        if (bug == null) {
            throw new BugResolutionException(MISSING_BUG_INSTANCE);
        }
        IProject project = marker.getResource().getProject();
        ICompilationUnit originalUnit = this.getCompilationUnit(marker);
        if (originalUnit == null) {
            throw new BugResolutionException("No compilation unit found for marker " + marker.getType() + " (" + marker.getId() + ")");
        }
        Document doc = new Document(originalUnit.getBuffer().getContents());
        CompilationUnit workingUnit = this.createWorkingCopy(originalUnit);
        ASTRewrite rewrite = ASTRewrite.create((AST)workingUnit.getAST());
        try {
            this.repairBug(rewrite, workingUnit, bug);
            this.rewriteCompilationUnit(rewrite, (IDocument)doc, originalUnit);
            FindbugsPlugin.getBugCollection(project, this.monitor).remove(bug);
            marker.delete();
            MarkerUtil.redisplayMarkers(project, FindbugsPlugin.getShell());
        }
        finally {
            originalUnit.discardWorkingCopy();
        }
    }

    protected abstract boolean resolveBindings();

    protected abstract void repairBug(ASTRewrite var1, CompilationUnit var2, BugInstance var3) throws BugResolutionException;

    @CheckForNull
    protected ICompilationUnit getCompilationUnit(IMarker marker) {
        IJavaElement element;
        IResource res = marker.getResource();
        if (res instanceof IFile && res.isAccessible() && (element = JavaCore.create((IFile)((IFile)res))) instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    protected void reportException(Exception e) {
        if (!$assertionsDisabled && e == null) {
            throw new AssertionError();
        }
        FindbugsPlugin.getDefault().logException(e, e.getLocalizedMessage());
        MessageDialog.openError((Shell)FindbugsPlugin.getShell(), (String)"BugResolution failed.", (String)e.getLocalizedMessage());
    }

    private CompilationUnit createWorkingCopy(ICompilationUnit unit) throws JavaModelException {
        unit.becomeWorkingCopy(null, this.monitor);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(unit);
        parser.setResolveBindings(this.resolveBindings());
        return (CompilationUnit)parser.createAST(this.monitor);
    }

    private void rewriteCompilationUnit(ASTRewrite rewrite, IDocument doc, ICompilationUnit originalUnit) throws JavaModelException, BadLocationException {
        TextEdit edits = rewrite.rewriteAST(doc, originalUnit.getJavaProject().getOptions(true));
        edits.apply(doc);
        originalUnit.getBuffer().setContents(doc.get());
        originalUnit.commitWorkingCopy(false, this.monitor);
    }

    static {
        $assertionsDisabled = !BugResolution.class.desiredAssertionStatus();
    }
}

