/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;

public class FindUncalledPrivateMethods
extends BytecodeScanningDetector
implements StatelessDetector {
    private BugReporter bugReporter;
    private String className;
    private HashSet<MethodAnnotation> definedPrivateMethods;
    private HashSet<MethodAnnotation> calledMethods;
    private HashSet<String> calledMethodNames;

    public FindUncalledPrivateMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitMethod(Method obj) {
        super.visitMethod(obj);
        if (!(!obj.isPrivate() || this.getMethodName().equals("writeReplace") || this.getMethodName().equals("readResolve") || this.getMethodName().equals("readObject") || this.getMethodName().equals("readObjectNoData") || this.getMethodName().equals("writeObject") || this.getMethodName().indexOf("debug") != -1 || this.getMethodName().indexOf("Debug") != -1 || this.getMethodName().indexOf("trace") != -1 || this.getMethodName().indexOf("Trace") != -1 || this.getMethodName().equals("<init>") || this.getMethodName().equals("<clinit>"))) {
            this.definedPrivateMethods.add(MethodAnnotation.fromVisitedMethod((PreorderVisitor)this));
        }
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: {
                if (!this.getDottedClassConstantOperand().equals(this.className)) break;
                String className = this.getDottedClassConstantOperand();
                MethodAnnotation called = new MethodAnnotation(className, this.getNameConstantOperand(), this.getSigConstantOperand(), seen == 184);
                this.calledMethods.add(called);
                this.calledMethodNames.add(this.getNameConstantOperand().toLowerCase());
                break;
            }
        }
    }

    public void visitClassContext(ClassContext classContext) {
        this.definedPrivateMethods = new HashSet();
        this.calledMethods = new HashSet();
        this.calledMethodNames = new HashSet();
        this.className = classContext.getJavaClass().getClassName();
        super.visitClassContext(classContext);
        this.definedPrivateMethods.removeAll(this.calledMethods);
        Iterator<MethodAnnotation> i$ = this.definedPrivateMethods.iterator();
        while (i$.hasNext()) {
            MethodAnnotation m = i$.next();
            int priority = 3;
            String methodName = m.getMethodName();
            if (methodName.length() > 1 && this.calledMethodNames.contains(methodName.toLowerCase())) {
                priority = 2;
            }
            BugInstance bugInstance = new BugInstance((Detector)this, "UPM_UNCALLED_PRIVATE_METHOD", priority).addClass((PreorderVisitor)this).addMethod(m);
            this.bugReporter.reportBug(bugInstance);
        }
        this.definedPrivateMethods = null;
        this.calledMethods = null;
    }
}

