/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.epic.core.util.MarkerUtilities;
import org.epic.perleditor.actions.PerlEditorAction;
import org.epic.perleditor.editors.PerlEditor;

public abstract class ClearMarkerAction
extends PerlEditorAction {
    protected ClearMarkerAction(PerlEditor editor) {
        super(editor);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected abstract String getMarkerType();

    protected final void doRun() {
        this.scheduleJob(this.getMarkerType());
    }

    private void scheduleJob(final String markerType) {
        Job job = new Job("Clear EPIC Marker(s)"){

            protected IStatus run(IProgressMonitor monitor) {
                MarkerUtilities factory = new MarkerUtilities(ClearMarkerAction.this.getLog(), ClearMarkerAction.this.getPluginId());
                factory.deleteMarkers(ClearMarkerAction.this.getResource(), markerType);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public static class AllMarkers
    extends ClearMarkerAction {
        public AllMarkers(PerlEditor editor) {
            super(editor);
        }

        protected String getMarkerType() {
            return "org.epic.perleditor.markers.epic";
        }

        protected String getPerlEditorActionId() {
            return "org.epic.perleditor.actions.ClearMarkerAction#AllMarkers";
        }
    }

    public static class Critic
    extends ClearMarkerAction {
        public Critic(PerlEditor editor) {
            super(editor);
        }

        protected String getMarkerType() {
            return "org.epic.perleditor.markers.critic";
        }

        protected String getPerlEditorActionId() {
            return "org.epic.perleditor.actions.ClearMarkerAction#Critic";
        }
    }

    public static class PodChecker
    extends ClearMarkerAction {
        public PodChecker(PerlEditor editor) {
            super(editor);
        }

        protected String getMarkerType() {
            return "org.epic.perleditor.markers.podChecker";
        }

        protected String getPerlEditorActionId() {
            return "org.epic.perleditor.actions.ClearMarkerAction#PodChecker";
        }
    }
}

