/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.visitors.context;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.ClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.adapters.SimpleAdapter;
import org.python.pydev.refactoring.ast.visitors.NodeHelper;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextVisitor<T>
extends VisitorBase {
    protected NodeHelper nodeHelper;
    protected List<T> nodes;
    protected final FastStack<AbstractScopeNode<?>> parents;
    protected final FastStack<SimpleNode> stack;
    protected ModuleAdapter moduleAdapter;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract T createAdapter(AbstractScopeNode<?> var1, SimpleNode var2);

    static {
        $assertionsDisabled = !ClassLiteral.getClass((String)"org/python/pydev/refactoring/ast/visitors/context/AbstractContextVisitor").desiredAssertionStatus();
    }

    public AbstractContextVisitor(ModuleAdapter module, AbstractNodeAdapter<? extends SimpleNode> parent) {
        if (!$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
        this.moduleAdapter = module;
        this.nodeHelper = new NodeHelper(module.getEndLineDelimiter());
        this.stack = new FastStack();
        this.parents = new FastStack();
        this.parents.push((Object)this.moduleAdapter);
        this.stack.push(module.getASTNode());
        this.nodes = new ArrayList<T>();
    }

    private void add(T node) {
        this.nodes.add(node);
    }

    protected void after() {
        this.stack.pop();
    }

    protected AbstractNodeAdapter<? extends SimpleNode> before(SimpleNode node) {
        AbstractNodeAdapter<SimpleNode> context = this.createContext(node);
        this.stack.push((Object)node);
        return context;
    }

    private AbstractNodeAdapter<? extends SimpleNode> create(SimpleNode node) {
        AbstractScopeNode parent = (AbstractScopeNode)this.parents.peek();
        if (this.nodeHelper.isClassDef(node)) {
            return new ClassDefAdapter(this.moduleAdapter, parent, (ClassDef)node, this.moduleAdapter.getEndLineDelimiter());
        }
        if (this.nodeHelper.isFunctionDef(node)) {
            return new FunctionDefAdapter(this.moduleAdapter, parent, (FunctionDef)node, this.moduleAdapter.getEndLineDelimiter());
        }
        return new SimpleAdapter(this.moduleAdapter, parent, node, this.moduleAdapter.getEndLineDelimiter());
    }

    protected AbstractNodeAdapter<? extends SimpleNode> createContext(SimpleNode node) {
        if (this.nodeHelper.isModule(node)) {
            if (!$assertionsDisabled && node != this.moduleAdapter.getASTNode()) {
                throw new AssertionError();
            }
            return this.moduleAdapter;
        }
        return this.create(node);
    }

    public List<T> getAll() {
        return this.nodes;
    }

    protected boolean isInClassDef() {
        for (SimpleNode node : this.stack) {
            if (!this.nodeHelper.isClassDef(node)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInFunctionDef() {
        for (SimpleNode node : this.stack) {
            if (!this.nodeHelper.isFunctionDef(node)) continue;
            return true;
        }
        return false;
    }

    protected boolean isParentClassDecl() {
        return this.nodeHelper.isClassDef((SimpleNode)((AbstractScopeNode)this.parents.peek()).getASTNode());
    }

    public Iterator<T> iterator() {
        return this.nodes.iterator();
    }

    protected void registerInContext(SimpleNode node) {
        T context = this.createAdapter((AbstractScopeNode)this.parents.peek(), node);
        this.add(context);
    }

    protected void trackContext(SimpleNode node) throws Exception {
        AbstractNodeAdapter<SimpleNode> context = this.before(node);
        this.pushParent(context);
        this.traverse(node);
        this.parents.pop();
        this.after();
    }

    protected void updateASTContext(SimpleNode node) throws Exception {
        this.before(node);
        this.traverse(node);
        this.after();
    }

    public void traverse(FunctionDef node) throws Exception {
        if (node.decs != null) {
            this.visit((SimpleNode[])node.decs);
        }
        this.visit((SimpleNode)node.name);
        this.visit((SimpleNode)node.args);
        this.visit((SimpleNode[])node.body);
    }

    public void traverse(SimpleNode node) throws Exception {
        if (this.nodeHelper.isFunctionDef(node)) {
            this.traverse((FunctionDef)node);
        } else {
            node.traverse((VisitorIF)this);
        }
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public void visit(SimpleNode node) throws Exception {
        if (node == null) {
            return;
        }
        node.accept((VisitorIF)this);
    }

    protected void visit(SimpleNode[] body) throws Exception {
        if (body == null) {
            return;
        }
        SimpleNode[] simpleNodeArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleNode node = simpleNodeArray[n2];
            this.visit(node);
            ++n2;
        }
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        this.trackContext((SimpleNode)node);
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        AbstractNodeAdapter<SimpleNode> context = this.before((SimpleNode)node);
        this.pushParent(context);
        this.traverse(node);
        this.parents.pop();
        this.after();
        return null;
    }

    protected void pushParent(AbstractNodeAdapter<? extends SimpleNode> context) {
        if (context instanceof AbstractScopeNode) {
            this.parents.push((Object)((AbstractScopeNode)context));
        }
    }
}

