/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.refactoring;

import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.model.Location;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.SystemPythonNature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyRefactoringFindDefinition {
    public static String[] findActualDefinition(RefactoringRequest request, CompletionCache completionCache, ArrayList<IDefinition> selected) {
        request.createSubMonitor(50);
        request.getMonitor().beginTask("Find definition", 5);
        request.communicateWork("Finding Definition");
        IModule mod = PyRefactoringFindDefinition.prepareRequestForFindDefinition(request);
        if (mod == null) {
            return null;
        }
        String modName = request.moduleName;
        request.communicateWork(new StringBuffer("Module name found:").append(modName).toString());
        String[] tokenAndQual = PySelection.getActivationTokenAndQual((IDocument)request.getDoc(), (int)request.ps.getAbsoluteCursorOffset(), (boolean)true);
        String tok = new StringBuffer(String.valueOf(tokenAndQual[0])).append(tokenAndQual[1]).toString();
        try {
            int beginLine = request.getBeginLine();
            int beginCol = request.getBeginCol() + 1;
            IPythonNature pythonNature = request.nature;
            PyRefactoringFindDefinition.findActualDefinition(request, mod, tok, selected, beginLine, beginCol, pythonNature, completionCache);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tokenAndQual;
    }

    private static IModule prepareRequestForFindDefinition(RefactoringRequest request) {
        IModule mod;
        String modName;
        block16: {
            block15: {
                modName = null;
                if (request.nature == null) {
                    Tuple<SystemPythonNature, String> infoForFile = PydevPlugin.getInfoForFile(request.file);
                    if (infoForFile != null) {
                        modName = (String)infoForFile.o2;
                        request.nature = (IPythonNature)infoForFile.o1;
                        request.inputName = modName;
                    } else {
                        return null;
                    }
                }
                if (modName == null) {
                    modName = request.resolveModule();
                }
                if (request.nature == null) {
                    PydevPlugin.logInfo("Unable to resolve nature for find definition request (python or jython interpreter may not be configured).");
                    return null;
                }
                try {
                    if (!request.nature.isPython()) break block15;
                    if (!PydevPlugin.isPythonInterpreterInitialized()) {
                        PydevPlugin.logInfo("Python interpreter manager not initialized.");
                        return null;
                    }
                }
                catch (CoreException e1) {
                    throw new RuntimeException(e1);
                }
            }
            if (!request.nature.isJython()) break block16;
            if (!PydevPlugin.isJythonInterpreterInitialized()) {
                PydevPlugin.logInfo("Jython interpreter manager not initialized.");
                return null;
            }
        }
        throw new RuntimeException("Project is neither python nor jython?");
        if ((mod = request.getModule()) == null) {
            PydevPlugin.logInfo("Unable to resolve module for find definition request.");
            return null;
        }
        if (modName == null) {
            if (mod.getName() == null && mod instanceof SourceModule) {
                SourceModule m = (SourceModule)mod;
                modName = "__module_not_in_the_pythonpath__";
                m.setName(modName);
            }
            if (modName == null) {
                PydevPlugin.logInfo("Unable to resolve module for find definition request (modName == null).");
                return null;
            }
        }
        request.moduleName = modName;
        return mod;
    }

    public static void findActualDefinition(RefactoringRequest request, IModule mod, String tok, ArrayList<IDefinition> selected, int beginLine, int beginCol, IPythonNature pythonNature, ICompletionCache completionCache) throws Exception {
        IDefinition[] definitions = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState(tok, pythonNature, beginLine - 1, beginCol - 1, completionCache), beginLine, beginCol, pythonNature);
        request.communicateWork(new StringBuffer("Found:").append(definitions.length).append(" definitions").toString());
        IDefinition[] iDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            IDefinition definition = iDefinitionArray[n2];
            boolean doAdd = true;
            if (definition instanceof Definition) {
                Definition d = (Definition)definition;
                doAdd = !PyRefactoringFindDefinition.findActualTokenFromImportFromDefinition(pythonNature, tok, selected, d, completionCache);
            }
            request.checkCancelled();
            if (doAdd) {
                selected.add(definition);
            }
            ++n2;
        }
    }

    private static boolean findActualTokenFromImportFromDefinition(IPythonNature nature, String tok, ArrayList<IDefinition> selected, Definition d, ICompletionCache completionCache) throws Exception {
        boolean didFindNewDef = false;
        HashSet<Tuple3<String, Integer, Integer>> whereWePassed = new HashSet<Tuple3<String, Integer, Integer>>();
        tok = FullRepIterable.getLastPart((String)tok);
        while (d.ast instanceof ImportFrom) {
            Tuple3<String, Integer, Integer> tupFromDefinition;
            Tuple3<String, Integer, Integer> t1 = PyRefactoringFindDefinition.getTupFromDefinition(d);
            if (t1 == null) break;
            whereWePassed.add(t1);
            Definition[] found = (Definition[])d.module.findDefinition(CompletionStateFactory.getEmptyCompletionState(tok, nature, completionCache), d.line, d.col, nature);
            if (found == null || found.length != 1 || (tupFromDefinition = PyRefactoringFindDefinition.getTupFromDefinition(found[0])) == null || whereWePassed.contains(tupFromDefinition)) break;
            didFindNewDef = true;
            d = found[0];
        }
        if (didFindNewDef) {
            selected.add(d);
        }
        return didFindNewDef;
    }

    private static Tuple3<String, Integer, Integer> getTupFromDefinition(Definition d) {
        if (d == null) {
            return null;
        }
        File file = d.module.getFile();
        if (file == null) {
            return null;
        }
        return new Tuple3((Object)REF.getFileAbsolutePath((File)file), (Object)Autobox.valueOf((int)d.line), (Object)Autobox.valueOf((int)d.col));
    }

    public static void getAsPointers(List<ItemPointer> pointers, IDefinition[] definitions) {
        IDefinition[] iDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            IDefinition definition = iDefinitionArray[n2];
            File file = definition.getModule().getFile();
            int line = definition.getLine();
            int col = definition.getCol();
            pointers.add(new ItemPointer(file, new Location(line - 1, col - 1), new Location(line - 1, col - 1), (Definition)definition, definition.getModule().getZipFilePath()));
            ++n2;
        }
    }
}

