/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.dltk.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptConsoleHistory {
    private final List<String> lines = new ArrayList<String>();
    private int currLine;
    private Document historyAsDoc;
    private String matchStart = "";

    public ScriptConsoleHistory() {
        this.lines.add("");
        this.currLine = 0;
        this.historyAsDoc = new Document();
    }

    public void update(String line) {
        this.lines.set(this.lines.size() - 1, line);
    }

    public void commit() {
        String lineToAddToHistory = this.getBufferLine();
        try {
            this.historyAsDoc.replace(this.historyAsDoc.getLength(), 0, new StringBuffer(String.valueOf(lineToAddToHistory)).append("\n").toString());
        }
        catch (BadLocationException e) {
            PydevPlugin.log(e);
        }
        if (lineToAddToHistory.length() == 0) {
            this.currLine = this.lines.size() - 1;
            return;
        }
        this.lines.set(this.lines.size() - 1, lineToAddToHistory);
        this.lines.add("");
        this.currLine = this.lines.size() - 1;
    }

    public boolean prev() {
        int initialCurrLine = this.currLine;
        while (this.currLine > 0) {
            --this.currLine;
            String curr = this.get();
            if (!curr.startsWith(this.matchStart)) continue;
            return true;
        }
        this.currLine = initialCurrLine;
        return false;
    }

    public boolean next() {
        int initialCurrLine = this.currLine;
        while (this.currLine < this.lines.size() - 2) {
            ++this.currLine;
            String curr = this.get();
            if (!curr.startsWith(this.matchStart)) continue;
            return true;
        }
        this.currLine = initialCurrLine;
        return false;
    }

    public IDocument getAsDoc() {
        return this.historyAsDoc;
    }

    public String getBufferLine() {
        return this.lines.get(this.lines.size() - 1);
    }

    public String get() {
        if (this.lines.isEmpty()) {
            return "";
        }
        return this.lines.get(this.currLine);
    }

    public List<String> getAsList() {
        ArrayList<String> list = new ArrayList<String>(this.lines);
        if (list.size() > 0) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    public void setMatchStart(String string) {
        this.matchStart = string;
    }
}

