/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.python.pydev.debug.codecoverage.FileNode;
import org.python.pydev.debug.codecoverage.PyCoverage;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.model.Location;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.tree.AllowValidPathsFilter;
import org.python.pydev.tree.FileTreeLabelProvider;
import org.python.pydev.tree.FileTreePyFilesProvider;
import org.python.pydev.utils.ProgressAction;
import org.python.pydev.utils.ProgressOperation;

public class PyCodeCoverageView
extends ViewPart {
    private Composite leftComposite;
    private DoubleClickTreeAction doubleClickAction = new DoubleClickTreeAction();
    private SelectionChangedTreeAction selectionChangedAction = new SelectionChangedTreeAction();
    private ProgressAction chooseAction = new ChooseAction();
    protected ProgressAction clearAction = new ClearAction();
    protected RefreshAction refreshAction = new RefreshAction();
    private Button clearButton;
    private Button refreshButton;
    private Button chooseButton;
    private Text text;
    private TreeViewer viewer;
    private File lastChosenFile;
    private SashForm s;

    public void refresh() {
        this.viewer.refresh();
        this.getSite().getPage().bringToTop((IWorkbenchPart)this);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.s = new SashForm(parent, 256);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.s.setLayoutData((Object)layoutData);
        parent = this.s;
        this.leftComposite = new Composite(parent, 2);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.leftComposite.setLayoutData((Object)layoutData);
        this.leftComposite.setLayout((Layout)layout);
        this.text = new Text(parent, 770);
        try {
            this.text.setFont(new Font(null, "Courier new", 10, 0));
        }
        catch (Exception exception) {}
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.text.setLayoutData((Object)layoutData);
        parent = this.leftComposite;
        this.chooseButton = new Button(parent, 8);
        this.createButton(parent, this.chooseButton, "Choose dir!", this.chooseAction);
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new FileTreePyFilesProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileTreeLabelProvider());
        this.viewer.addFilter((ViewerFilter)new AllowValidPathsFilter());
        this.hookViewerActions();
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)layoutData);
        this.clearButton = new Button(parent, 8);
        this.createButton(parent, this.clearButton, "Clear coverage information!", this.clearAction);
        this.refreshButton = new Button(parent, 8);
        this.createButton(parent, this.refreshButton, "Refresh coverage information!", this.refreshAction);
        this.refresh();
    }

    private void createButton(Composite parent, Button button, String txt, final ProgressAction action) {
        button.setText(txt);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProgressOperation.startAction((Shell)PyCodeCoverageView.this.getSite().getShell(), (ProgressAction)action);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        button.setLayoutData((Object)layoutData);
    }

    private void hookViewerActions() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PyCodeCoverageView.this.doubleClickAction.runWithEvent(event);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PyCodeCoverageView.this.selectionChangedAction.runWithEvent(event);
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private final class ChooseAction
    extends ProgressAction {
        private ChooseAction() {
        }

        public void run() {
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(PyCodeCoverageView.this.getSite().getShell(), null, false, "Test");
            if (dialog.open() != 0) {
                return;
            }
            Object[] objects = dialog.getResult();
            if (objects.length == 1 && objects[0] instanceof IPath) {
                IPath p = (IPath)objects[0];
                IWorkspace w = ResourcesPlugin.getWorkspace();
                IContainer folderFolLocation = (IContainer)w.getRoot().findMember(p);
                File file = null;
                if (folderFolLocation != null) {
                    IPath loc = folderFolLocation.getRawLocation();
                    if (loc == null) {
                        loc = folderFolLocation.getLocation();
                    }
                    file = loc.toFile();
                } else {
                    file = p.toFile().getAbsoluteFile();
                }
                PyCodeCoverageView.this.lastChosenFile = file;
                PyCodeCoverageView.this.refreshAction.monitor = this.monitor;
                PyCodeCoverageView.this.refreshAction.run();
            }
        }
    }

    private final class ClearAction
    extends ProgressAction {
        private ClearAction() {
        }

        public void run() {
            PyCoverage.getPyCoverage().clearInfo();
            MessageDialog.openInformation((Shell)PyCodeCoverageView.this.getSite().getShell(), (String)"Cleared", (String)"All the coverage data has been cleared!");
            PyCodeCoverageView.this.text.setText("Data cleared (NOT REFRESHED).");
        }
    }

    private final class DoubleClickTreeAction
    extends ProgressAction {
        private DoubleClickTreeAction() {
        }

        public void run() {
            this.run(PyCodeCoverageView.this.viewer.getSelection());
        }

        public void runWithEvent(DoubleClickEvent event) {
            this.run(event.getSelection());
        }

        public void run(ISelection selection) {
            try {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                File realFile = new File(obj.toString());
                if (realFile.exists() && !realFile.isDirectory()) {
                    ItemPointer p = new ItemPointer((Object)realFile, new Location(-1, -1), null);
                    PyOpenAction act = new PyOpenAction();
                    act.run(p);
                    if (act.editor instanceof PyEdit) {
                        IFile original;
                        PyEdit e = (PyEdit)act.editor;
                        IEditorInput input = e.getEditorInput();
                        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
                        if (original == null) {
                            return;
                        }
                        IDocument document = e.getDocumentProvider().getDocument((Object)e.getEditorInput());
                        String type = "org.eclipse.core.resources.problemmarker";
                        original.deleteMarkers(type, false, 1);
                        String message = "Not Executed";
                        FileNode cache = (FileNode)PyCoverage.getPyCoverage().cache.getFile(realFile);
                        if (cache != null) {
                            Iterator<Object> it = cache.notExecutedIterator();
                            while (it.hasNext()) {
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                int errorLine = (Integer)it.next() - 1;
                                IRegion region = document.getLineInformation(errorLine);
                                int errorEnd = region.getOffset();
                                int errorStart = region.getOffset() + region.getLength();
                                map.put("message", message);
                                map.put("severity", new Integer(2));
                                map.put("lineNumber", new Integer(errorLine));
                                map.put("charStart", new Integer(errorStart));
                                map.put("charEnd", new Integer(errorEnd));
                                map.put("transient", Autobox.valueOf((boolean)true));
                                map.put("priority", new Integer(2));
                                MarkerUtilities.createMarker((IResource)original, map, (String)type);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final class RefreshAction
    extends ProgressAction {
        private RefreshAction() {
        }

        public void run() {
            try {
                PyCoverage.getPyCoverage().refreshCoverageInfo(PyCodeCoverageView.this.lastChosenFile, this.monitor);
                PyCodeCoverageView.this.viewer.setInput((Object)PyCodeCoverageView.this.lastChosenFile);
                PyCodeCoverageView.this.text.setText("Refreshed info.");
            }
            catch (Exception e) {
                PydevPlugin.log((Throwable)e);
            }
        }
    }

    private final class SelectionChangedTreeAction
    extends Action {
        private SelectionChangedTreeAction() {
        }

        public void run() {
            this.run((IStructuredSelection)PyCodeCoverageView.this.viewer.getSelection());
        }

        public void runWithEvent(SelectionChangedEvent event) {
            this.run((IStructuredSelection)event.getSelection());
        }

        public void run(IStructuredSelection selection) {
            Object obj = selection.getFirstElement();
            if (obj == null) {
                return;
            }
            File realFile = new File(obj.toString());
            if (realFile.exists()) {
                PyCodeCoverageView.this.text.setText(PyCoverage.getPyCoverage().cache.getStatistics(realFile));
            }
        }
    }
}

