/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcRequestConfig;
import org.apache.xmlrpc.common.ServerStreamConnection;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.common.XmlRpcStreamRequestProcessor;
import org.apache.xmlrpc.parser.XmlRpcRequestParser;
import org.apache.xmlrpc.serializer.DefaultXMLWriterFactory;
import org.apache.xmlrpc.serializer.XmlRpcWriter;
import org.apache.xmlrpc.serializer.XmlWriterFactory;
import org.apache.xmlrpc.server.XmlRpcServer;
import org.apache.xmlrpc.util.SAXParsers;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlRpcStreamServer
extends XmlRpcServer
implements XmlRpcStreamRequestProcessor {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xmlrpc$server$XmlRpcStreamServer == null ? (class$org$apache$xmlrpc$server$XmlRpcStreamServer = XmlRpcStreamServer.class$("org.apache.xmlrpc.server.XmlRpcStreamServer")) : class$org$apache$xmlrpc$server$XmlRpcStreamServer));
    private XmlWriterFactory writerFactory = new DefaultXMLWriterFactory();
    static /* synthetic */ Class class$org$apache$xmlrpc$server$XmlRpcStreamServer;

    protected XmlRpcRequest getRequest(final XmlRpcStreamRequestConfig pConfig, InputStream pStream) throws XmlRpcException {
        final XmlRpcRequestParser parser = new XmlRpcRequestParser((XmlRpcStreamConfig)pConfig, this.getTypeFactory());
        XMLReader xr = SAXParsers.newXMLReader();
        xr.setContentHandler((ContentHandler)parser);
        try {
            xr.parse(new InputSource(pStream));
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null && ex instanceof XmlRpcException) {
                throw (XmlRpcException)ex;
            }
            throw new XmlRpcException("Failed to parse XML-RPC request: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XmlRpcException("Failed to read XML-RPC request: " + e.getMessage(), (Throwable)e);
        }
        final List params = parser.getParams();
        return new XmlRpcRequest(){

            public XmlRpcRequestConfig getConfig() {
                return pConfig;
            }

            public String getMethodName() {
                return parser.getMethodName();
            }

            public int getParameterCount() {
                return params == null ? 0 : params.size();
            }

            public Object getParameter(int pIndex) {
                return params.get(pIndex);
            }
        };
    }

    protected XmlRpcWriter getXmlRpcWriter(XmlRpcStreamRequestConfig pConfig, OutputStream pStream) throws XmlRpcException {
        ContentHandler w = this.getXMLWriterFactory().getXmlWriter((XmlRpcStreamConfig)pConfig, pStream);
        return new XmlRpcWriter((XmlRpcStreamConfig)pConfig, w, this.getTypeFactory());
    }

    protected void writeResponse(XmlRpcStreamRequestConfig pConfig, OutputStream pStream, Object pResult) throws XmlRpcException {
        try {
            this.getXmlRpcWriter(pConfig, pStream).write((XmlRpcRequestConfig)pConfig, pResult);
        }
        catch (SAXException e) {
            throw new XmlRpcException("Failed to write XML-RPC response: " + e.getMessage(), (Throwable)e);
        }
    }

    protected Throwable convertThrowable(Throwable pError) {
        return pError;
    }

    protected void writeError(XmlRpcStreamRequestConfig pConfig, OutputStream pStream, Throwable pError) throws XmlRpcException {
        int code;
        Throwable error = this.convertThrowable(pError);
        if (error instanceof XmlRpcException) {
            XmlRpcException ex = (XmlRpcException)error;
            code = ex.code;
        } else {
            code = 0;
        }
        String message = error.getMessage();
        try {
            this.getXmlRpcWriter(pConfig, pStream).write((XmlRpcRequestConfig)pConfig, code, message, error);
        }
        catch (SAXException e) {
            throw new XmlRpcException("Failed to write XML-RPC response: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setXMLWriterFactory(XmlWriterFactory pFactory) {
        this.writerFactory = pFactory;
    }

    public XmlWriterFactory getXMLWriterFactory() {
        return this.writerFactory;
    }

    protected InputStream getInputStream(XmlRpcStreamRequestConfig pConfig, ServerStreamConnection pConnection) throws IOException {
        InputStream istream = pConnection.newInputStream();
        if (pConfig.isEnabledForExtensions() && pConfig.isGzipCompressing()) {
            istream = new GZIPInputStream(istream);
        }
        return istream;
    }

    protected OutputStream getOutputStream(ServerStreamConnection pConnection, XmlRpcStreamRequestConfig pConfig, OutputStream pStream) throws IOException {
        if (pConfig.isEnabledForExtensions() && pConfig.isGzipRequesting()) {
            return new GZIPOutputStream(pStream);
        }
        return pStream;
    }

    protected OutputStream getOutputStream(XmlRpcStreamRequestConfig pConfig, ServerStreamConnection pConnection, int pSize) throws IOException {
        return pConnection.newOutputStream();
    }

    protected boolean isContentLengthRequired(XmlRpcStreamRequestConfig pConfig) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(XmlRpcStreamRequestConfig pConfig, ServerStreamConnection pConnection) throws XmlRpcException {
        log.debug((Object)"execute: ->");
        try {
            OutputStream ostream;
            ByteArrayOutputStream baos;
            Throwable error;
            Object result;
            InputStream istream = null;
            try {
                istream = this.getInputStream(pConfig, pConnection);
                XmlRpcRequest request = this.getRequest(pConfig, istream);
                result = this.execute(request);
                istream.close();
                istream = null;
                error = null;
                log.debug((Object)"execute: Request performed successfully");
            }
            catch (Throwable t) {
                log.error((Object)"execute: Error while performing request", t);
                result = null;
                error = t;
            }
            finally {
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
            boolean contentLengthRequired = this.isContentLengthRequired(pConfig);
            if (contentLengthRequired) {
                baos = new ByteArrayOutputStream();
                ostream = baos;
            } else {
                baos = null;
                ostream = pConnection.newOutputStream();
            }
            ostream = this.getOutputStream(pConnection, pConfig, ostream);
            try {
                if (error == null) {
                    this.writeResponse(pConfig, ostream, result);
                } else {
                    this.writeError(pConfig, ostream, error);
                }
                ostream.close();
                ostream = null;
            }
            finally {
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
            if (baos != null) {
                OutputStream dest = this.getOutputStream(pConfig, pConnection, baos.size());
                try {
                    baos.writeTo(dest);
                    dest.close();
                    dest = null;
                }
                finally {
                    if (dest != null) {
                        try {
                            dest.close();
                        }
                        catch (Throwable ignore) {}
                    }
                }
            }
            pConnection.close();
            pConnection = null;
        }
        catch (IOException e) {
            throw new XmlRpcException("I/O error while processing request: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (pConnection != null) {
                try {
                    pConnection.close();
                }
                catch (Throwable ignore) {}
            }
        }
        log.debug((Object)"execute: <-");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

