/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import org.python.compiler.Module;
import org.python.core.BytecodeLoader;
import org.python.core.CompilerFlags;
import org.python.core.FixedFileWrapper;
import org.python.core.JavaCode;
import org.python.core.JavaFunc;
import org.python.core.Options;
import org.python.core.PyArray;
import org.python.core.PyClass;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyFunctionTable;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyMetaClass;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyRunnable;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.StdoutWrapper;
import org.python.core.ThreadState;
import org.python.core.ThreadStateMapping;
import org.python.core.__builtin__;
import org.python.core.imp;
import org.python.core.parser;
import org.python.parser.SimpleNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Py {
    static boolean frozen;
    static String frozenPackage;
    private static final Object PRESENT;
    static Hashtable frozenModules;
    static boolean initialized;
    public static PyObject None;
    public static PyObject Ellipsis;
    public static PyObject NotImplemented;
    public static String[] NoKeywords;
    public static PyObject[] EmptyObjects;
    public static PyTuple EmptyTuple;
    public static PyInteger Zero;
    public static PyInteger One;
    public static PyString EmptyString;
    public static PyString Newline;
    public static PyString Space;
    public static Object NoConversion;
    public static PyObject OSError;
    public static PyObject NotImplementedError;
    public static PyObject EnvironmentError;
    public static PyObject OverflowError;
    public static PyObject RuntimeError;
    public static PyObject KeyboardInterrupt;
    public static PyObject FloatingPointError;
    public static PyObject SyntaxError;
    public static PyObject IndentationError;
    public static PyObject TabError;
    public static PyObject AttributeError;
    public static PyObject IOError;
    public static PyObject KeyError;
    public static PyObject AssertionError;
    public static PyObject TypeError;
    public static PyObject SystemError;
    public static PyObject IndexError;
    public static PyObject ZeroDivisionError;
    public static PyObject NameError;
    public static PyObject UnboundLocalError;
    public static PyObject SystemExit;
    public static PyObject ImportError;
    public static PyObject ValueError;
    public static PyObject UnicodeError;
    public static PyObject EOFError;
    public static PyObject MemoryError;
    public static PyObject ArithmeticError;
    public static PyObject LookupError;
    public static PyObject StandardError;
    public static PyObject Exception;
    public static PyObject Warning;
    public static PyObject UserWarning;
    public static PyObject DeprecationWarning;
    public static PyObject SyntaxWarning;
    public static PyObject RuntimeWarning;
    private static PyObject warnings_mod;
    public static PyObject JavaError;
    private static PyInteger[] integerCache;
    public static PySystemState defaultSystemState;
    private static boolean secEnv;
    private static boolean propertiesInitialized;
    private static ThreadStateMapping threadStateMapping;
    public static StdoutWrapper stderr;
    static StdoutWrapper stdout;
    private static PyString[] letters;
    private static Class[] pyClassCtrSignature;
    private static int nameindex;
    public static final int ERROR = -1;
    public static final int WARNING = 0;
    public static final int MESSAGE = 1;
    public static final int COMMENT = 2;
    public static final int DEBUG = 3;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Lorg$python$core$PyTuple;
    private static /* synthetic */ Class class$Lorg$python$core$PyObject;
    private static /* synthetic */ Class class$Ljava$lang$Class;
    private static /* synthetic */ Class array$Lorg$python$core$PyObject;
    private static /* synthetic */ Class array$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Throwable;
    private static /* synthetic */ Class class$Ljava$io$IOException;
    private static /* synthetic */ Class class$Lorg$python$core$Py;

    public static final PyException OverflowError(String message) {
        return new PyException(OverflowError, message);
    }

    public static final PyException RuntimeError(String message) {
        return new PyException(RuntimeError, message);
    }

    public static final PyException FloatingPointError(String message) {
        return new PyException(FloatingPointError, message);
    }

    public static final PyException SyntaxError(String message) {
        return new PyException(SyntaxError, message);
    }

    public static final PyException AttributeError(String message) {
        return new PyException(AttributeError, message);
    }

    public static final PyException IOError(IOException ioe) {
        String message = ioe.getMessage();
        if (ioe instanceof FileNotFoundException) {
            message = "File not found - " + message;
        }
        return new PyException(IOError, message);
    }

    public static final PyException IOError(String message) {
        return new PyException(IOError, message);
    }

    public static final PyException KeyError(String message) {
        return new PyException(KeyError, message);
    }

    public static final PyException AssertionError(String message) {
        return new PyException(AssertionError, message);
    }

    public static final PyException TypeError(String message) {
        return new PyException(TypeError, message);
    }

    public static final PyException SystemError(String message) {
        return new PyException(SystemError, message);
    }

    public static final PyException IndexError(String message) {
        return new PyException(IndexError, message);
    }

    public static final PyException ZeroDivisionError(String message) {
        return new PyException(ZeroDivisionError, message);
    }

    public static final PyException NameError(String message) {
        return new PyException(NameError, message);
    }

    public static final PyException UnboundLocalError(String message) {
        return new PyException(UnboundLocalError, message);
    }

    static final void maybeSystemExit(PyException exc) {
        if (Py.matchException(exc, SystemExit)) {
            PyObject tmp;
            PyObject value = exc.value;
            if (value instanceof PyInstance && (tmp = value.__findattr__("code")) != null) {
                value = tmp;
            }
            Py.getSystemState().callExitFunc();
            if (value instanceof PyInteger) {
                System.exit(((PyInteger)value).getValue());
            } else {
                if (value != None) {
                    try {
                        Py.println(value);
                        System.exit(1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                System.exit(0);
            }
        }
    }

    public static final PyException ImportError(String message) {
        return new PyException(ImportError, message);
    }

    public static final PyException ValueError(String message) {
        return new PyException(ValueError, message);
    }

    public static final PyException UnicodeError(String message) {
        return new PyException(UnicodeError, message);
    }

    public static final PyException EOFError(String message) {
        return new PyException(EOFError, message);
    }

    public static final void MemoryError(OutOfMemoryError t) {
        if (Options.showJavaExceptions) {
            t.printStackTrace();
        }
        System.err.println("Out of Memory");
        System.err.println("You might want to try the -mx flag to increase heap size");
        System.exit(-1);
    }

    public static final PyException MemoryError(String message) {
        return new PyException(MemoryError, message);
    }

    public static final void Warning(String message) {
        Py.warning(Warning, message);
    }

    public static final void UserWarning(String message) {
        Py.warning(UserWarning, message);
    }

    public static final void DeprecationWarning(String message) {
        Py.warning(DeprecationWarning, message);
    }

    public static final void SyntaxWarning(String message) {
        Py.warning(SyntaxWarning, message);
    }

    public static final void RuntimeWarning(String message) {
        Py.warning(RuntimeWarning, message);
    }

    /*
     * WARNING - void declaration
     */
    private static final PyObject importWarnings() {
        void mod;
        if (warnings_mod != null) {
            return warnings_mod;
        }
        try {
            PyObject pyObject = __builtin__.__import__("warnings");
        }
        catch (PyException e) {
            if (Py.matchException(e, ImportError)) {
                return null;
            }
            throw e;
        }
        warnings_mod = mod;
        return mod;
    }

    private static final String warn_hcategory(PyObject category) {
        PyObject name = category.__findattr__("__name__");
        if (name != null) {
            return "[" + name + "]";
        }
        return "[warning]";
    }

    public static final void warning(PyObject category, String message) {
        PyObject func = null;
        PyObject mod = Py.importWarnings();
        if (mod != null) {
            func = mod.__getattr__("warn");
        }
        if (func == null) {
            System.err.println(Py.warn_hcategory(category) + ": " + message);
            return;
        }
        func.__call__(Py.newString(message), category);
    }

    public static final void warning(PyObject category, String message, String filename, int lineno, String module, PyObject registry) {
        PyObject func = null;
        PyObject mod = Py.importWarnings();
        if (mod != null) {
            func = mod.__getattr__("warn_explicit");
        }
        if (func == null) {
            System.err.println(filename + ":" + lineno + ":" + Py.warn_hcategory(category) + ": " + message);
            return;
        }
        func.__call__(new PyObject[]{Py.newString(message), category, Py.newString(filename), Py.newInteger(lineno), module == null ? None : Py.newString(module), registry}, NoKeywords);
    }

    public static final PyException JavaError(Throwable t) {
        if (t instanceof PyException) {
            return (PyException)t;
        }
        if (t instanceof InvocationTargetException) {
            return Py.JavaError(((InvocationTargetException)t).getTargetException());
        }
        if (t instanceof OutOfMemoryError) {
            Py.MemoryError((OutOfMemoryError)t);
            return null;
        }
        PyObject exc = Py.java2py(t);
        return new PyException((PyObject)exc.__class__, exc);
    }

    public static final Object tojava(PyObject o, Class c) {
        Object obj = o.__tojava__(c);
        if (obj == NoConversion) {
            throw Py.TypeError("can't convert " + o.__repr__() + " to " + c.getName());
        }
        return obj;
    }

    public static final Object tojava(PyObject o, String s) {
        Class c = Py.findClass(s);
        if (c == null) {
            throw Py.TypeError("can't convert to: " + s);
        }
        return Py.tojava(o, c);
    }

    public static final PyObject jfindattr(PyProxy proxy, String name) {
        PyObject ret;
        PyInstance o = proxy._getPyInstance();
        if (o == null) {
            proxy.__initProxy__(new Object[0]);
            o = proxy._getPyInstance();
        }
        if ((ret = o.__jfindattr__(name)) == null) {
            return null;
        }
        Py.setSystemState(proxy._getPySystemState());
        return ret;
    }

    public static final PyObject jgetattr(PyProxy proxy, String name) {
        PyInstance o = proxy._getPyInstance();
        PyObject ret = null;
        if (o != null) {
            ret = o.__jfindattr__(name);
        }
        if (ret == null) {
            throw Py.AttributeError("abstract method \"" + name + "\" not implemented");
        }
        Py.setSystemState(proxy._getPySystemState());
        return ret;
    }

    public static final PyInteger newInteger(int i) {
        if (integerCache == null) {
            integerCache = new PyInteger[1000];
            int j = -100;
            while (j < 900) {
                Py.integerCache[j + 100] = new PyInteger(j);
                ++j;
            }
        }
        if (i >= -100 && i < 900) {
            return integerCache[i + 100];
        }
        return new PyInteger(i);
    }

    public static final PyObject newInteger(long i) {
        if (i < Integer.MIN_VALUE || i > Integer.MAX_VALUE) {
            return new PyLong(i);
        }
        return Py.newInteger((int)i);
    }

    public static final PyLong newLong(String s) {
        return new PyLong(s);
    }

    public static final PyComplex newImaginary(double v) {
        return new PyComplex(0.0, v);
    }

    public static final PyFloat newFloat(float v) {
        return new PyFloat((double)v);
    }

    public static final PyFloat newFloat(double v) {
        return new PyFloat(v);
    }

    public static final PyString newString(char c) {
        return Py.makeCharacter(c);
    }

    public static final PyString newString(String s) {
        return new PyString(s);
    }

    public static final PyInteger newBoolean(boolean t) {
        return t ? One : Zero;
    }

    public static final PyCode newCode(int argcount, String[] varnames, String filename, String name, boolean args, boolean keywords, PyFunctionTable funcs, int func_id, String[] cellvars, String[] freevars, int npurecell, int moreflags) {
        return new PyTableCode(argcount, varnames, filename, name, 0, args, keywords, funcs, func_id, cellvars, freevars, npurecell, moreflags);
    }

    public static final PyCode newCode(int argcount, String[] varnames, String filename, String name, int firstlineno, boolean args, boolean keywords, PyFunctionTable funcs, int func_id, String[] cellvars, String[] freevars, int npurecell, int moreflags) {
        return new PyTableCode(argcount, varnames, filename, name, firstlineno, args, keywords, funcs, func_id, cellvars, freevars, npurecell, moreflags);
    }

    public static final PyCode newCode(int argcount, String[] varnames, String filename, String name, boolean args, boolean keywords, PyFunctionTable funcs, int func_id) {
        return new PyTableCode(argcount, varnames, filename, name, 0, args, keywords, funcs, func_id);
    }

    public static final PyCode newCode(int argcount, String[] varnames, String filename, String name, int firstlineno, boolean args, boolean keywords, PyFunctionTable funcs, int func_id) {
        return new PyTableCode(argcount, varnames, filename, name, firstlineno, args, keywords, funcs, func_id);
    }

    public static final PyCode newJavaCode(Class cls, String name) {
        return new JavaCode(Py.newJavaFunc(cls, name));
    }

    public static final PyObject newJavaFunc(Class cls, String name) {
        try {
            Method m = cls.getMethod(name, array$Lorg$python$core$PyObject != null ? array$Lorg$python$core$PyObject : (array$Lorg$python$core$PyObject = Py.class$("[Lorg.python.core.PyObject;")), array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = Py.class$("[Ljava.lang.String;")));
            return new JavaFunc(m);
        }
        catch (NoSuchMethodException e) {
            throw Py.JavaError(e);
        }
    }

    private static final PyObject initExc(String name, PyObject exceptions2, PyObject dict) {
        PyObject tmp = exceptions2.__getattr__(name);
        dict.__setitem__(name, tmp);
        return tmp;
    }

    static final void initClassExceptions(PyObject dict) {
        PyObject exc = imp.load("exceptions");
        Exception = Py.initExc("Exception", exc, dict);
        SystemExit = Py.initExc("SystemExit", exc, dict);
        StandardError = Py.initExc("StandardError", exc, dict);
        KeyboardInterrupt = Py.initExc("KeyboardInterrupt", exc, dict);
        ImportError = Py.initExc("ImportError", exc, dict);
        EnvironmentError = Py.initExc("EnvironmentError", exc, dict);
        IOError = Py.initExc("IOError", exc, dict);
        OSError = Py.initExc("OSError", exc, dict);
        EOFError = Py.initExc("EOFError", exc, dict);
        RuntimeError = Py.initExc("RuntimeError", exc, dict);
        NotImplementedError = Py.initExc("NotImplementedError", exc, dict);
        NameError = Py.initExc("NameError", exc, dict);
        UnboundLocalError = Py.initExc("UnboundLocalError", exc, dict);
        AttributeError = Py.initExc("AttributeError", exc, dict);
        SyntaxError = Py.initExc("SyntaxError", exc, dict);
        IndentationError = Py.initExc("IndentationError", exc, dict);
        TabError = Py.initExc("TabError", exc, dict);
        TypeError = Py.initExc("TypeError", exc, dict);
        AssertionError = Py.initExc("AssertionError", exc, dict);
        LookupError = Py.initExc("LookupError", exc, dict);
        IndexError = Py.initExc("IndexError", exc, dict);
        KeyError = Py.initExc("KeyError", exc, dict);
        ArithmeticError = Py.initExc("ArithmeticError", exc, dict);
        OverflowError = Py.initExc("OverflowError", exc, dict);
        ZeroDivisionError = Py.initExc("ZeroDivisionError", exc, dict);
        FloatingPointError = Py.initExc("FloatingPointError", exc, dict);
        ValueError = Py.initExc("ValueError", exc, dict);
        UnicodeError = Py.initExc("UnicodeError", exc, dict);
        SystemError = Py.initExc("SystemError", exc, dict);
        MemoryError = Py.initExc("MemoryError", exc, dict);
        Warning = Py.initExc("Warning", exc, dict);
        UserWarning = Py.initExc("UserWarning", exc, dict);
        DeprecationWarning = Py.initExc("DeprecationWarning", exc, dict);
        SyntaxWarning = Py.initExc("SyntaxWarning", exc, dict);
        RuntimeWarning = Py.initExc("RuntimeWarning", exc, dict);
    }

    public static final synchronized boolean initPython() {
        PySystemState.initialize();
        return true;
    }

    public static final Class relFindClass(Class home, String name) {
        try {
            ClassLoader loader = home.getClassLoader();
            if (loader != null) {
                return loader.loadClass(name);
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException exc) {
            return null;
        }
        catch (Throwable t) {
            throw Py.JavaError(t);
        }
    }

    public static final Class findClass(String name) {
        try {
            ClassLoader classLoader = Py.getSystemState().getClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(name);
            }
            if (!secEnv) {
                try {
                    classLoader = imp.getSyspathJavaLoader();
                }
                catch (SecurityException e) {
                    secEnv = true;
                }
                if (classLoader != null) {
                    return classLoader.loadClass(name);
                }
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    public static final Class findClassEx(String name, String reason) {
        try {
            ClassLoader classLoader = Py.getSystemState().getClassLoader();
            if (classLoader != null) {
                Py.writeDebug("import", "trying " + name + " as " + reason + " in classLoader");
                return classLoader.loadClass(name);
            }
            if (!secEnv) {
                try {
                    classLoader = imp.getSyspathJavaLoader();
                }
                catch (SecurityException e) {
                    secEnv = true;
                }
                if (classLoader != null) {
                    Py.writeDebug("import", "trying " + name + " as " + reason + " in syspath loader");
                    return classLoader.loadClass(name);
                }
            }
            Py.writeDebug("import", "trying " + name + " as " + reason + " in Class.forName");
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (LinkageError e) {
            throw Py.JavaError(e);
        }
    }

    private static final void setArgv(String arg0, String[] args) {
        PyObject[] argv = new PyObject[args.length + 1];
        argv[0] = new PyString(arg0);
        int i = 1;
        while (i < argv.length) {
            argv[i] = new PyString(args[i - 1]);
            ++i;
        }
        Py.getSystemState().argv = new PyList(argv);
    }

    private static final synchronized void initProperties(String[] args, String[] packages, String[] props, String frozenPackage, String[] modules, ClassLoader classLoader) {
        if (!propertiesInitialized) {
            Properties sprops;
            propertiesInitialized = true;
            if (frozenPackage != null) {
                frozen = true;
                if (frozenPackage.length() > 0) {
                    Py.frozenPackage = frozenPackage;
                }
            }
            try {
                Properties properties = new Properties(System.getProperties());
            }
            catch (Throwable t) {
                sprops = new Properties();
            }
            if (props != null) {
                int i = 0;
                while (i < props.length) {
                    ((Hashtable)sprops).put(props[i], props[i + 1]);
                    i += 2;
                }
            }
            if (args == null) {
                args = new String[]{};
            }
            PySystemState.initialize(sprops, null, args, classLoader);
        }
        if (modules != null) {
            if (frozenModules == null) {
                frozenModules = new Hashtable();
            }
            int i = 0;
            while (i < modules.length) {
                String modname = modules[i];
                frozenModules.put(modname, PRESENT);
                if (modname.endsWith(".__init__")) {
                    String jpkg = modname.substring(0, modname.length() - 9);
                    PySystemState.add_package(jpkg);
                }
                ++i;
            }
        }
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                PySystemState.add_package(packages[i], packages[i + 1]);
                i += 2;
            }
        }
    }

    public static final void initProxy(PyProxy proxy, String module, String pyclass, Object[] args, String[] packages, String[] props, boolean frozen) {
        Py.initProxy(proxy, module, pyclass, args, packages, props, null, null);
    }

    public static final void initProxy(PyProxy proxy, String module, String pyclass, Object[] args, String[] packages, String[] props, String frozenPackage, String[] modules) {
        PyObject[] pargs;
        PyObject mod;
        Py.initProperties(null, packages, props, frozenPackage, modules, proxy.getClass().getClassLoader());
        if (proxy._getPyInstance() != null) {
            return;
        }
        ThreadState ts = Py.getThreadState();
        PyInstance instance = ts.getInitializingProxy();
        if (instance != null) {
            if (instance.javaProxy != null) {
                throw Py.TypeError("Proxy instance reused");
            }
            instance.javaProxy = proxy;
            proxy._setPyInstance(instance);
            proxy._setPySystemState(ts.systemState);
            return;
        }
        Class modClass = Py.findClass(module + "$_PyInner");
        if (modClass != null) {
            PyCode code = null;
            try {
                code = ((PyRunnable)modClass.newInstance()).getMain();
            }
            catch (Throwable t) {
                throw Py.JavaError(t);
            }
            PyObject pyObject = imp.createFromCode(module, code);
        } else {
            mod = imp.importName(module.intern(), false);
        }
        PyClass pyc = (PyClass)mod.__getattr__(pyclass.intern());
        instance = new PyInstance(pyc);
        instance.javaProxy = proxy;
        proxy._setPyInstance(instance);
        proxy._setPySystemState(ts.systemState);
        if (args == null || args.length == 0) {
            PyObject[] t = EmptyObjects;
        } else {
            pargs = new PyObject[args.length];
            int i = 0;
            while (i < args.length) {
                pargs[i] = Py.java2py(args[i]);
                ++i;
            }
        }
        instance.__init__(pargs, NoKeywords);
    }

    public static final void initRunnable(String module, PyObject dict) {
        Class<?> mainClass = null;
        try {
            mainClass = Class.forName(module);
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Error running main.  Can't find: " + module);
            System.exit(-1);
        }
        PyCode code = null;
        try {
            code = ((PyRunnable)mainClass.newInstance()).getMain();
        }
        catch (Throwable t) {
            System.err.println("Invalid class (runnable): " + module + "$py");
            System.exit(-1);
        }
        Py.runCode(code, dict, dict);
    }

    public static final void runMain(Class mainClass, String[] args, String[] packages, String[] props, String frozenPackage, String[] modules) throws Exception {
        Py.initProperties(args, packages, props, frozenPackage, modules, mainClass.getClassLoader());
        try {
            PyCode code = null;
            try {
                code = ((PyRunnable)mainClass.newInstance()).getMain();
            }
            catch (Throwable t) {
                System.err.println("Invalid class: " + mainClass.getName() + "$py");
                System.exit(-1);
            }
            PyObject pyObject = imp.createFromCode("__main__", code);
        }
        catch (PyException e) {
            Py.getSystemState().callExitFunc();
            if (Py.matchException(e, SystemExit)) {
                return;
            }
            throw e;
        }
        Py.getSystemState().callExitFunc();
    }

    private static final String getStackTrace(Throwable javaError) {
        int index0;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        javaError.printStackTrace(new PrintStream(buf));
        String str = buf.toString();
        int index = -1;
        if (index == -1) {
            index = str.indexOf("at org.python.core.PyReflectedConstructor.call");
        }
        if (index == -1) {
            index = str.indexOf("at org.python.core.PyReflectedMethod.call");
        }
        if (index == -1) {
            index = str.indexOf("at org/python/core/PyReflectedConstructor.call");
        }
        if (index == -1) {
            index = str.indexOf("at org/python/core/PyReflectedMethod.call");
        }
        if (index != -1) {
            index = str.lastIndexOf("\n", index);
        }
        if (index >= (index0 = str.indexOf("\n"))) {
            str = str.substring(index0 + 1, index + 1);
        }
        return str;
    }

    public static final void printException(Throwable t) {
        Py.printException(t, null, null);
    }

    public static final void printException(Throwable t, PyFrame f) {
        Py.printException(t, f, null);
    }

    public static final synchronized void printException(Throwable t, PyFrame f, PyObject file) {
        StdoutWrapper stderr = Py.stderr;
        if (file != null) {
            stderr = new FixedFileWrapper(file);
        }
        if (Options.showJavaExceptions) {
            stderr.println("Java Traceback:");
            CharArrayWriter buf = new CharArrayWriter();
            if (t instanceof PyException) {
                ((PyException)t).super__printStackTrace(new PrintWriter(buf));
            } else {
                t.printStackTrace(new PrintWriter(buf));
            }
            stderr.print(buf.toString());
        }
        PyException exc = Py.JavaError(t);
        Py.maybeSystemExit(exc);
        if (f != null && exc.traceback.tb_frame != f) {
            exc.traceback = new PyTraceback(exc.traceback);
        }
        Py.setException(exc, f);
        ThreadState ts = Py.getThreadState();
        ts.systemState.last_value = exc.value;
        ts.systemState.last_type = exc.type;
        ts.systemState.last_traceback = exc.traceback;
        PyObject exceptHook = ts.systemState.__findattr__("excepthook");
        if (exceptHook != null) {
            try {
                exceptHook.__call__(exc.type, exc.value, exc.traceback);
            }
            catch (PyException exc2) {
                stderr.println("Error in sys.excepthook:");
                Py.displayException(exc2.type, exc2.value, exc2.traceback, file);
                stderr.println();
                stderr.println("Original exception was:");
                Py.displayException(exc.type, exc.value, exc.traceback, file);
            }
        } else {
            stderr.println("sys.excepthook is missing");
            Py.displayException(exc.type, exc.value, exc.traceback, file);
        }
        ts.exception = null;
    }

    public static final void displayException(PyObject type, PyObject value, PyObject tb, PyObject file) {
        Object javaError;
        StdoutWrapper stderr = Py.stderr;
        if (file != null) {
            stderr = new FixedFileWrapper(file);
        }
        if (tb instanceof PyTraceback) {
            stderr.print(((PyTraceback)tb).dumpStack());
        }
        if (__builtin__.isinstance(value, (PyClass)SyntaxError)) {
            stderr.println("  File \"" + value.__findattr__("filename") + "\", line " + value.__findattr__("lineno"));
            PyObject text = value.__findattr__("text");
            if (text != None && text.__len__() != 0) {
                stderr.println("\t" + text);
                String space = "\t";
                int col = value.__findattr__("offset").__int__().getValue();
                int j = 1;
                while (j < col) {
                    space = space + " ";
                    ++j;
                }
                stderr.println(space + "^");
            }
        }
        if (value instanceof PyJavaInstance && (javaError = value.__tojava__(class$Ljava$lang$Throwable != null ? class$Ljava$lang$Throwable : (class$Ljava$lang$Throwable = Py.class$("java.lang.Throwable")))) != null && javaError != NoConversion) {
            stderr.println(Py.getStackTrace((Throwable)javaError));
        }
        stderr.println(Py.formatException(type, value, tb));
    }

    static final String formatException(PyObject type, PyObject value, PyObject tb) {
        StringBuffer buf = new StringBuffer();
        if (type instanceof PyClass) {
            buf.append(((PyClass)type).__name__);
        } else {
            buf.append(type.__str__());
        }
        if (value != None) {
            buf.append(": ");
            if (__builtin__.isinstance(value, (PyClass)SyntaxError)) {
                buf.append(value.__getitem__(0).__str__());
            } else {
                buf.append(value.__str__());
            }
        }
        return buf.toString();
    }

    public static final void assert(PyObject test, PyObject message) {
        if (!test.__nonzero__()) {
            throw new PyException(AssertionError, message);
        }
    }

    public static final void assert(PyObject test) {
        Py.assert(test, None);
    }

    public static final void addTraceback(Throwable t, PyFrame frame) {
        PyException e = Py.JavaError(t);
        if (e.traceback.tb_frame != frame) {
            e.traceback = new PyTraceback(e.traceback);
        }
    }

    public static final PyException setException(Throwable t, PyFrame frame) {
        PyException pye = Py.JavaError(t);
        pye.instantiate();
        ThreadState ts = Py.getThreadState();
        ts.exception = pye;
        return pye;
    }

    public static final boolean matchException(PyException pye, PyObject e) {
        pye.instantiate();
        if (e == IOError && __builtin__.isinstance(pye.value, PyJavaClass.lookup(class$Ljava$io$IOException != null ? class$Ljava$io$IOException : (class$Ljava$io$IOException = Py.class$("java.io.IOException"))))) {
            return true;
        }
        if (e instanceof PyClass) {
            return __builtin__.isinstance(pye.value, (PyClass)e);
        }
        if (e == pye.type) {
            return true;
        }
        if (e instanceof PyTuple) {
            PyObject[] l = ((PyTuple)e).list;
            int i = 0;
            while (i < l.length) {
                if (Py.matchException(pye, l[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static final PyException makeException() {
        ThreadState ts = Py.getThreadState();
        if (ts.exception == null) {
            throw Py.ValueError("no exception to reraise");
        }
        return ts.exception;
    }

    public static final PyException makeException(PyObject type) {
        if (type instanceof PyInstance) {
            return new PyException((PyObject)type.__class__, type);
        }
        return Py.makeException(type, None);
    }

    public static final PyException makeException(PyObject type, PyObject value) {
        if (type instanceof PyInstance) {
            if (value != None) {
                throw Py.TypeError("instance exceptions may not have a separate value");
            }
            return new PyException((PyObject)type.__class__, type);
        }
        PyException exc = new PyException(type, value);
        exc.instantiate();
        return exc;
    }

    public static final PyException makeException(PyObject type, PyObject value, PyObject traceback) {
        if (type instanceof PyInstance) {
            if (value != None) {
                throw Py.TypeError("instance exceptions may not have a separate value");
            }
            type = type.__class__;
        }
        if (traceback == None) {
            return new PyException(type, value);
        }
        if (!(traceback instanceof PyTraceback)) {
            throw Py.TypeError("raise 3rd arg must be traceback or None");
        }
        return new PyException(type, value, (PyTraceback)traceback);
    }

    public static final PyObject runCode(PyCode code, PyObject locals, PyObject globals) {
        if (locals == null) {
            locals = globals != null ? globals : Py.getFrame().getf_locals();
        }
        if (globals == null) {
            globals = Py.getFrame().f_globals;
        }
        PyTableCode tc = null;
        if (code instanceof PyTableCode) {
            tc = (PyTableCode)code;
        }
        PyFrame f = new PyFrame(tc, locals, globals, Py.getThreadState().systemState.builtins);
        return code.call(f);
    }

    public static final void exec(PyObject o, PyObject globals, PyObject locals) {
        PyCode code;
        if (o instanceof PyCode) {
            PyCode pyCode = (PyCode)o;
        } else {
            String contents = null;
            if (o instanceof PyString) {
                contents = o.toString();
            } else if (o instanceof PyFile) {
                PyFile fp = (PyFile)o;
                if (fp.closed) {
                    return;
                }
                contents = fp.read().toString();
            } else {
                throw Py.TypeError("exec: argument 1 must be string, code or file object");
            }
            code = Py.compile_flags(contents, "<string>", "exec", Py.getCompilerFlags());
        }
        Py.runCode(code, locals, globals);
    }

    public static final ThreadState getThreadState() {
        return Py.getThreadState(null);
    }

    public static final ThreadState getThreadState(PySystemState newSystemState) {
        if (threadStateMapping == null) {
            Class clazz = class$Lorg$python$core$Py != null ? class$Lorg$python$core$Py : (class$Lorg$python$core$Py = Py.class$("org.python.core.Py"));
            synchronized (clazz) {
                if (threadStateMapping == null) {
                    threadStateMapping = ThreadStateMapping.makeMapping();
                }
            }
        }
        return threadStateMapping.getThreadState(newSystemState);
    }

    public static final PySystemState setSystemState(PySystemState newSystemState) {
        ThreadState ts = Py.getThreadState(newSystemState);
        PySystemState oldSystemState = ts.systemState;
        if (oldSystemState != newSystemState) {
            ts.systemState = newSystemState;
        }
        return oldSystemState;
    }

    public static final PySystemState getSystemState() {
        return Py.getThreadState().systemState;
    }

    public static final PyFrame getFrame() {
        ThreadState ts = Py.getThreadState();
        if (ts == null) {
            return null;
        }
        return ts.frame;
    }

    public static final void setFrame(PyFrame f) {
        Py.getThreadState().frame = f;
    }

    public static final void print(PyObject file, PyObject o) {
        if (file == None) {
            Py.print(o);
        } else {
            new FixedFileWrapper(file).print(o);
        }
    }

    public static final void printComma(PyObject file, PyObject o) {
        if (file == None) {
            Py.printComma(o);
        } else {
            new FixedFileWrapper(file).printComma(o);
        }
    }

    public static final void println(PyObject file, PyObject o) {
        if (file == None) {
            Py.println(o);
        } else {
            new FixedFileWrapper(file).println(o);
        }
    }

    public static final void printlnv(PyObject file) {
        if (file == None) {
            Py.println();
        } else {
            new FixedFileWrapper(file).println();
        }
    }

    public static final void print(PyObject o) {
        stdout.print(o);
    }

    public static final void printComma(PyObject o) {
        stdout.printComma(o);
    }

    public static final void println(PyObject o) {
        stdout.println(o);
    }

    public static final void println() {
        stdout.println();
    }

    public static final boolean py2boolean(PyObject o) {
        return o.__nonzero__();
    }

    public static final byte py2byte(PyObject o) {
        if (o instanceof PyInteger) {
            return (byte)((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Byte.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Byte)i;
    }

    public static final short py2short(PyObject o) {
        if (o instanceof PyInteger) {
            return (short)((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Short.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Short)i;
    }

    public static final int py2int(PyObject o) {
        return Py.py2int(o, "integer required");
    }

    public static final int py2int(PyObject o, String msg) {
        if (o instanceof PyInteger) {
            return ((PyInteger)o).getValue();
        }
        Object obj = o.__tojava__(Integer.TYPE);
        if (obj == NoConversion) {
            throw Py.TypeError(msg);
        }
        return (Integer)obj;
    }

    public static final long py2long(PyObject o) {
        if (o instanceof PyInteger) {
            return ((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Long.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Long)i;
    }

    public static final float py2float(PyObject o) {
        if (o instanceof PyFloat) {
            return (float)((PyFloat)o).getValue();
        }
        if (o instanceof PyInteger) {
            return ((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Float.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError("float required");
        }
        return ((Float)i).floatValue();
    }

    public static final double py2double(PyObject o) {
        if (o instanceof PyFloat) {
            return ((PyFloat)o).getValue();
        }
        if (o instanceof PyInteger) {
            return ((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Double.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError("float required");
        }
        return (Double)i;
    }

    public static final char py2char(PyObject o) {
        return Py.py2char(o, "char required");
    }

    public static final char py2char(PyObject o, String msg) {
        if (o instanceof PyString) {
            PyString s = (PyString)o;
            if (s.__len__() != 1) {
                throw Py.TypeError(msg);
            }
            return s.toString().charAt(0);
        }
        if (o instanceof PyInteger) {
            return (char)((PyInteger)o).getValue();
        }
        Object i = o.__tojava__(Character.TYPE);
        if (i == null || i == NoConversion) {
            throw Py.TypeError(msg);
        }
        return ((Character)i).charValue();
    }

    public static final void py2void(PyObject o) {
        if (o != None) {
            throw Py.TypeError("None required for void return");
        }
    }

    static final PyString makeCharacter(Character o) {
        return Py.makeCharacter(o.charValue());
    }

    static final PyString makeCharacter(char c) {
        if (c > '\u00ff') {
            return new PyString(new Character(c).toString());
        }
        if (letters == null) {
            letters = new PyString[256];
            char j = '\u0000';
            while (j < '\u0100') {
                Py.letters[j] = new PyString(new Character(j).toString());
                j = (char)(j + '\u0001');
            }
        }
        return letters[c];
    }

    public static final PyObject java2py(Object o) {
        if (o instanceof PyObject) {
            return (PyObject)o;
        }
        if (o instanceof PyProxy) {
            return ((PyProxy)o)._getPyInstance();
        }
        if (o instanceof Number) {
            if (o instanceof Double || o instanceof Float) {
                return new PyFloat(((Number)o).doubleValue());
            }
            if (o instanceof Long) {
                return new PyLong(((Number)o).longValue());
            }
            if (o instanceof Integer || o instanceof Byte || o instanceof Short) {
                return new PyInteger(((Number)o).intValue());
            }
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? One : Zero;
        }
        if (o == null) {
            return None;
        }
        if (o instanceof String) {
            return new PyString((String)o);
        }
        if (o instanceof Character) {
            return Py.makeCharacter((Character)o);
        }
        if (o instanceof Class) {
            return PyJavaClass.lookup((Class)o);
        }
        Class<?> c = o.getClass();
        if (c.isArray()) {
            return new PyArray(c.getComponentType(), o);
        }
        return new PyJavaInstance(o);
    }

    public static final PyObject makeClass(String name, PyObject[] bases, PyCode code, PyObject doc) {
        return Py.makeClass(name, bases, code, doc, null, null);
    }

    public static final PyObject makeClass(String name, PyObject[] bases, PyCode code, PyObject doc, PyObject[] closure_cells) {
        return Py.makeClass(name, bases, code, doc, null, closure_cells);
    }

    public static final PyObject makeClass(String name, PyObject[] bases, PyCode code, PyObject doc, Class proxyClass) {
        return Py.makeClass(name, bases, code, doc, proxyClass, null);
    }

    public static final PyObject makeClass(String name, PyObject[] bases, PyCode code, PyObject doc, Class proxyClass, PyObject[] closure_cells) {
        PyFrame frame = Py.getFrame();
        PyObject globals = frame.f_globals;
        PyObject dict = code.call(EmptyObjects, NoKeywords, globals, EmptyObjects, (PyObject)new PyTuple(closure_cells));
        if (doc != null) {
            dict.__setitem__("__doc__", doc);
        }
        int i = 0;
        while (i < bases.length) {
            if (!(bases[i] instanceof PyClass)) {
                PyClass c = bases[i].__class__;
                if (c instanceof PyJavaClass) {
                    throw Py.TypeError("base is not a class object: " + bases[i].safeRepr());
                }
                return c.__call__((PyObject)new PyString(name), new PyTuple(bases), dict);
            }
            if (bases[i] instanceof PyMetaClass) {
                try {
                    Constructor<?> ctor = bases[i].getClass().getConstructor(pyClassCtrSignature);
                    return (PyObject)ctor.newInstance(name, new PyTuple(bases), dict, proxyClass);
                }
                catch (Exception e) {
                    throw Py.TypeError("meta-class fails to supply proper ctr: " + bases[i].safeRepr());
                }
            }
            ++i;
        }
        return new PyClass(name, new PyTuple(bases), dict, proxyClass);
    }

    public static final synchronized String getName() {
        String name = "org.python.pycode._pyx" + nameindex;
        ++nameindex;
        return name;
    }

    public static final CompilerFlags getCompilerFlags() {
        CompilerFlags cflags = null;
        PyFrame frame = Py.getFrame();
        if (frame != null && frame.f_code != null) {
            cflags = new CompilerFlags(frame.f_code.co_flags);
        }
        return cflags;
    }

    public static final PyCode compile(SimpleNode node, String filename) {
        return Py.compile(node, Py.getName(), filename);
    }

    public static final PyCode compile(SimpleNode node, String name, String filename) {
        return Py.compile(node, name, filename, true, false);
    }

    public static final PyCode compile(SimpleNode node, String name, String filename, boolean linenumbers, boolean printResults) {
        return Py.compile_flags(node, name, filename, linenumbers, printResults, null);
    }

    public static final PyCode compile(InputStream istream, String filename, String type) {
        return Py.compile_flags(istream, filename, type, null);
    }

    public static final PyCode compile_flags(SimpleNode node, String name, String filename, boolean linenumbers, boolean printResults, CompilerFlags cflags) {
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            Module.compile(node, ostream, name, filename, linenumbers, printResults, false, cflags);
            Py.saveClassFile(name, ostream);
            return BytecodeLoader.makeCode(name, ostream.toByteArray());
        }
        catch (Throwable t) {
            throw parser.fixParseError(null, t, filename);
        }
    }

    public static final PyCode compile_flags(InputStream istream, String filename, String type, CompilerFlags cflags) {
        SimpleNode node = parser.parse(istream, type, filename, cflags);
        boolean printResults = false;
        if (type.equals("single")) {
            printResults = true;
        }
        return Py.compile_flags(node, Py.getName(), filename, true, printResults, cflags);
    }

    public static final PyCode compile_flags(String data, String filename, String type, CompilerFlags cflags) {
        return Py.compile_flags(new StringBufferInputStream(data + "\n\n"), filename, type, cflags);
    }

    public static final PyObject[] unpackSequence(PyObject o, int length) {
        if (o instanceof PyTuple) {
            PyTuple tup = (PyTuple)o;
            if (tup.__len__() == length) {
                return tup.list;
            }
            throw Py.ValueError("unpack tuple of wrong size");
        }
        PyObject[] ret = new PyObject[length];
        try {
            int i = 0;
            while (i < length) {
                PyObject tmp = o.__finditem__(i);
                if (tmp == null) {
                    throw Py.ValueError("unpack sequence too short");
                }
                ret[i] = tmp;
                ++i;
            }
        }
        catch (PyException exc) {
            if (Py.matchException(exc, AttributeError)) {
                throw Py.TypeError("unpack non-sequence");
            }
            throw exc;
        }
        if (o.__finditem__(length) != null) {
            throw Py.ValueError("unpack sequence too long");
        }
        return ret;
    }

    public static final int id(PyObject o) {
        if (o instanceof PyJavaInstance) {
            return System.identityHashCode(((PyJavaInstance)o).javaProxy);
        }
        return System.identityHashCode(o);
    }

    public static final String safeRepr(PyObject o) {
        return o.safeRepr();
    }

    public static final void printResult(PyObject ret) {
        Py.getThreadState().systemState.invoke("displayhook", ret);
    }

    public static final void maybeWrite(String type, String msg, int level) {
        if (level <= Options.verbose) {
            System.err.println(type + ": " + msg);
        }
    }

    public static final void writeError(String type, String msg) {
        Py.maybeWrite(type, msg, -1);
    }

    public static final void writeWarning(String type, String msg) {
        Py.maybeWrite(type, msg, 0);
    }

    public static final void writeMessage(String type, String msg) {
        Py.maybeWrite(type, msg, 1);
    }

    public static final void writeComment(String type, String msg) {
        Py.maybeWrite(type, msg, 2);
    }

    public static final void writeDebug(String type, String msg) {
        Py.maybeWrite(type, msg, 3);
    }

    static final void saveClassFile(String name, ByteArrayOutputStream bytestream) {
        String dirname = Options.proxyDebugDirectory;
        if (dirname == null) {
            return;
        }
        byte[] bytes = bytestream.toByteArray();
        File dir = new File(dirname);
        File file = Py.makeFilename(name, dir);
        new File(file.getParent()).mkdirs();
        try {
            FileOutputStream o = new FileOutputStream(file);
            o.write(bytes);
            o.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private static final File makeFilename(String name, File dir) {
        int index = name.indexOf(".");
        if (index == -1) {
            return new File(dir, name + ".class");
        }
        return Py.makeFilename(name.substring(index + 1, name.length()), new File(dir, name.substring(0, index)));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Py() {
    }

    static {
        frozenPackage = null;
        PRESENT = new Object();
        integerCache = null;
        secEnv = false;
        propertiesInitialized = false;
        threadStateMapping = null;
        letters = null;
        pyClassCtrSignature = new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Py.class$("java.lang.String")), class$Lorg$python$core$PyTuple != null ? class$Lorg$python$core$PyTuple : (class$Lorg$python$core$PyTuple = Py.class$("org.python.core.PyTuple")), class$Lorg$python$core$PyObject != null ? class$Lorg$python$core$PyObject : (class$Lorg$python$core$PyObject = Py.class$("org.python.core.PyObject")), class$Ljava$lang$Class != null ? class$Ljava$lang$Class : (class$Ljava$lang$Class = Py.class$("java.lang.Class"))};
        nameindex = 0;
    }
}

