/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.HashMap;
import net.sf.mpxj.Day;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.ExtendedDocumentSummaryInformation;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public final class ProjectPropertiesReader {
    public void process(ProjectFile projectFile, Props props, DirectoryEntry directoryEntry) throws MPXJException {
        try {
            ProjectProperties projectProperties = projectFile.getProjectProperties();
            projectProperties.setStartDate(props.getTimestamp(Props.PROJECT_START_DATE));
            projectProperties.setFinishDate(props.getTimestamp(Props.PROJECT_FINISH_DATE));
            projectProperties.setScheduleFrom(ScheduleFrom.getInstance(1 - props.getShort(Props.SCHEDULE_FROM)));
            projectProperties.setDefaultCalendarName(props.getUnicodeString(Props.DEFAULT_CALENDAR_NAME));
            projectProperties.setDefaultStartTime(props.getTime(Props.START_TIME));
            projectProperties.setDefaultEndTime(props.getTime(Props.END_TIME));
            projectProperties.setStatusDate(props.getTimestamp(Props.STATUS_DATE));
            projectProperties.setHyperlinkBase(props.getUnicodeString(Props.HYPERLINK_BASE));
            projectProperties.setDefaultDurationUnits(MPPUtility.getDurationTimeUnits(props.getShort(Props.DURATION_UNITS)));
            projectProperties.setMinutesPerDay(props.getInt(Props.MINUTES_PER_DAY));
            projectProperties.setMinutesPerWeek(props.getInt(Props.MINUTES_PER_WEEK));
            projectProperties.setDefaultOvertimeRate(new Rate(props.getDouble(Props.OVERTIME_RATE), TimeUnit.HOURS));
            projectProperties.setDefaultStandardRate(new Rate(props.getDouble(Props.STANDARD_RATE), TimeUnit.HOURS));
            projectProperties.setDefaultWorkUnits(MPPUtility.getWorkTimeUnits(props.getShort(Props.WORK_UNITS)));
            projectProperties.setSplitInProgressTasks(props.getBoolean(Props.SPLIT_TASKS));
            projectProperties.setUpdatingTaskStatusUpdatesResourceStatus(props.getBoolean(Props.TASK_UPDATES_RESOURCE));
            projectProperties.setCurrencyDigits(props.getShort(Props.CURRENCY_DIGITS));
            projectProperties.setCurrencySymbol(props.getUnicodeString(Props.CURRENCY_SYMBOL));
            projectProperties.setCurrencyCode(props.getUnicodeString(Props.CURRENCY_CODE));
            projectProperties.setSymbolPosition(MPPUtility.getSymbolPosition(props.getShort(Props.CURRENCY_PLACEMENT)));
            projectProperties.setWeekStartDay(Day.getInstance(props.getShort(Props.WEEK_START_DAY) + 1));
            projectProperties.setFiscalYearStartMonth(props.getShort(Props.FISCAL_YEAR_START_MONTH));
            projectProperties.setFiscalYearStart(props.getShort(Props.FISCAL_YEAR_START) == 1);
            projectProperties.setDaysPerMonth(props.getShort(Props.DAYS_PER_MONTH));
            projectProperties.setEditableActualCosts(props.getBoolean(Props.EDITABLE_ACTUAL_COSTS));
            projectProperties.setHonorConstraints(!props.getBoolean(Props.HONOR_CONSTRAINTS));
            PropertySet propertySet = new PropertySet(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("\u0005SummaryInformation")));
            SummaryInformation summaryInformation = new SummaryInformation(propertySet);
            projectProperties.setProjectTitle(summaryInformation.getTitle());
            projectProperties.setSubject(summaryInformation.getSubject());
            projectProperties.setAuthor(summaryInformation.getAuthor());
            projectProperties.setKeywords(summaryInformation.getKeywords());
            projectProperties.setComments(summaryInformation.getComments());
            projectProperties.setTemplate(summaryInformation.getTemplate());
            projectProperties.setLastAuthor(summaryInformation.getLastAuthor());
            projectProperties.setRevision(NumberHelper.parseInteger(summaryInformation.getRevNumber()));
            projectProperties.setCreationDate(summaryInformation.getCreateDateTime());
            projectProperties.setLastSaved(summaryInformation.getLastSaveDateTime());
            projectProperties.setShortApplicationName(summaryInformation.getApplicationName());
            projectProperties.setEditingTime((int)summaryInformation.getEditTime());
            projectProperties.setLastPrinted(summaryInformation.getLastPrinted());
            propertySet = new PropertySet(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("\u0005DocumentSummaryInformation")));
            ExtendedDocumentSummaryInformation extendedDocumentSummaryInformation = new ExtendedDocumentSummaryInformation(propertySet);
            projectProperties.setCategory(extendedDocumentSummaryInformation.getCategory());
            projectProperties.setPresentationFormat(extendedDocumentSummaryInformation.getPresentationFormat());
            projectProperties.setManager(extendedDocumentSummaryInformation.getManager());
            projectProperties.setCompany(extendedDocumentSummaryInformation.getCompany());
            projectProperties.setContentType(extendedDocumentSummaryInformation.getContentType());
            projectProperties.setContentStatus(extendedDocumentSummaryInformation.getContentStatus());
            projectProperties.setLanguage(extendedDocumentSummaryInformation.getLanguage());
            projectProperties.setDocumentVersion(extendedDocumentSummaryInformation.getDocumentVersion());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            CustomProperties customProperties = extendedDocumentSummaryInformation.getCustomProperties();
            if (customProperties != null) {
                for (CustomProperty customProperty : customProperties.values()) {
                    hashMap.put(customProperty.getName(), customProperty.getValue());
                }
            }
            projectProperties.setCustomProperties(hashMap);
            projectProperties.setCalculateMultipleCriticalPaths(props.getBoolean(Props.CALCULATE_MULTIPLE_CRITICAL_PATHS));
            projectProperties.setBaselineDate(props.getTimestamp(Props.BASELINE_DATE));
            projectProperties.setBaselineDate(1, props.getTimestamp(Props.BASELINE1_DATE));
            projectProperties.setBaselineDate(2, props.getTimestamp(Props.BASELINE2_DATE));
            projectProperties.setBaselineDate(3, props.getTimestamp(Props.BASELINE3_DATE));
            projectProperties.setBaselineDate(4, props.getTimestamp(Props.BASELINE4_DATE));
            projectProperties.setBaselineDate(5, props.getTimestamp(Props.BASELINE5_DATE));
            projectProperties.setBaselineDate(6, props.getTimestamp(Props.BASELINE6_DATE));
            projectProperties.setBaselineDate(7, props.getTimestamp(Props.BASELINE7_DATE));
            projectProperties.setBaselineDate(8, props.getTimestamp(Props.BASELINE8_DATE));
            projectProperties.setBaselineDate(9, props.getTimestamp(Props.BASELINE9_DATE));
            projectProperties.setBaselineDate(10, props.getTimestamp(Props.BASELINE10_DATE));
        }
        catch (Exception exception) {
            throw new MPXJException("Error reading file", exception);
        }
    }
}

