/*
 * Decompiled with CFR 0.152.
 */
package ricoh.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import ricoh.util.image.BadImageFormatException;
import ricoh.util.image.Bitmap;
import ricoh.util.image.BitmapProcessor;

public class BitmapProcess
extends Task {
    private String action;
    private File source;
    private File output;
    private BitmapProcessor proc = new BitmapProcessor();
    private boolean isSingleFile;
    private ArrayList filesets = null;

    public void setAction(String theAction) {
        this.action = theAction;
        this.proc.setAction(this.action);
    }

    public void setInput(String input) {
        this.isSingleFile = true;
        this.source = new File(input);
        this.proc.setInput(this.source);
    }

    public void setOutput(String outputFilename) {
        this.output = new File(outputFilename);
        this.proc.setOutput(this.output);
    }

    private void validate() {
        boolean failedValidation = false;
        if (this.source == null && (this.filesets == null || this.filesets.size() == 0)) {
            failedValidation = true;
            System.out.println("No source file(s) specified.");
        }
        if (this.action == null || !BitmapProcessor.isValidAction((String)this.action)) {
            failedValidation = true;
            System.out.println("The attribute \"action\" was not specified or is not a valid action.");
        }
        if (this.source != null && this.filesets != null) {
            failedValidation = true;
            System.out.println("Attributes \"input\" and \"filesets\" should not be both specified.");
        }
        if (failedValidation) {
            throw new BuildException("Missing or bad attributes detected; check build script syntax.");
        }
    }

    public void addFileset(FileSet fileset) {
        this.isSingleFile = false;
        if (this.filesets == null) {
            this.filesets = new ArrayList();
        }
        this.filesets.add(fileset);
    }

    public void execute() {
        this.validate();
        if (this.isSingleFile) {
            System.out.println("Processing " + this.source.getName() + "...");
            Bitmap theBitmap = new Bitmap();
            try {
                theBitmap.loadBitmap(this.source);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new BuildException("The source file " + this.source.getName() + " was not found.");
            }
            catch (BadImageFormatException e) {
                e.printStackTrace();
                throw new BuildException("The source file " + this.source.getName() + " is not a valid bitmap file.");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BuildException("There was an error in reading the source file " + this.source.getName());
            }
            this.proc.performAction(this.action, theBitmap);
            System.out.println("Saved output file as: " + this.output.getName());
        } else {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fs = (FileSet)this.filesets.get(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] includedFiles = ds.getIncludedFiles();
                Bitmap currentBitmap = new Bitmap();
                for (int j = 0; j < includedFiles.length; ++j) {
                    this.source = new File(ds.getBasedir() + File.separator + includedFiles[j]);
                    this.output = new File(ds.getBasedir() + File.separator + includedFiles[j] + ".modified");
                    this.proc.setOutput(this.output);
                    try {
                        currentBitmap.loadBitmap(this.source);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        throw new BuildException("The source file " + this.source.getName() + " was not found.");
                    }
                    catch (BadImageFormatException e) {
                        e.printStackTrace();
                        throw new BuildException("The source file " + this.source.getName() + " is not a valid bitmap file.");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new BuildException("There was an error in reading the source file " + this.source.getName());
                    }
                    System.out.println("Processing " + this.source.getName() + "...");
                    this.proc.performAction(this.action, currentBitmap);
                    System.out.println("Saved output file as: " + this.output.getName());
                }
            }
        }
    }
}

