/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.repository.queue.KeyValueQueue;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class RepositoryQueue
extends KeyValueQueue<Key, Persistent> {
    @Override
    protected boolean needsTiming() {
        return Stats.queueTiming;
    }

    @Override
    protected boolean needsTrace() {
        return Stats.queueTrace;
    }

    @Override
    protected String getTraceName() {
        return "RepositoryQueue@" + this.hashCode();
    }

    @Override
    protected void doReplaceAddLast(Key key, Persistent value, KeyValueQueue.Entry<Key, Persistent> existent) {
        super.doReplaceAddLast(key, value, existent);
        this.queue.remove(existent);
        this.queue.addLast(existent);
    }

    public void onIdle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<KeyValueQueue.Entry<Key, Persistent>> clearQueue(Filter filter) {
        this.pushLastFromDispatcher();
        Object object = this.lock;
        synchronized (object) {
            ArrayList<KeyValueQueue.Entry<Key, Persistent>> removed = new ArrayList<KeyValueQueue.Entry<Key, Persistent>>();
            for (KeyValueQueue.Entry entry : this.map.values()) {
                if (!filter.accept((Key)entry.getKey(), (Persistent)entry.getValue())) continue;
                removed.add(entry);
            }
            for (KeyValueQueue.Entry entry : removed) {
                this.remove(entry.getKey());
            }
            return removed;
        }
    }

    public static interface Filter {
        public boolean accept(Key var1, Persistent var2);
    }
}

