/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.PopupItem;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.ui.search.ResultsModel;
import org.netbeans.modules.bugtracking.ui.search.SearchResultRenderer;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class QuickSearchPopup
extends JPanel
implements ListDataListener,
ActionListener,
TaskListener,
Runnable {
    private QuickSearchComboBar comboBar;
    private ResultsModel rModel;
    private Rectangle popupBounds = new Rectangle();
    private static final int[] COALESCE_TIMES = new int[]{150, 400, 300, 200};
    private Timer updateTimer;
    private String searchedText;
    private RequestProcessor.Task evalTask;
    private Repository repository;
    private RequestProcessor rp;
    private List<PopupItem> currentHitlist;
    private JLabel hintLabel;
    private JSeparator hintSep;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JLabel noResultsLabel;
    private JLabel searchingLabel;
    private JSeparator searchingSep;
    private JPanel statusPanel;

    public QuickSearchPopup(QuickSearchComboBar comboBar) {
        this.comboBar = comboBar;
        this.initComponents();
        this.hintLabel.setVisible(false);
        this.hintSep.setVisible(false);
        this.rModel = ResultsModel.getInstance();
        this.jList1.setModel(this.rModel);
        this.jList1.setCellRenderer(new SearchResultRenderer(comboBar, this));
        this.rp = new RequestProcessor("Bugtracking quick issue search", 1, true);
        this.setVisible(false);
        this.updateStatusPanel();
    }

    @Override
    public void addNotify() {
        this.rModel.addListDataListener(this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.rModel.removeListDataListener(this);
        super.removeNotify();
    }

    void invoke() {
        int selection = this.jList1.getSelectedIndex();
        ListModel model = this.jList1.getModel();
        Object item = model.getElementAt(selection);
        if (item == null) {
            return;
        }
        if (item instanceof PopupItem.IssueItem) {
            Issue issue = ((PopupItem.IssueItem)item).getIssue();
            if (issue != null) {
                this.comboBar.setIssue(issue);
                this.clearModel();
            }
        } else {
            PopupItem pitem = (PopupItem)item;
            pitem.invoke();
        }
    }

    void selectNext() {
        int oldSel = this.jList1.getSelectedIndex();
        if (oldSel >= 0 && oldSel < this.jList1.getModel().getSize() - 1) {
            int idx = oldSel + 1;
            this.jList1.setSelectedIndex(idx);
            this.jList1.scrollRectToVisible(this.jList1.getCellBounds(idx, idx));
        } else if (oldSel < 0 && this.rModel.getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
    }

    void selectPrev() {
        int oldSel = this.jList1.getSelectedIndex();
        if (oldSel > 0) {
            int idx = oldSel - 1;
            this.jList1.setSelectedIndex(idx);
            this.jList1.scrollRectToVisible(this.jList1.getCellBounds(idx, idx));
        }
    }

    public JList getList() {
        return this.jList1;
    }

    public void clearModel() {
        this.rModel.setContent(null);
    }

    public void cancel() {
        this.cancelTask();
        this.rModel.setContent(null);
    }

    private void cancelTask() {
        if (this.evalTask != null) {
            this.evalTask.removeTaskListener((TaskListener)this);
            this.evalTask.cancel();
            this.updateTimer.stop();
        }
    }

    public void maybeEvaluate(String text) {
        this.searchedText = text;
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(200, this);
        }
        if (!this.updateTimer.isRunning()) {
            this.updateTimer.setDelay(COALESCE_TIMES[Math.min(text.length(), 3)]);
            this.updateTimer.start();
        } else {
            this.updateTimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateTimer.stop();
        if (this.comboBar.isTextFieldFocusOwner()) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    QuickSearchPopup.this.searchLocalIssues();
                }
            });
        }
    }

    void setRepository(Repository repo) {
        this.repository = repo;
    }

    private void runTask(Runnable r) {
        this.cancelTask();
        this.evalTask = this.rp.create(r);
        this.evalTask.addTaskListener((TaskListener)this);
        this.evalTask.schedule(0);
    }

    private void searchLocalIssues() {
        Query[] queries;
        String criteria = this.comboBar.getText();
        if (criteria.equals("")) {
            this.rModel.setContent(null);
            return;
        }
        this.currentHitlist = new ArrayList<PopupItem>();
        HashSet<String> ids = new HashSet<String>();
        this.addIssues(BugtrackingUtil.getByIdOrSummary(BugtrackingUtil.getOpenIssues(), criteria), ids);
        for (Query q : queries = this.repository.getQueries()) {
            Issue[] issues = q.getIssues(criteria);
            this.addIssues(issues, ids);
        }
        this.addIssues(BugtrackingUtil.getByIdOrSummary(ResultsModel.getInstance().getCachedIssues(this.repository), criteria), ids);
        this.populateModel(criteria, false, true);
    }

    private void addIssues(Issue[] issues, Set<String> ids) {
        if (issues == null) {
            return;
        }
        for (Issue issue : issues) {
            if (ids.contains(issue.getID())) continue;
            this.currentHitlist.add(new PopupItem.IssueItem(issue));
            ids.add(issue.getID());
        }
    }

    private void populateModel(final String criteria, boolean fullList, final boolean addSearchItem) {
        ArrayList<PopupItem> modelList = new ArrayList<PopupItem>();
        ArrayList<Issue> recentIssues = new ArrayList<Issue>(BugtrackingUtil.getRecentIssues(this.repository));
        Collections.sort(this.currentHitlist, new IssueComparator(recentIssues));
        for (PopupItem item : this.currentHitlist) {
            modelList.add(item);
            if (modelList.size() <= 4 || fullList) continue;
            modelList.add(new PopupItem(){

                @Override
                void invoke() {
                    QuickSearchPopup.this.populateModel(criteria, true, addSearchItem);
                }

                @Override
                String getDisplayText() {
                    return "...";
                }
            });
            break;
        }
        if (addSearchItem) {
            modelList.add(new SearchItem(criteria));
        }
        this.rModel.setContent(modelList);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.statusPanel = new JPanel();
        this.searchingSep = new JSeparator();
        this.searchingLabel = new JLabel();
        this.noResultsLabel = new JLabel();
        this.hintSep = new JSeparator();
        this.hintLabel = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(QuickSearchComboBar.getPopupBorderColor()));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 150));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jList1.setFocusable(false);
        this.jList1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                QuickSearchPopup.this.jList1MouseMoved(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                QuickSearchPopup.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusPanel.setBackground(QuickSearchComboBar.getResultBackground());
        this.statusPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.searchingSep, gridBagConstraints);
        this.searchingLabel.setText(NbBundle.getMessage(QuickSearchPopup.class, (String)"QuickSearchPopup.searchingLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.statusPanel.add((Component)this.searchingLabel, gridBagConstraints);
        this.noResultsLabel.setForeground(Color.red);
        this.noResultsLabel.setHorizontalAlignment(0);
        this.noResultsLabel.setText(NbBundle.getMessage(QuickSearchPopup.class, (String)"QuickSearchPopup.noResultsLabel.text"));
        this.noResultsLabel.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.noResultsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.hintSep, gridBagConstraints);
        this.hintLabel.setBackground(QuickSearchComboBar.getResultBackground());
        this.hintLabel.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.statusPanel.add((Component)this.hintLabel, gridBagConstraints);
        this.add((Component)this.statusPanel, "Last");
    }

    private void jList1MouseMoved(MouseEvent evt) {
        Point loc = evt.getPoint();
        int index = this.jList1.locationToIndex(loc);
        if (index == -1) {
            return;
        }
        Rectangle rect = this.jList1.getCellBounds(index, index);
        if (rect != null && rect.contains(loc)) {
            this.jList1.setSelectedIndex(index);
        }
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.invoke();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updatePopup();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updatePopup();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updatePopup();
    }

    public void updatePopup() {
        int modelSize = this.rModel.getSize();
        JLayeredPane lPane = JLayeredPane.getLayeredPaneAbove(this.comboBar);
        if (!this.isDisplayable() && lPane != null) {
            lPane.add((Component)this, new Integer(JLayeredPane.POPUP_LAYER + 1));
        }
        boolean statusVisible = this.updateStatusPanel();
        if (lPane != null) {
            this.computePopupBounds(this.popupBounds, lPane, modelSize);
            this.setBounds(this.popupBounds);
        }
        if ((modelSize > 0 || statusVisible) && this.comboBar.isTextFieldFocusOwner()) {
            if (this.jList1.getSelectedIndex() >= modelSize) {
                this.jList1.setSelectedIndex(modelSize - 1);
            }
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        this.revalidate();
    }

    public int getResultWidth() {
        return this.comboBar.getWidth();
    }

    public void taskFinished(Task task) {
        this.evalTask = null;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        this.updatePopup();
    }

    private void computePopupBounds(Rectangle result, JLayeredPane lPane, int modelSize) {
        Point location = new Point(this.comboBar.getIssueComponent().getX(), this.comboBar.getIssueComponent().getY() + this.comboBar.getIssueComponent().getHeight() - 1);
        location = SwingUtilities.convertPoint(this.comboBar, location, lPane);
        result.setLocation(location);
        this.jList1.setFixedCellHeight(15);
        this.jList1.setFixedCellHeight(-1);
        this.jList1.setVisibleRowCount(modelSize);
        Dimension preferredSize = this.jList1.getPreferredSize();
        preferredSize.width = this.comboBar.getIssueComponent().getWidth();
        preferredSize.height += this.statusPanel.getPreferredSize().height + 3;
        if (preferredSize.height > 150) {
            preferredSize.height = 150;
        }
        result.setSize(preferredSize);
    }

    private static int computeWidth(JComponent comp, int maxCharCount, int percent) {
        FontMetrics fm = comp.getFontMetrics(comp.getFont());
        int charW = fm.charWidth('X');
        int result = charW * maxCharCount;
        Window w = SwingUtilities.windowForComponent(comp);
        if (w != null) {
            result = Math.min(result, w.getWidth() * percent / 100);
        }
        return result;
    }

    private boolean updateStatusPanel() {
        boolean shouldBeVisible = false;
        boolean isInProgress = this.evalTask != null;
        this.searchingSep.setVisible(isInProgress && this.rModel.getSize() > 0);
        this.searchingLabel.setVisible(isInProgress);
        shouldBeVisible = shouldBeVisible || isInProgress;
        boolean searchedNotEmpty = this.searchedText != null && this.searchedText.trim().length() > 0;
        boolean areNoResults = this.rModel.getSize() <= 0 && searchedNotEmpty && !isInProgress;
        this.noResultsLabel.setVisible(areNoResults);
        this.comboBar.setNoResults(areNoResults);
        shouldBeVisible = shouldBeVisible || areNoResults;
        Issue issue = this.comboBar.getIssue();
        String issueText = issue != null ? PopupItem.IssueItem.getIssueDescription(issue).trim() : "";
        shouldBeVisible = shouldBeVisible && (issue == null || !issueText.equals(this.comboBar.getText().trim()));
        return shouldBeVisible;
    }

    private class SearchItem
    extends PopupItem {
        private String criteria;

        public SearchItem(String criteria) {
            this.criteria = criteria;
        }

        @Override
        void invoke() {
            QuickSearchPopup.this.runTask(new Runnable(){

                @Override
                public void run() {
                    QuickSearchPopup.this.clearModel();
                    QuickSearchPopup.this.currentHitlist = new ArrayList();
                    HashSet ids = new HashSet();
                    QuickSearchPopup.this.addIssues(BugtrackingUtil.getByIdOrSummary(BugtrackingUtil.getOpenIssues(), SearchItem.this.criteria), ids);
                    Issue[] issues = QuickSearchPopup.this.repository.simpleSearch(SearchItem.this.criteria);
                    QuickSearchPopup.this.addIssues(issues, ids);
                    QuickSearchPopup.this.populateModel(SearchItem.this.criteria, false, QuickSearchPopup.this.currentHitlist.size() > 0);
                    ResultsModel.getInstance().cacheIssues(QuickSearchPopup.this.repository, issues);
                }
            });
        }

        @Override
        String getDisplayText() {
            return NbBundle.getMessage(PopupItem.class, (String)"LBL_SearchCommand");
        }
    }

    private class IssueComparator
    implements Comparator<PopupItem> {
        private final List<Issue> recentIssues;

        public IssueComparator(List<Issue> recentIssues) {
            this.recentIssues = recentIssues;
        }

        @Override
        public int compare(PopupItem i1, PopupItem i2) {
            if (!(i1 instanceof PopupItem.IssueItem)) {
                return -1;
            }
            if (!(i2 instanceof PopupItem.IssueItem)) {
                return 1;
            }
            PopupItem.IssueItem ii1 = (PopupItem.IssueItem)i1;
            PopupItem.IssueItem ii2 = (PopupItem.IssueItem)i2;
            int idx1 = this.getRecentIssueIdx(ii1.getIssue());
            int idx2 = this.getRecentIssueIdx(ii2.getIssue());
            if (idx1 > -1 && idx2 > -1) {
                return idx1 > idx2 ? 1 : (idx2 > idx1 ? -1 : 0);
            }
            if (idx1 > -1) {
                return -1;
            }
            if (idx2 > -1) {
                return 1;
            }
            return ii1.getIssue().getID().compareTo(ii2.getIssue().getID());
        }

        private int getRecentIssueIdx(Issue issue) {
            for (int i = 0; i < this.recentIssues.size(); ++i) {
                Issue recentIssue = this.recentIssues.get(i);
                if (!recentIssue.getID().equals(issue.getID())) continue;
                return i;
            }
            return -1;
        }
    }
}

