/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.ToStringPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ToStringGenerator
implements CodeGenerator {
    private JTextComponent component;
    private ElementNode.Description description;

    private ToStringGenerator(JTextComponent jTextComponent, ElementNode.Description description) {
        this.component = jTextComponent;
        this.description = description;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ToStringGenerator.class, (String)"LBL_tostring");
    }

    public void invoke() {
        final int n = this.component.getCaretPosition();
        final ToStringPanel toStringPanel = new ToStringPanel(this.description);
        DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(toStringPanel, NbBundle.getMessage(ToStringGenerator.class, (String)"LBL_generate_tostring"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != dialogDescriptor.getDefaultValue()) {
            return;
        }
        JavaSource javaSource = JavaSource.forDocument((Document)this.component.getDocument());
        if (javaSource != null) {
            try {
                ModificationResult modificationResult = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                        treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath);
                        if (treePath == null) {
                            return;
                        }
                        ClassTree classTree = (ClassTree)treePath.getLeaf();
                        int n2 = GeneratorUtils.findClassMemberIndex(workingCopy, classTree, n);
                        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
                        for (ElementHandle<? extends Element> elementHandle : toStringPanel.getVariables()) {
                            VariableElement variableElement = (VariableElement)elementHandle.resolve((CompilationInfo)workingCopy);
                            if (variableElement == null) {
                                return;
                            }
                            arrayList.add(variableElement);
                        }
                        MethodTree methodTree = ToStringGenerator.createToStringMethod(workingCopy, arrayList, classTree.getSimpleName().toString());
                        classTree = n2 >= 0 ? workingCopy.getTreeMaker().insertClassMember(classTree, n2, (Tree)methodTree) : workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                        workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
                    }
                });
                GeneratorUtils.guardedCommit(this.component, modificationResult);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static MethodTree createToStringMethod(WorkingCopy workingCopy, Iterable<? extends VariableElement> iterable, String string) {
        Object object2;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        LinkedList<AnnotationTree> linkedList = new LinkedList<AnnotationTree>();
        if (GeneratorUtils.supportsOverride((CompilationInfo)workingCopy) && (object2 = workingCopy.getElements().getTypeElement("java.lang.Override")) != null) {
            linkedList.add(workingCopy.getTreeMaker().Annotation((Tree)workingCopy.getTreeMaker().QualIdent((Element)object2), Collections.emptyList()));
        }
        object2 = treeMaker.Modifiers(enumSet, linkedList);
        ExpressionTree expressionTree = treeMaker.Literal((Object)(string + '{'));
        for (VariableElement object3 : iterable) {
            expressionTree = treeMaker.Binary(Tree.Kind.PLUS, expressionTree, (ExpressionTree)treeMaker.Literal((Object)(object3.getSimpleName().toString() + '=')));
            expressionTree = treeMaker.Binary(Tree.Kind.PLUS, expressionTree, (ExpressionTree)treeMaker.Identifier((CharSequence)object3.getSimpleName()));
        }
        ReturnTree returnTree = treeMaker.Return((ExpressionTree)treeMaker.Binary(Tree.Kind.PLUS, expressionTree, (ExpressionTree)treeMaker.Literal((Object)Character.valueOf('}'))));
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(returnTree), false);
        return treeMaker.Method((ModifiersTree)object2, (CharSequence)"toString", (Tree)treeMaker.Identifier((CharSequence)"String"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), blockTree, null);
    }

    public static class Factory
    implements CodeGenerator.Factory {
        private static final String ERROR = "<error>";

        public List<? extends CodeGenerator> create(Lookup lookup) {
            ArrayList<ToStringGenerator> arrayList = new ArrayList<ToStringGenerator>();
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            CompilationController compilationController = (CompilationController)lookup.lookup(CompilationController.class);
            TreePath treePath = (TreePath)lookup.lookup(TreePath.class);
            TreePath treePath2 = treePath = treePath != null ? Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath) : null;
            if (jTextComponent == null || compilationController == null || treePath == null) {
                return arrayList;
            }
            try {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException iOException) {
                return arrayList;
            }
            TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(treePath);
            if (typeElement == null || !typeElement.getKind().isClass()) {
                return arrayList;
            }
            ArrayList<ElementNode.Description> arrayList2 = new ArrayList<ElementNode.Description>();
            for (Element element : typeElement.getEnclosedElements()) {
                switch (element.getKind()) {
                    case METHOD: {
                        if (!element.getSimpleName().contentEquals("toString") || !((ExecutableElement)element).getParameters().isEmpty()) break;
                        return arrayList;
                    }
                    case FIELD: {
                        if (ERROR.contentEquals(element.getSimpleName()) || element.getModifiers().contains((Object)Modifier.STATIC)) break;
                        arrayList2.add(ElementNode.Description.create(element, null, true, true));
                    }
                }
            }
            arrayList.add(new ToStringGenerator(jTextComponent, ElementNode.Description.create(typeElement, arrayList2, false, false)));
            return arrayList;
        }
    }
}

