/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.BinaryMessageEvent;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileToRemoveEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchNodeChildren;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.Kit;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ModuleSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.NodeOperation2;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public final class BranchSelector
implements Runnable {
    private CVSRoot root;
    private String module;
    private File file;
    private Node rootNode;
    private BranchNodeChildren rootKids;

    public String selectTag(File file) {
        this.file = file;
        return this.showSelector();
    }

    public String selectTag(CVSRoot root, String module) {
        this.root = root;
        this.module = module;
        return this.showSelector();
    }

    private String showSelector() {
        this.rootKids = new BranchNodeChildren();
        this.rootNode = new AbstractNode((Children)this.rootKids);
        CvsVersioningSystem.getInstance().getParallelRequestProcessor().post((Runnable)this);
        try {
            NodeOperation2 op = new NodeOperation2();
            op.setIconsVisible(false);
            op.setRootVisible(false);
            op.setHelpCtx(new HelpCtx(BranchSelector.class));
            Node[] selected = op.select(NbBundle.getMessage(BranchSelector.class, (String)"BK2012"), NbBundle.getMessage(BranchSelector.class, (String)"BK2013"), NbBundle.getMessage(BranchSelector.class, (String)"ACSD_BranchSelect"), this.rootNode, NbBundle.getMessage(BranchSelector.class, (String)"ACSN_BranchesTree"), NbBundle.getMessage(BranchSelector.class, (String)"ACSD_BranchesTree"), new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodes) {
                    if (nodes.length != 1) {
                        return false;
                    }
                    return nodes[0].getLookup().lookup(String.class) != null;
                }
            });
            Node node = selected[0];
            String branch = (String)node.getLookup().lookup(String.class);
            return branch;
        }
        catch (UserCancelException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] getLoggableFiles(String moduleName) throws CommandException, AuthenticationException {
        File checkoutFolder;
        GlobalOptions gtx = CvsVersioningSystem.createGlobalOptions();
        if (this.root != null) {
            gtx.setCVSRoot(this.root.toString());
        }
        if ((checkoutFolder = Kit.createTmpFolder()) == null) {
            this.error(NbBundle.getMessage(BranchSelector.class, (String)"BK2015"));
            return new File[0];
        }
        CheckoutCommand checkout = new CheckoutCommand();
        checkout.setRecursive(false);
        if (".".equals(moduleName)) {
            int max;
            List<String> l = this.listRepositoryPath(this.root, "");
            int counter = max = l.size();
            Random random = new Random();
            while (counter-- > 0) {
                int rnd = random.nextInt(max);
                String path = l.get(rnd);
                if ("CVSROOT".equals(path)) continue;
                moduleName = path;
                break;
            }
        }
        checkout.setModule(moduleName);
        File[] checkoutFiles = new File[]{checkoutFolder};
        checkout.setFiles(checkoutFiles);
        Client client = Kit.createClient(this.root);
        client.setLocalPath(checkoutFolder.getAbsolutePath());
        try {
            client.executeCommand((Command)checkout, gtx);
        }
        finally {
            try {
                client.getConnection().close();
            }
            catch (Throwable e) {
                Logger.getLogger(BranchSelector.class.getName()).log(Level.INFO, null, e);
            }
        }
        File folderToCheck = new File(checkoutFolder, moduleName);
        if (!folderToCheck.isDirectory()) {
            folderToCheck = checkoutFolder;
        }
        ArrayList<File> filesToLog = new ArrayList<File>();
        for (File child : folderToCheck.listFiles()) {
            if ("CVSROOT".equals(child.getName()) || "CVS".equals(child.getName())) continue;
            filesToLog.add(child);
        }
        if (filesToLog.size() > 0) {
            return filesToLog.toArray(new File[filesToLog.size()]);
        }
        List<String> fileList = this.listRepositoryPath(this.root, moduleName);
        for (String child : fileList) {
            String childModule = moduleName + "/" + child;
            File[] childLoggable = this.getLoggableFiles(childModule);
            if (childLoggable.length <= 0) continue;
            return childLoggable;
        }
        return new File[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ErrorManager err;
        GlobalOptions gtx = CvsVersioningSystem.createGlobalOptions();
        if (this.root != null) {
            gtx.setCVSRoot(this.root.toString());
        }
        File checkoutFolder = null;
        Client client = null;
        try {
            File localPath;
            File[] files;
            if (this.file == null) {
                files = this.getLoggableFiles(this.module);
                localPath = files.length > 0 ? files[0].getParentFile() : null;
            } else if (this.file.isDirectory()) {
                files = this.file.listFiles();
                localPath = this.file;
            } else {
                files = new File[]{this.file};
                localPath = this.file.getParentFile();
            }
            ArrayList logFiles = new ArrayList(files.length);
            this.fillLogFiles(files, logFiles);
            if (logFiles.isEmpty()) {
                this.tagsLoaded(Collections.EMPTY_SET, Collections.EMPTY_SET);
                return;
            }
            LogCommand log = new LogCommand();
            log.setHeaderOnly(true);
            File[] cmdFiles = logFiles.toArray(new File[logFiles.size()]);
            log.setFiles(cmdFiles);
            if (this.root == null) {
                for (int i = 0; i < cmdFiles.length; ++i) {
                    try {
                        this.root = CVSRoot.parse((String)Utils.getCVSRootFor(cmdFiles[i]));
                        break;
                    }
                    catch (IOException e) {
                        ErrorManager err2 = ErrorManager.getDefault();
                        err2.annotate((Throwable)e, "Can not find CVSROOT for " + cmdFiles[i]);
                        err2.notify(1, (Throwable)e);
                        continue;
                    }
                }
            }
            client = Kit.createClient(this.root);
            final TreeSet tags = new TreeSet();
            final TreeSet branches = new TreeSet();
            EventManager mgr = client.getEventManager();
            mgr.addCVSListener(new CVSListener(){

                public void messageSent(MessageEvent e) {
                }

                public void messageSent(BinaryMessageEvent e) {
                }

                public void fileAdded(FileAddedEvent e) {
                }

                public void fileToRemove(FileToRemoveEvent e) {
                }

                public void fileRemoved(FileRemovedEvent e) {
                }

                public void fileUpdated(FileUpdatedEvent e) {
                }

                public void fileInfoGenerated(FileInfoEvent e) {
                    LogInformation info = (LogInformation)e.getInfoContainer();
                    List symNames = info.getAllSymbolicNames();
                    for (LogInformation.SymName name : symNames) {
                        if (name.isBranch()) {
                            branches.add(name.getName());
                            continue;
                        }
                        tags.add(name.getName());
                    }
                }

                public void commandTerminated(TerminationEvent e) {
                }

                public void moduleExpanded(ModuleExpansionEvent e) {
                }
            });
            client.setLocalPath(localPath.getAbsolutePath());
            client.executeCommand((Command)log, gtx);
            this.tagsLoaded(branches, tags);
            Kit.deleteRecursively(checkoutFolder);
        }
        catch (CommandException e) {
            this.error(NbBundle.getMessage(BranchSelector.class, (String)"BK2016"));
            err = ErrorManager.getDefault();
            err.annotate((Throwable)e, NbBundle.getMessage(BranchSelector.class, (String)"BK2016"));
            err.notify((Throwable)e);
        }
        catch (AuthenticationException e) {
            this.error(NbBundle.getMessage(BranchSelector.class, (String)"BK2016"));
            err = ErrorManager.getDefault();
            err.annotate((Throwable)e, NbBundle.getMessage(BranchSelector.class, (String)"BK2016"));
            err.notify((Throwable)e);
        }
        finally {
            try {
                if (client != null) {
                    client.getConnection().close();
                }
            }
            catch (Throwable e) {
                Logger.getLogger(BranchSelector.class.getName()).log(Level.INFO, null, e);
            }
            Kit.deleteRecursively(checkoutFolder);
        }
    }

    private void fillLogFiles(File[] files, List logFiles) {
        int i;
        if (files == null) {
            return;
        }
        if (!logFiles.isEmpty()) {
            return;
        }
        for (i = 0; i < files.length; ++i) {
            FileInformation info;
            if (!files[i].isFile() || ((info = CvsVersioningSystem.getInstance().getStatusCache().getStatus(files[i])).getStatus() & 0xFF8) == 0) continue;
            logFiles.add(files[i]);
        }
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            this.fillLogFiles(files[i].listFiles(), logFiles);
        }
    }

    private void tagsLoaded(Collection branches, Collection tags) {
        this.rootKids.setBranches(branches);
        this.rootKids.setTags(tags);
    }

    private void error(String msg) {
        this.rootNode.setDisplayName(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listRepositoryPath(CVSRoot root, String path) throws CommandException, AuthenticationException {
        Client client = Kit.createClient(root);
        try {
            List<String> list = ModuleSelector.listRepositoryPath(client, root, path);
            return list;
        }
        finally {
            try {
                client.getConnection().close();
            }
            catch (Throwable e) {
                Logger.getLogger(BranchSelector.class.getName()).log(Level.INFO, null, e);
            }
        }
    }
}

