/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.history.ViewRevisionPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ViewRevisionAction
extends AbstractAction
implements Runnable {
    private final VCSContext ctx;
    private ViewRevisionPanel settings;

    public ViewRevisionAction(VCSContext ctx) {
        this(Utils.getActionName(ViewRevisionAction.class, (String)"CTL_MenuItem_ViewRevision", (VCSContext)ctx), ctx);
    }

    public ViewRevisionAction(String name, VCSContext ctx) {
        super(name);
        this.ctx = ctx;
    }

    @Override
    public boolean isEnabled() {
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        for (File file : this.ctx.getRootFiles()) {
            if (file.isDirectory() || (cache.getStatus(file).getStatus() & 0xFF8) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String title = NbBundle.getMessage(ViewRevisionAction.class, (String)"CTL_ViewRevisionDialog_Title", (Object)Utils.getContextDisplayName((VCSContext)this.ctx));
        this.settings = new ViewRevisionPanel(this.ctx);
        JButton view = new JButton(NbBundle.getMessage(ViewRevisionAction.class, (String)"CTL_ViewRevisionDialog_Action_View"));
        this.settings.putClientProperty("OKButton", view);
        this.settings.refreshComponents();
        view.setToolTipText(NbBundle.getMessage(ViewRevisionAction.class, (String)"TT_ViewRevisionDialog_Action_View"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)this.settings, title, true, new Object[]{view, DialogDescriptor.CANCEL_OPTION}, (Object)view, 0, new HelpCtx(ViewRevisionAction.class), null);
        descriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ViewRevisionAction.class, (String)"ACSD_ViewRevisionDialog"));
        dialog.setVisible(true);
        if (descriptor.getValue() != view) {
            return;
        }
        this.settings.saveSettings();
        Utils.createTask((Runnable)this).schedule(0);
    }

    @Override
    public void run() {
        String revision = this.settings.getRevision();
        File tempFolder = Utils.getTempFolder();
        for (File file : this.ctx.getRootFiles()) {
            if (file.isDirectory()) continue;
            try {
                ViewRevisionAction.view(file, revision, tempFolder);
            }
            catch (Exception e) {}
        }
    }

    public static void view(File base, final String revision, File tempFolder) throws Exception {
        if (tempFolder == null) {
            tempFolder = Utils.getTempFolder();
        }
        File original = VersionsCache.getInstance().getRemoteFile(base, revision, null);
        File daoFile = new File(tempFolder, base.getName());
        daoFile.deleteOnExit();
        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(daoFile), (InputStream)new FileInputStream(original));
        Utils.associateEncoding((File)base, (File)daoFile);
        final FileObject fo = FileUtil.toFileObject((File)daoFile);
        DataObject dobj = DataObject.find((FileObject)fo);
        final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        final OpenCookie oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ec != null) {
                    Utils.openFile((FileObject)fo, (String)revision);
                } else if (oc != null) {
                    oc.open();
                } else {
                    Utils.openFile((FileObject)fo, (String)revision);
                }
            }
        });
    }
}

