/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmModelStateListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.classview.ClassViewTopComponent;
import org.openide.util.NbPreferences;

public class ClassViewInstaller
implements CsmModelStateListener {
    public void modelStateChanged(CsmModelState newState, CsmModelState oldState) {
        switch (newState) {
            case ON: {
                ProjectListener.getInstance().startup();
                break;
            }
            case CLOSING: {
                ProjectListener.getInstance().shutdown();
            }
        }
    }

    private static class ProjectListener
    implements CsmModelListener {
        private static ProjectListener instance;

        private ProjectListener() {
        }

        private static ProjectListener getInstance() {
            if (instance == null) {
                instance = new ProjectListener();
            }
            return instance;
        }

        private void shutdown() {
            CsmListeners.getDefault().removeModelListener((CsmModelListener)this);
        }

        private void startup() {
            CsmListeners.getDefault().addModelListener((CsmModelListener)this);
        }

        private boolean isDefaultBehavior() {
            Preferences ps = NbPreferences.forModule(ClassViewTopComponent.class);
            return !ps.getBoolean("ClassViewWasOpened", false);
        }

        public void projectOpened(CsmProject project) {
            if (this.isDefaultBehavior()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClassViewTopComponent tc = ClassViewTopComponent.findDefault();
                        if (!tc.isOpened()) {
                            tc.open();
                        }
                    }
                });
            }
        }

        public void projectClosed(CsmProject project) {
            if (this.isDefaultBehavior() && CsmModelAccessor.getModel().projects().isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClassViewTopComponent tc = ClassViewTopComponent.findDefault();
                        if (tc.isOpened()) {
                            tc.closeImplicit();
                        }
                    }
                });
            }
        }

        public void modelChanged(CsmChangeEvent e) {
        }
    }
}

