/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public class SubprojectProviderImpl
implements SubprojectProvider {
    private final NbMavenProjectImpl project;
    private final NbMavenProject watcher;
    private List<ChangeListener> listeners;
    private ChangeListener listener2;
    private PropertyChangeListener propertyChange;

    public SubprojectProviderImpl(NbMavenProjectImpl proj, NbMavenProject watcher) {
        this.project = proj;
        this.watcher = watcher;
        this.listeners = new ArrayList<ChangeListener>();
        this.propertyChange = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    SubprojectProviderImpl.this.fireChange();
                }
            }
        };
        this.listener2 = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SubprojectProviderImpl.this.fireChange();
            }
        };
        MavenFileOwnerQueryImpl.getInstance().addChangeListener(WeakListeners.change((ChangeListener)this.listener2, (Object)MavenFileOwnerQueryImpl.getInstance()));
    }

    public Set<? extends Project> getSubprojects() {
        HashSet<Project> projects = new HashSet<Project>();
        File basedir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        try {
            this.addProjectModules(basedir, projects, this.project.getOriginalMavenProject().getModules());
        }
        catch (InterruptedException x) {
            return Collections.emptySet();
        }
        this.addOpenedCandidates(projects);
        projects.remove(this.project);
        return projects;
    }

    private void addOpenedCandidates(Set<Project> resultset) {
        Set<Project> opened = MavenFileOwnerQueryImpl.getInstance().getOpenedProjects();
        List compileArtifacts = this.project.getOriginalMavenProject().getCompileArtifacts();
        ArrayList<String> artPaths = new ArrayList<String>();
        for (Artifact ar : compileArtifacts) {
            artPaths.add(this.project.getArtifactRelativeRepositoryPath(ar));
        }
        for (Project prj : opened) {
            String prjpath = ((NbMavenProjectImpl)prj).getArtifactRelativeRepositoryPath();
            if (!artPaths.contains(prjpath)) continue;
            resultset.add(prj);
        }
    }

    private boolean isProcessed(Set<Project> resultset, FileObject projectDir) {
        for (Project p : resultset) {
            if (!p.getProjectDirectory().equals(projectDir)) continue;
            return true;
        }
        return false;
    }

    private void addProjectModules(File basedir, Set<Project> resultset, List modules) throws InterruptedException {
        if (modules == null || modules.size() == 0) {
            return;
        }
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            String path = (String)it.next();
            if (path.trim().length() == 0) continue;
            File sub = new File(basedir, path);
            File projectFile = FileUtil.normalizeFile((File)sub);
            if (!projectFile.equals(basedir) && projectFile.exists()) {
                FileObject projectDir = FileUtil.toFileObject((File)projectFile);
                if (projectDir != null && !this.isProcessed(resultset, projectDir)) {
                    Project proj = this.processOneSubproject(projectDir);
                    NbMavenProjectImpl mv = proj != null ? (NbMavenProjectImpl)proj.getLookup().lookup(NbMavenProjectImpl.class) : null;
                    if (mv == null) continue;
                    if (!"pom".equalsIgnoreCase(mv.getProjectWatcher().getPackagingType())) {
                        resultset.add(proj);
                    }
                    this.addProjectModules(FileUtil.toFile((FileObject)mv.getProjectDirectory()), resultset, mv.getOriginalMavenProject().getModules());
                    continue;
                }
                ErrorManager.getDefault().log("fileobject not found=" + sub);
                continue;
            }
            ErrorManager.getDefault().log("project file not found=" + sub);
        }
    }

    private Project processOneSubproject(FileObject projectDir) {
        try {
            return ProjectManager.getDefault().findProject(projectDir);
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
            return null;
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners.size() == 0) {
            this.watcher.addPropertyChangeListener(this.propertyChange);
        }
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
        if (this.listeners.size() == 0) {
            this.watcher.removePropertyChangeListener(this.propertyChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> lists = new ArrayList<ChangeListener>();
        SubprojectProviderImpl subprojectProviderImpl = this;
        synchronized (subprojectProviderImpl) {
            lists.addAll(this.listeners);
        }
        for (ChangeListener listener : lists) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }
}

