/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.MavenExecutor;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.execute.ui.RunGoalsPanel;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.nodes.MavenProjectNode;
import org.netbeans.modules.maven.operations.Operations;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.problems.ProblemsPanel;
import org.netbeans.modules.maven.spi.actions.ActionConvertor;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ActionProviderImpl
implements ActionProvider {
    private final NbMavenProjectImpl project;
    private static String[] supported = new String[]{"build", "build-with-dependencies", "clean", "rebuild", "javadoc", "test", "test.single", "run", "run.single", "debug", "debug.single", "debug.test.single", "debug.fix", "delete", "rename", "move", "copy"};
    Lookup.Result<? extends MavenActionsProvider> result;

    public ActionProviderImpl(NbMavenProjectImpl proj) {
        this.project = proj;
        this.result = Lookup.getDefault().lookupResult(MavenActionsProvider.class);
    }

    public String[] getSupportedActions() {
        HashSet<String> supp = new HashSet<String>();
        supp.addAll(Arrays.asList(supported));
        for (MavenActionsProvider add : this.result.allInstances()) {
            Set<String> added = add.getSupportedDefaultActions();
            if (added == null) continue;
            supp.addAll(added);
        }
        if (RunUtils.hasTestCompileOnSaveEnabled(this.project)) {
            supp.add("run.single.method");
            supp.add("debug.single.method");
        }
        return supp.toArray(new String[0]);
    }

    public void invokeAction(final String action, final Lookup lookup) {
        ActionConvertor convertor;
        if ("delete".equals(action)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(action)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(action)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(action)) {
            Operations.renameProject(this.project);
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ActionProviderImpl.this.invokeAction(action, lookup);
                }
            });
            return;
        }
        Collection convertors = this.project.getLookup().lookupAll(ActionConvertor.class);
        String convertedAction = null;
        Iterator i$ = convertors.iterator();
        while (i$.hasNext() && (convertedAction = (convertor = (ActionConvertor)i$.next()).convert(action, lookup)) == null) {
        }
        if (convertedAction == null) {
            convertedAction = action;
        }
        Collection replacers = this.project.getLookup().lookupAll(ReplaceTokenProvider.class);
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (ReplaceTokenProvider prov : replacers) {
            replacements.putAll(prov.createReplacements(convertedAction, lookup));
        }
        ProxyLookup enhanced = new ProxyLookup(new Lookup[]{lookup, Lookups.fixed((Object[])new Object[]{replacements})});
        RunConfig rc = ActionToGoalUtils.createRunConfig(convertedAction, this.project, (Lookup)enhanced);
        if (rc == null) {
            Logger.getLogger(ActionProviderImpl.class.getName()).log(Level.INFO, "No handling for action: {0}. Ignoring.", action);
        } else {
            RunConfig rc2;
            BeanRunConfig brc;
            if (rc instanceof BeanRunConfig && (brc = (BeanRunConfig)rc).getPreExecutionActionName() != null && (rc2 = ActionToGoalUtils.createRunConfig(brc.getPreExecutionActionName(), this.project, (Lookup)enhanced)) != null) {
                brc.setPreExecution(rc2);
            }
            this.setupTaskName(action, rc, lookup);
            this.runGoal(rc, true);
        }
    }

    private void runGoal(RunConfig config, boolean checkShowDialog) {
        LifecycleManager.getDefault().saveAll();
        Lookup.Result res = config.getProject().getLookup().lookup(new Lookup.Template(PrerequisitesChecker.class));
        for (PrerequisitesChecker elem : res.allInstances()) {
            if (!elem.checkRunConfig(config)) {
                return;
            }
            if (config.getPreExecution() == null || elem.checkRunConfig(config.getPreExecution())) continue;
            return;
        }
        if (checkShowDialog && MavenSettings.getDefault().isShowRunDialog()) {
            RunGoalsPanel pnl = new RunGoalsPanel();
            DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(MavenExecutor.class, (String)"TIT_Run_maven"));
            pnl.readConfig(config);
            Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (retValue == DialogDescriptor.OK_OPTION) {
                BeanRunConfig newConfig = new BeanRunConfig();
                newConfig.setExecutionDirectory(config.getExecutionDirectory());
                newConfig.setExecutionName(config.getExecutionName());
                newConfig.setTaskDisplayName(config.getTaskDisplayName());
                newConfig.setProject(config.getProject());
                pnl.applyValues(newConfig);
                config = newConfig;
            } else {
                return;
            }
        }
        ExecutorTask task = RunUtils.executeMaven(config);
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task2) {
                RepositoryInfo info = RepositoryPreferences.getInstance().getRepositoryInfoById("local");
                if (info != null) {
                    Set depArts;
                    ArrayList<Artifact> arts = new ArrayList<Artifact>();
                    Artifact prjArt = ActionProviderImpl.this.project.getOriginalMavenProject().getArtifact();
                    if (prjArt != null) {
                        arts.add(prjArt);
                    }
                    if ((depArts = ActionProviderImpl.this.project.getOriginalMavenProject().getDependencyArtifacts()) != null) {
                        arts.addAll(depArts);
                    }
                    RepositoryIndexer.updateIndexWithArtifacts((RepositoryInfo)info, arts);
                }
            }
        });
    }

    private void setupTaskName(String action, RunConfig config, Lookup lkp) {
        String dobjName;
        assert (config instanceof BeanRunConfig);
        BeanRunConfig bc = (BeanRunConfig)config;
        DataObject dobj = (DataObject)lkp.lookup(DataObject.class);
        NbMavenProject prj = (NbMavenProject)bc.getProject().getLookup().lookup(NbMavenProject.class);
        String string = dobjName = dobj != null ? dobj.getName() : "";
        String title = "run".equals(action) ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Run", (Object)prj.getMavenProject().getArtifactId()) : ("debug".equals(action) ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Debug", (Object)prj.getMavenProject().getArtifactId()) : ("test".equals(action) ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Test", (Object)prj.getMavenProject().getArtifactId()) : (action.startsWith("run.single") ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Run", (Object)dobjName) : (action.startsWith("debug.single") || "debug.test.single".equals(action) ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Debug", (Object)dobjName) : ("test.single".equals(action) ? NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Test", (Object)dobjName) : NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Build", (Object)prj.getMavenProject().getArtifactId()))))));
        bc.setTaskDisplayName(title);
    }

    public boolean isActionEnabled(String action, Lookup lookup) {
        ActionConvertor convertor;
        if ("delete".equals(action) || "rename".equals(action) || "copy".equals(action) || "move".equals(action)) {
            return true;
        }
        Collection convertors = this.project.getLookup().lookupAll(ActionConvertor.class);
        String convertedAction = null;
        Iterator i$ = convertors.iterator();
        while (i$.hasNext() && (convertedAction = (convertor = (ActionConvertor)i$.next()).convert(action, lookup)) == null) {
        }
        if (convertedAction == null) {
            convertedAction = action;
        }
        return ActionToGoalUtils.isActionEnable(convertedAction, this.project, lookup);
    }

    public Action createCustomMavenAction(String name, NetbeansActionMapping mapping, boolean showUI) {
        return new CustomAction(name, mapping, showUI);
    }

    public static Action customPopupActions() {
        return new ConditionallyShownAction(){

            @Override
            protected Action forProject(Project p) {
                CustomPopupActions customPopupActions;
                ActionProviderImpl ap = (ActionProviderImpl)p.getLookup().lookup(ActionProviderImpl.class);
                if (ap != null) {
                    ActionProviderImpl actionProviderImpl = ap;
                    actionProviderImpl.getClass();
                    customPopupActions = actionProviderImpl.new CustomPopupActions();
                } else {
                    customPopupActions = null;
                }
                return customPopupActions;
            }
        };
    }

    public static Action closeSubprojectsAction() {
        return new ConditionallyShownAction(){

            @Override
            protected Action forProject(Project p) {
                NbMavenProjectImpl project = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class);
                if (project != null && "pom".equalsIgnoreCase(project.getProjectWatcher().getPackagingType())) {
                    return new CloseSubprojectsAction(project);
                }
                return null;
            }
        };
    }

    public static Action showProblemsAction() {
        return new ConditionallyShownAction(){

            @Override
            protected Action forProject(Project p) {
                ProblemReporterImpl reporter = (ProblemReporterImpl)p.getLookup().lookup(ProblemReporterImpl.class);
                return reporter != null && reporter.getReports().size() > 0 ? new ShowProblemsAction(reporter) : null;
            }
        };
    }

    public static Action buildWithDependenciesAction() {
        return ProjectSensitiveActions.projectCommandAction((String)"build-with-dependencies", (String)NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_Build_Deps"), null);
    }

    private static class ShowProblemsAction
    extends AbstractAction {
        private final ProblemReporterImpl reporter;

        public ShowProblemsAction(ProblemReporterImpl reporter) {
            this.reporter = reporter;
            this.putValue("Name", NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_ShowProblems"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JButton butt = new JButton();
            ProblemsPanel panel = new ProblemsPanel(this.reporter);
            panel.setActionButton(butt);
            JButton close = new JButton();
            panel.setCloseButton(close);
            close.setText(NbBundle.getMessage(MavenProjectNode.class, (String)"BTN_Close"));
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(MavenProjectNode.class, (String)"TIT_Show_Problems"));
            dd.setOptions(new Object[]{butt, close});
            dd.setClosingOptions(new Object[]{close});
            dd.setModal(false);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        }
    }

    private static class CloseSubprojectsAction
    extends AbstractAction {
        private final NbMavenProjectImpl project;

        public CloseSubprojectsAction(NbMavenProjectImpl project) {
            this.project = project;
            this.putValue("Name", NbBundle.getMessage(MavenProjectNode.class, (String)"ACT_CloseRequired"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SubprojectProvider subs = (SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class);
            Set lst = subs.getSubprojects();
            Project[] arr = lst.toArray(new Project[lst.size()]);
            OpenProjects.getDefault().close(arr);
        }
    }

    private final class CustomPopupActions
    extends AbstractAction
    implements Presenter.Popup {
        private CustomPopupActions() {
            this.putValue("Name", NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Custom_Run"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            final JMenu menu = new JMenu(NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Custom_Run"));
            final JMenuItem loading = new JMenuItem(NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Loading", (Object[])new Object[0]));
            menu.add(loading);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    NetbeansActionMapping[] maps = ActionToGoalUtils.getActiveCustomMappings(ActionProviderImpl.this.project);
                    for (int i = 0; i < maps.length; ++i) {
                        NetbeansActionMapping mapp = maps[i];
                        Action act = ActionProviderImpl.this.createCustomMavenAction(mapp.getActionName(), mapp, false);
                        JMenuItem item = new JMenuItem(act);
                        item.setText(mapp.getDisplayName() == null ? mapp.getActionName() : mapp.getDisplayName());
                        menu.add(item);
                    }
                    menu.add(new JMenuItem(ActionProviderImpl.this.createCustomMavenAction(NbBundle.getMessage(ActionProviderImpl.class, (String)"LBL_Custom_run_goals"), new NetbeansActionMapping(), true)));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean selected = menu.isSelected();
                            menu.remove(loading);
                            menu.getPopupMenu().pack();
                            menu.repaint();
                            menu.updateUI();
                            menu.setSelected(selected);
                        }
                    });
                }
            }, 100);
            return menu;
        }
    }

    private static abstract class ConditionallyShownAction
    extends AbstractAction
    implements ContextAwareAction {
        protected ConditionallyShownAction() {
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            assert (false);
        }

        protected abstract Action forProject(Project var1);

        public final Action createContextAwareInstance(Lookup actionContext) {
            Collection projects = actionContext.lookupAll(Project.class);
            if (projects.size() != 1) {
                return this;
            }
            Action a = this.forProject((Project)projects.iterator().next());
            return a != null ? a : this;
        }
    }

    private final class CustomAction
    extends AbstractAction {
        private NetbeansActionMapping mapping;
        private boolean showUI;

        private CustomAction(String name, NetbeansActionMapping mapp, boolean showUI) {
            this.mapping = mapp;
            this.putValue("Name", name);
            this.showUI = showUI;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.showUI) {
                ModelRunConfig rc = new ModelRunConfig(ActionProviderImpl.this.project, this.mapping, this.mapping.getActionName(), null);
                rc.setShowDebug(MavenSettings.getDefault().isShowDebug());
                rc.setTaskDisplayName(NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Build"));
                ActionProviderImpl.this.setupTaskName("custom", rc, Lookup.EMPTY);
                ActionProviderImpl.this.runGoal(rc, true);
                return;
            }
            RunGoalsPanel pnl = new RunGoalsPanel();
            DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(ActionProviderImpl.class, (String)"TIT_Run_Maven"));
            ActionToGoalMapping maps = ActionToGoalUtils.readMappingsFromFileAttributes(ActionProviderImpl.this.project.getProjectDirectory());
            pnl.readMapping(this.mapping, ActionProviderImpl.this.project, maps);
            pnl.setShowDebug(MavenSettings.getDefault().isShowDebug());
            pnl.setOffline(MavenSettings.getDefault().isOffline() != null ? MavenSettings.getDefault().isOffline() : false);
            pnl.setRecursive(true);
            Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (retValue == DialogDescriptor.OK_OPTION) {
                pnl.applyValues(this.mapping);
                if (maps.getActions().size() > 10) {
                    maps.getActions().remove(0);
                }
                maps.getActions().add(this.mapping);
                ActionToGoalUtils.writeMappingsToFileAttributes(ActionProviderImpl.this.project.getProjectDirectory(), maps);
                if (pnl.isRememberedAs() != null) {
                    try {
                        M2ConfigProvider conf = (M2ConfigProvider)ActionProviderImpl.this.project.getLookup().lookup(M2ConfigProvider.class);
                        ActionToGoalMapping mappings = new NetbeansBuildActionXpp3Reader().read(new StringReader(conf.getDefaultConfig().getRawMappingsAsString()));
                        String tit = "CUSTOM-" + pnl.isRememberedAs();
                        this.mapping.setActionName(tit);
                        NetbeansActionMapping exist = null;
                        for (NetbeansActionMapping m : mappings.getActions()) {
                            if (!tit.equals(m.getActionName())) continue;
                            exist = m;
                            break;
                        }
                        if (exist != null) {
                            mappings.getActions().set(mappings.getActions().indexOf(exist), this.mapping);
                        } else {
                            mappings.addAction(this.mapping);
                        }
                        this.mapping.setDisplayName(pnl.isRememberedAs());
                        CustomizerProviderImpl.writeNbActionsModel(ActionProviderImpl.this.project, mappings, M2Configuration.getFileNameExt(M2Configuration.DEFAULT));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ModelRunConfig rc = new ModelRunConfig(ActionProviderImpl.this.project, this.mapping, this.mapping.getActionName(), null);
                rc.setOffline(pnl.isOffline());
                rc.setShowDebug(pnl.isShowDebug());
                rc.setRecursive(pnl.isRecursive());
                rc.setUpdateSnapshots(pnl.isUpdateSnapshots());
                rc.setTaskDisplayName(NbBundle.getMessage(ActionProviderImpl.class, (String)"TXT_Build"));
                ActionProviderImpl.this.setupTaskName("custom", rc, Lookup.EMPTY);
                ActionProviderImpl.this.runGoal(rc, false);
            }
        }
    }
}

