/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Get;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.AutoUpdateCatalogParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AutoUpdate
extends Task {
    private List<Modules> modules = new ArrayList<Modules>();
    private FileSet nbmSet;
    private File dir;
    private File cluster;
    private URL catalog;
    private boolean force;

    public void setUpdateCenter(URL u) {
        this.catalog = u;
    }

    public FileSet createNbms() {
        if (this.nbmSet != null) {
            throw new BuildException("Just one nbms set allowed");
        }
        this.nbmSet = new FileSet();
        return this.nbmSet;
    }

    public void setInstallDir(File dir) {
        this.dir = dir;
    }

    public void setToDir(File dir) {
        this.cluster = dir;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public Modules createModules() {
        Modules m = new Modules();
        this.modules.add(m);
        return m;
    }

    public void execute() throws BuildException {
        Map<String, List<String>> installed;
        Map<String, AutoUpdateCatalogParser.ModuleItem> units;
        if (this.dir != null == (this.cluster != null)) {
            throw new BuildException("Specify either todir or installdir");
        }
        if (this.catalog != null) {
            try {
                units = AutoUpdateCatalogParser.getUpdateItems(this.catalog, this.catalog, this);
            }
            catch (IOException ex) {
                throw new BuildException(ex.getMessage(), (Throwable)ex);
            }
        } else {
            if (this.nbmSet == null) {
                throw new BuildException("Specify updatecenter or list of NBMs");
            }
            DirectoryScanner s = this.nbmSet.getDirectoryScanner(this.getProject());
            File basedir = s.getBasedir();
            units = new HashMap<String, AutoUpdateCatalogParser.ModuleItem>();
            for (String incl : s.getIncludedFiles()) {
                File nbm = new File(basedir, incl);
                try {
                    URL u = new URL("jar:" + nbm.toURI() + "!/Info/info.xml");
                    URL url = nbm.toURI().toURL();
                    Map<String, AutoUpdateCatalogParser.ModuleItem> map = AutoUpdateCatalogParser.getUpdateItems(u, url, this);
                    assert (map.size() == 1);
                    Map.Entry<String, AutoUpdateCatalogParser.ModuleItem> entry = map.entrySet().iterator().next();
                    units.put(entry.getKey(), entry.getValue().changeDistribution(url));
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
        }
        if (this.dir != null) {
            File[] arr = this.dir.listFiles();
            if (arr == null) {
                throw new BuildException("installdir must be existing directory: " + this.dir);
            }
            installed = this.findExistingModules(arr);
        } else {
            installed = this.findExistingModules(this.cluster);
        }
        for (AutoUpdateCatalogParser.ModuleItem uu : units.values()) {
            if (!this.matches(uu.getCodeName(), uu.targetcluster)) continue;
            this.log("found module: " + uu, 3);
            List<String> info = installed.get(uu.getCodeName());
            if (info != null && !uu.isNewerThan(info.get(0))) {
                this.log("Version " + info.get(0) + " of " + uu.getCodeName() + " is up to date", 3);
                if (!this.force) continue;
            }
            if (info == null) {
                this.log(uu.getCodeName() + " is not present, downloading version " + uu.getSpecVersion(), 2);
            } else {
                this.log("Version " + info.get(0) + " of " + uu.getCodeName() + " needs update to " + uu.getSpecVersion(), 2);
            }
            byte[] bytes = new byte[4096];
            File tmp = null;
            boolean delete = false;
            File lastM = null;
            try {
                if (uu.getURL().getProtocol().equals("file")) {
                    try {
                        tmp = new File(uu.getURL().toURI());
                    }
                    catch (URISyntaxException ex) {
                        tmp = null;
                    }
                    if (!tmp.exists()) {
                        tmp = null;
                    }
                }
                String dash = uu.getCodeName().replace('.', '-');
                if (tmp == null) {
                    tmp = File.createTempFile(dash, ".nbm");
                    tmp.deleteOnExit();
                    delete = true;
                    Get get = new Get();
                    get.setProject(this.getProject());
                    get.setTaskName("get:" + uu.getCodeName());
                    get.setSrc(uu.getURL());
                    get.setDest(tmp);
                    get.setVerbose(true);
                    get.execute();
                }
                File whereTo = this.dir != null ? new File(this.dir, uu.targetcluster) : this.cluster;
                whereTo.mkdirs();
                lastM = new File(whereTo, ".lastModified");
                lastM.createNewFile();
                if (info != null) {
                    for (int i = 1; i < info.size(); ++i) {
                        File oldFile = new File(whereTo, info.get(i).replace('/', File.separatorChar));
                        oldFile.delete();
                    }
                }
                File tracking = new File(new File(whereTo, "update_tracking"), dash + ".xml");
                this.log("Writing tracking file " + tracking, 3);
                tracking.getParentFile().mkdirs();
                BufferedOutputStream config = new BufferedOutputStream(new FileOutputStream(tracking));
                ((OutputStream)config).write(("<?xml version='1.0' encoding='UTF-8'?>\n<module codename='" + uu.getCodeName() + "'>\n").getBytes("UTF-8"));
                ((OutputStream)config).write(("  <module_version install_time='" + System.currentTimeMillis() + "' last='true' origin='Ant'" + " specification_version='" + uu.getSpecVersion() + "'>\n").getBytes("UTF-8"));
                ZipFile zf = new ZipFile(tmp);
                Enumeration<? extends ZipEntry> en = zf.entries();
                while (en.hasMoreElements()) {
                    int len;
                    ZipEntry zipEntry = en.nextElement();
                    if (!zipEntry.getName().startsWith("netbeans/") || zipEntry.getName().endsWith("/")) continue;
                    String relName = zipEntry.getName().substring(9);
                    File trgt = new File(whereTo, relName.replace('/', File.separatorChar));
                    trgt.getParentFile().mkdirs();
                    this.log("Writing " + trgt, 3);
                    InputStream is = zf.getInputStream(zipEntry);
                    FileOutputStream os = new FileOutputStream(trgt);
                    boolean doUnpack200 = false;
                    if (relName.endsWith(".jar.pack.gz") && zf.getEntry(zipEntry.getName().substring(0, zipEntry.getName().length() - 8)) == null) {
                        doUnpack200 = true;
                    }
                    CRC32 crc = new CRC32();
                    while ((len = is.read(bytes)) != -1) {
                        if (!doUnpack200) {
                            crc.update(bytes, 0, len);
                        }
                        ((OutputStream)os).write(bytes, 0, len);
                    }
                    is.close();
                    ((OutputStream)os).close();
                    long crcValue = crc.getValue();
                    if (doUnpack200) {
                        File dest = new File(trgt.getParentFile(), trgt.getName().substring(0, trgt.getName().length() - 8));
                        this.log("Unpacking " + trgt + " to " + dest, 3);
                        AutoUpdate.unpack200(trgt, dest);
                        trgt.delete();
                        crcValue = AutoUpdate.getFileCRC(dest);
                        relName = relName.substring(0, relName.length() - 8);
                    }
                    ((OutputStream)config).write(("    <file crc='" + crcValue + "' name='" + relName + "'/>\n").getBytes("UTF-8"));
                }
                ((OutputStream)config).write("  </module_version>\n</module>\n".getBytes("UTF-8"));
                ((OutputStream)config).close();
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
            finally {
                if (delete && tmp != null) {
                    tmp.delete();
                }
                if (lastM == null) continue;
                lastM.setLastModified(System.currentTimeMillis());
            }
        }
    }

    public static boolean unpack200(File src, File dest) {
        String unpack200Executable = new File(System.getProperty("java.home"), "bin/unpack200" + (AutoUpdate.isWindows() ? ".exe" : "")).getAbsolutePath();
        ProcessBuilder pb = new ProcessBuilder(unpack200Executable, src.getAbsolutePath(), dest.getAbsolutePath());
        pb.directory(src.getParentFile());
        int result = 1;
        try {
            Process process = pb.start();
            result = process.waitFor();
            process.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result == 0;
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("windows");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getFileCRC(File file) throws IOException {
        BufferedInputStream bsrc = null;
        CRC32 crc = new CRC32();
        try {
            int i;
            bsrc = new BufferedInputStream(new FileInputStream(file));
            byte[] bytes = new byte[1024];
            while ((i = bsrc.read(bytes)) != -1) {
                crc.update(bytes, 0, i);
            }
        }
        finally {
            if (bsrc != null) {
                bsrc.close();
            }
        }
        return crc.getValue();
    }

    private boolean matches(String cnb, String targetCluster) {
        for (Modules ps : this.modules) {
            if (ps.clusters != null && (targetCluster == null || !ps.clusters.matcher(targetCluster).matches()) || !ps.pattern.matcher(cnb).matches()) continue;
            return true;
        }
        return false;
    }

    private Map<String, List<String>> findExistingModules(File ... clusters) {
        HashMap<String, List<String>> all = new HashMap<String, List<String>>();
        for (File c : clusters) {
            File mc = new File(c, "update_tracking");
            File[] arr = mc.listFiles();
            if (arr == null) continue;
            for (File m : arr) {
                try {
                    this.parseVersion(m, all);
                }
                catch (Exception ex) {
                    this.log("Cannot parse " + m, ex, 1);
                }
            }
        }
        return all;
    }

    private void parseVersion(final File config, final Map<String, List<String>> toAdd) throws Exception {
        class P
        extends DefaultHandler {
            String name;
            List<String> arr;

            P() {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if ("module".equals(qName)) {
                    this.name = attributes.getValue("codename");
                    int slash = this.name.indexOf(47);
                    if (slash > 0) {
                        this.name = this.name.substring(0, slash);
                    }
                    return;
                }
                if ("module_version".equals(qName)) {
                    String version = attributes.getValue("specification_version");
                    if (this.name == null || version == null) {
                        throw new BuildException("Cannot find version in " + config);
                    }
                    this.arr = new ArrayList<String>();
                    this.arr.add(version);
                    toAdd.put(this.name, this.arr);
                    return;
                }
                if ("file".equals(qName)) {
                    this.arr.add(attributes.getValue("name"));
                }
            }

            @Override
            public InputSource resolveEntity(String string, String string1) throws IOException, SAXException {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        }
        P p = new P();
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(config, (DefaultHandler)p);
    }

    public static final class Modules {
        Pattern pattern;
        Pattern clusters;

        public void setIncludes(String regExp) {
            this.pattern = Pattern.compile(regExp);
        }

        public void setClusters(String regExp) {
            this.clusters = Pattern.compile(regExp);
        }
    }
}

