/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.io.IOException;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class OpenCookieFactory {
    public static OpenCookie create(Project project, String string) {
        return OpenCookieFactory.create(project, string, null);
    }

    public static OpenCookie create(Project project, String string, String string2) {
        return new OpenCookieImpl(project, string, string2);
    }

    private static class OpenCookieImpl
    implements OpenCookie {
        private String className;
        private String methodName;
        private Project project;

        public OpenCookieImpl(Project project, String string, String string2) {
            this.project = project;
            this.className = string;
            this.methodName = string2;
        }

        public void open() {
            try {
                DataObject dataObject;
                FileObject fileObject = SourceGroupSupport.getFileObjectFromClassName(this.className, this.project);
                if (fileObject != null && (dataObject = DataObject.find((FileObject)fileObject)) != null) {
                    OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
                    if (openCookie != null) {
                        openCookie.open();
                    }
                    JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
                    LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                    if (lineCookie != null) {
                        long[] lArray = JavaSourceHelper.getPosition(javaSource, this.methodName);
                        Line line = lineCookie.getLineSet().getOriginal((int)lArray[0]);
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.NONE, (int)lArray[1]);
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

