/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.rest.client.RESTResourcesPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RESTClientGenerator
implements CodeGenerator {
    private FileObject targetSource;
    private JTextComponent targetComponent;

    RESTClientGenerator(FileObject fileObject, JTextComponent jTextComponent) {
        this.targetSource = fileObject;
        this.targetComponent = jTextComponent;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RESTClientGenerator.class, (String)"LBL_GenerateRESTClient");
    }

    public void invoke() {
        Node node;
        RESTResourcesPanel rESTResourcesPanel = new RESTResourcesPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)rESTResourcesPanel, NbBundle.getMessage(RESTClientGenerator.class, (String)"TTL_RESTResources"));
        rESTResourcesPanel.setDescriptor(dialogDescriptor);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(NotifyDescriptor.OK_OPTION) && (node = rESTResourcesPanel.getResourceNode()) != null) {
            ClientJavaSourceHelper.generateJerseyClient(node, this.targetSource, rESTResourcesPanel.getClassName(), rESTResourcesPanel.getSecurity());
            Object[] objectArray = new Object[]{"JAX-RS", "GENERATE REST RESOURCE"};
            LogUtils.logWsAction((Object[])objectArray);
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            CompilationController compilationController = (CompilationController)lookup.lookup(CompilationController.class);
            ArrayList<RESTClientGenerator> arrayList = new ArrayList<RESTClientGenerator>();
            if (compilationController != null) {
                try {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    FileObject fileObject = compilationController.getFileObject();
                    if (fileObject != null) {
                        JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
                        arrayList.add(new RESTClientGenerator(fileObject, jTextComponent));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return arrayList;
        }
    }
}

