/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.catalog.CatalogElement;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogEntryImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelImpl;
import org.netbeans.modules.xml.retriever.catalog.model.CatalogModel;
import org.netbeans.modules.xml.retriever.catalog.model.CatalogModelFactory;
import org.netbeans.modules.xml.retriever.catalog.model.NextCatalog;
import org.netbeans.modules.xml.retriever.catalog.model.System;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class XAMCatalogWriteModelImpl
extends CatalogModelImpl
implements CatalogWriteModel {
    boolean unitTestSaveStrategy = false;
    private CatalogModel catalogModel;
    private ModelSource modelSource;

    protected XAMCatalogWriteModelImpl(Project prj) throws CatalogModelException, IOException {
        super(prj);
        this.modelSource = this.createModelSource(this.catalogFileObject);
    }

    protected XAMCatalogWriteModelImpl(FileObject catalogFileObject) throws CatalogModelException, IOException {
        super(catalogFileObject);
        this.modelSource = this.createModelSource(this.catalogFileObject);
    }

    public XAMCatalogWriteModelImpl(File myProjectRootFile) throws IOException, CatalogModelException {
        super(myProjectRootFile);
        this.unitTestSaveStrategy = true;
        this.modelSource = this.createModelSource(this.catalogFileObject);
    }

    protected ModelSource createModelSource(FileObject catFileObject) throws CatalogModelException {
        return Utilities.createModelSource(this.catalogFileObject, true);
    }

    @Override
    public URI searchURI(URI locationURI) {
        File publicCatalogFile;
        if (locationURI == null) {
            return null;
        }
        URI strRes = null;
        if (this.catalogFileObject != null && (publicCatalogFile = FileUtil.toFile((FileObject)this.catalogFileObject)).isFile()) {
            try {
                strRes = this.resolveUsingApacheCatalog(publicCatalogFile, locationURI.toString());
            }
            catch (IOException ex) {
                return null;
            }
            catch (CatalogModelException ex) {
                return null;
            }
        }
        return strRes;
    }

    @Override
    public synchronized void addURI(URI locationURI, FileObject fileObj) throws IOException {
        URI fileObjURI = FileUtil.toFile((FileObject)fileObj).toURI();
        this.addURI(locationURI, fileObjURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addURI(URI locationURI, URI fileObjURI) throws IOException {
        URI finalDestStrURI;
        if (this.catalogFileObject == null) {
            return;
        }
        this.removeURI(locationURI);
        URI master = FileUtil.toFile((FileObject)this.catalogFileObject).toURI();
        String finalDestStr = Utilities.relativize(master, fileObjURI);
        try {
            finalDestStrURI = new URI(finalDestStr);
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URI: " + finalDestStr);
        }
        System sys = this.getCatalogModel().getFactory().createSystem();
        this.getCatalogModel().startTransaction();
        try {
            this.getCatalogModel().getRootComponent().addSystem(sys);
            sys.setSystemIDAttr(locationURI);
            sys.setURIAttr(finalDestStrURI);
        }
        finally {
            this.getCatalogModel().endTransaction();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeURI(URI locationURI) throws IOException {
        System delete = null;
        this.getCatalogModel().sync();
        for (System sys : this.getCatalogModel().getRootComponent().getSystems()) {
            if (!sys.getSystemIDAttr().equals(locationURI.toString())) continue;
            delete = sys;
            break;
        }
        if (delete != null) {
            this.getCatalogModel().startTransaction();
            try {
                this.getCatalogModel().getRootComponent().removeSystem(delete);
            }
            finally {
                this.getCatalogModel().endTransaction();
            }
            this.save();
        }
    }

    @Override
    public Collection<CatalogEntry> getCatalogEntries() {
        CatalogEntryImpl catEnt;
        ArrayList<CatalogEntry> result = new ArrayList<CatalogEntry>();
        if (this.getCatalogModel() == null || this.getCatalogModel().getRootComponent() == null) {
            return result;
        }
        for (System sys : this.getCatalogModel().getRootComponent().getSystems()) {
            catEnt = new CatalogEntryImpl(CatalogElement.system, sys.getSystemIDAttr(), sys.getURIAttr());
            result.add(catEnt);
        }
        for (NextCatalog nc : this.getCatalogModel().getRootComponent().getNextCatalogs()) {
            catEnt = new CatalogEntryImpl(CatalogElement.nextCatalog, nc.getCatalogAttr(), null);
            result.add(catEnt);
        }
        return result;
    }

    @Override
    public boolean isWellformed() {
        return this.getCatalogModel().getState().equals((Object)Model.State.VALID);
    }

    @Override
    public Model.State getState() {
        return this.getCatalogModel().getState();
    }

    @Override
    public FileObject getCatalogFileObject() {
        return this.catalogFileObject;
    }

    @Override
    public void addPropertychangeListener(PropertyChangeListener pcl) {
        this.getCatalogModel().addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.getCatalogModel().removePropertyChangeListener(pcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNextCatalog(URI nextCatalogFileURI, boolean relativize) throws IOException {
        if (this.catalogFileObject == null) {
            return;
        }
        String nextCatalogFileURIStr = nextCatalogFileURI.toString();
        if (nextCatalogFileURI.isAbsolute() && relativize) {
            nextCatalogFileURIStr = Utilities.relativize(FileUtil.toFile((FileObject)this.catalogFileObject).toURI(), nextCatalogFileURI);
        }
        try {
            nextCatalogFileURI = new URI(nextCatalogFileURIStr);
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URI: " + nextCatalogFileURIStr);
        }
        try {
            this.removeNextCatalog(nextCatalogFileURI);
        }
        catch (IOException ex) {
            // empty catch block
        }
        NextCatalog nc = this.getCatalogModel().getFactory().createNextCatalog();
        this.getCatalogModel().startTransaction();
        try {
            this.getCatalogModel().getRootComponent().addNextCatalog(nc);
            nc.setCatalogAttr(nextCatalogFileURI);
        }
        finally {
            this.getCatalogModel().endTransaction();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNextCatalog(URI nextCatalogFileRelativeURI) throws IOException {
        NextCatalog delete = null;
        for (NextCatalog nc : this.getCatalogModel().getRootComponent().getNextCatalogs()) {
            if (!nc.getCatalogAttr().equals(nextCatalogFileRelativeURI.toString())) continue;
            delete = nc;
            break;
        }
        if (delete != null) {
            this.getCatalogModel().startTransaction();
            try {
                this.getCatalogModel().getRootComponent().removeNextCatalog(delete);
            }
            finally {
                this.getCatalogModel().endTransaction();
            }
            this.save();
        }
    }

    protected void save() {
        FileObject fo = (FileObject)this.getCatalogModel().getModelSource().getLookup().lookup(FileObject.class);
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            SaveCookie saveCookie = (SaveCookie)dobj.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public CatalogModel getCatalogModel() {
        return CatalogModelFactory.getInstance().getModel(this.getModelSource());
    }

    public void setCatalogModel(CatalogModel catalogModel) {
        this.catalogModel = catalogModel;
    }

    public ModelSource getModelSource() {
        return this.modelSource;
    }
}

