/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.reglib.NbBundle;
import org.netbeans.modules.reglib.NbConnectionSupport;
import org.netbeans.modules.reglib.Util;
import org.netbeans.modules.servicetag.RegistrationData;
import org.netbeans.modules.servicetag.Registry;
import org.netbeans.modules.servicetag.ServiceTag;

public class NbServiceTagSupport {
    private static String NB_CLUSTER;
    private static String NB_VERSION;
    private static final String USER_HOME;
    private static final String SUPER_IDENTITY_FILE_NAME = ".superId";
    private static final String DEFAULT_NETBEANS_DIR = ".netbeans";
    private static final String USER_DIR;
    private static final String ST_DIR = "servicetag";
    private static final String ST_FILE = "servicetag";
    private static final String REG_FILE = "registration.xml";
    private static File svcTagDirHome;
    private static File svcTagDirNb;
    private static File serviceTagFileHome;
    private static File serviceTagFileNb;
    private static File nbClusterDir;
    private static File nbInstallDir;
    private static File regXmlFileHome;
    private static File regXmlFileNb;
    private static RegistrationData registration;
    private static final Logger LOG;
    private static File registerHtmlParent;
    private static final String REGISTRATION_HTML_NAME = "register";
    private static boolean inited;
    private static final String PRODUCT_KEY = "@@PRODUCT@@";
    private static final String PRODUCT_TITLE_KEY = "@@PRODUCT_TITLE@@";
    private static final String REGISTRATION_URL_KEY = "@@REGISTRATION_URL@@";
    private static final String REGISTRATION_PAYLOAD_KEY = "@@REGISTRATION_PAYLOAD@@";

    private static void init() {
        LOG.log(Level.FINE, "Initializing");
        NB_CLUSTER = NbBundle.getMessage(NbServiceTagSupport.class, "nb.cluster");
        NB_VERSION = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.version");
        File f = new File(System.getProperty("netbeans.home"));
        nbInstallDir = f.getParentFile();
        LOG.log(Level.FINE, "NetBeans install dir is:" + nbInstallDir);
        nbClusterDir = new File(nbInstallDir, NB_CLUSTER);
        LOG.log(Level.FINE, "nb cluster dir is:" + nbClusterDir);
        svcTagDirNb = new File(nbClusterDir.getPath() + File.separator + "servicetag");
        svcTagDirHome = new File(USER_HOME + File.separator + ".netbeans-registration" + File.separator + NB_VERSION);
        if (nbClusterDir.canWrite() && !svcTagDirNb.exists()) {
            svcTagDirNb.mkdirs();
        }
        if (!svcTagDirHome.exists()) {
            svcTagDirHome.mkdirs();
        }
        regXmlFileNb = new File(svcTagDirNb, REG_FILE);
        regXmlFileHome = new File(svcTagDirHome, REG_FILE);
        serviceTagFileNb = new File(svcTagDirNb, "servicetag");
        serviceTagFileHome = new File(svcTagDirHome, "servicetag");
        inited = true;
    }

    public static String getProductName() {
        return NbBundle.getMessage(NbServiceTagSupport.class, "nb.product.name");
    }

    public static String[] getProductNames(RegistrationData regData) {
        ArrayList<String> names = new ArrayList<String>();
        String nbProductURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.urn");
        boolean isGFAdded = false;
        boolean isASAdded = false;
        Set<ServiceTag> svcTags = regData.getServiceTags();
        block0: for (ServiceTag st : svcTags) {
            if (nbProductURN.equals(st.getProductURN())) {
                names.add(NbServiceTagSupport.getProductName());
                continue;
            }
            if (st.getProductDefinedInstanceID().contains("glassfish.home")) {
                String[] arr;
                for (String s : arr = st.getProductDefinedInstanceID().split(",")) {
                    if (!s.contains("glassfish.home")) continue;
                    String[] arrGF = s.split("=");
                    if (arrGF.length < 2) continue block0;
                    if (arrGF[1].toUpperCase(Locale.ENGLISH).contains("GLASSFISH")) {
                        if (isGFAdded) continue block0;
                        names.add("GlassFish V2.1");
                        isGFAdded = true;
                        continue block0;
                    }
                    if (!arrGF[1].toUpperCase(Locale.ENGLISH).contains("APPSERVER") && !arrGF[1].toUpperCase(Locale.ENGLISH).contains("SDK") || isASAdded) continue block0;
                    names.add("Sun GlassFish Enterprise Server V2.1");
                    isASAdded = true;
                    continue block0;
                }
                continue;
            }
            if (st.getProductName().contains("Sun Java System Application Server")) {
                if (isASAdded) continue;
                names.add("GlassFish V2.1");
                isASAdded = true;
                continue;
            }
            if (st.getProductName().contains("Sun GlassFish Enterprise Server")) {
                if (isGFAdded) continue;
                names.add("Sun GlassFish Enterprise Server V2.1");
                isGFAdded = true;
                continue;
            }
            if (st.getProductName().contains("J2SE 5.0 Development Kit")) {
                names.add(st.getProductName());
                continue;
            }
            if (!st.getProductName().contains("Java SE 6 Development Kit")) continue;
            names.add(st.getProductName());
        }
        return names.toArray(new String[0]);
    }

    public static String getProductId(RegistrationData regData) {
        String productId = "nb";
        boolean isJDK = false;
        boolean isGF = false;
        boolean isAS = false;
        Set<ServiceTag> svcTags = regData.getServiceTags();
        block0: for (ServiceTag st : svcTags) {
            if (st.getProductDefinedInstanceID().contains("glassfish.home")) {
                String[] arr;
                for (String s : arr = st.getProductDefinedInstanceID().split(",")) {
                    if (!s.contains("glassfish.home")) continue;
                    String[] arrGF = s.split("=");
                    if (arrGF.length < 2) continue block0;
                    if (arrGF[1].toUpperCase(Locale.ENGLISH).contains("GLASSFISH")) {
                        isGF = true;
                        continue block0;
                    }
                    if (!arrGF[1].toUpperCase(Locale.ENGLISH).contains("APPSERVER") && !arrGF[1].toUpperCase(Locale.ENGLISH).contains("SDK")) continue block0;
                    isAS = true;
                    continue block0;
                }
                continue;
            }
            if (st.getProductName().contains("Sun Java System Application Server")) {
                isAS = true;
                continue;
            }
            if (st.getProductName().contains("Sun GlassFish Enterprise Server")) {
                isGF = true;
                continue;
            }
            if (st.getProductName().contains("J2SE 5.0 Development Kit")) {
                isJDK = true;
                continue;
            }
            if (!st.getProductName().contains("Java SE 6 Development Kit")) continue;
            isJDK = true;
        }
        if (isJDK && (isGF || isAS)) {
            productId = "nbgfjdk";
        } else if (isJDK) {
            productId = "nbjdk";
        } else if (isGF) {
            productId = "nbgf";
        } else if (isAS) {
            productId = "nbas";
        }
        return productId;
    }

    public static ServiceTag createNbServiceTag(String source, String javaVersion) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating NetBeans service tag");
        ServiceTag st = NbServiceTagSupport.getNbServiceTag();
        if (st == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            st = NbServiceTagSupport.newNbServiceTag(source, javaVersion);
            NbServiceTagSupport.getRegistrationData().addServiceTag(st);
            NbServiceTagSupport.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport.installSystemServiceTag(st);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return st;
    }

    public static ServiceTag createJavaFXServiceTag(String source, String javaVersion) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating JavaFX service tag");
        ServiceTag st = NbServiceTagSupport.getJavaFXServiceTag();
        if (st == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            st = NbServiceTagSupport.newJavaFXServiceTag(source, javaVersion);
            NbServiceTagSupport.getRegistrationData().addServiceTag(st);
            NbServiceTagSupport.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport.installSystemServiceTag(st);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return st;
    }

    public static ServiceTag createJavaFXSdkServiceTag(String source, String javaVersion) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating JavaFX SDK service tag");
        ServiceTag st = NbServiceTagSupport.getJavaFXSdkServiceTag();
        if (st == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            st = NbServiceTagSupport.newJavaFXSdkServiceTag(source, javaVersion);
            NbServiceTagSupport.getRegistrationData().addServiceTag(st);
            NbServiceTagSupport.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport.installSystemServiceTag(st);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return st;
    }

    public static ServiceTag createCndServiceTag(String source, String javaVersion) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating CND service tag");
        ServiceTag st = NbServiceTagSupport.getCndServiceTag();
        if (st == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            st = NbServiceTagSupport.newCndServiceTag(source, javaVersion);
            NbServiceTagSupport.getRegistrationData().addServiceTag(st);
            NbServiceTagSupport.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport.installSystemServiceTag(st);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return st;
    }

    public static ServiceTag createGfServiceTag(String source, String jdkHomeUsedByGlassfish, String jdkVersionUsedByGlassfish, String glassfishHome, String gfVersion) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating GlassFish service tag");
        ServiceTag st = NbServiceTagSupport.getGfServiceTag(gfVersion);
        if (st != null) {
            if (serviceTagFileNb.exists() || serviceTagFileHome.exists()) {
                LOG.log(Level.FINE, "GlassFish service tag is already created and saved in registration.xml");
            } else {
                LOG.log(Level.FINE, "GlassFish service tag is already created");
            }
        } else {
            LOG.log(Level.FINE, "Creating new GlassFish service tag");
            st = NbServiceTagSupport.newGfServiceTag(source, jdkHomeUsedByGlassfish, jdkVersionUsedByGlassfish, glassfishHome, gfVersion);
            NbServiceTagSupport.getRegistrationData().addServiceTag(st);
            NbServiceTagSupport.writeRegistrationXml();
        }
        return st;
    }

    public static ServiceTag createGfServiceTag(ServiceTag serviceTag, String gfVersion) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating GlassFish service tag");
        ServiceTag st = NbServiceTagSupport.getGfServiceTag(gfVersion);
        if (st != null) {
            if (!st.equals(serviceTag)) {
                NbServiceTagSupport.getRegistrationData().removeServiceTag(st.getInstanceURN());
                NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
                NbServiceTagSupport.writeRegistrationXml();
            }
        } else {
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        return serviceTag;
    }

    public static ServiceTag createJdkServiceTag(String source) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating JDK service tag");
        ServiceTag st = NbServiceTagSupport.getJdkServiceTag();
        if (st != null) {
            if (serviceTagFileNb.exists() || serviceTagFileHome.exists()) {
                LOG.log(Level.FINE, "JDK service tag is already created and saved in registration.xml");
                return st;
            }
            LOG.log(Level.FINE, "JDK service tag is already created");
        }
        if (st == null) {
            LOG.log(Level.FINE, "Creating new JDK service tag");
            st = ServiceTag.getJavaServiceTag(source);
            NbServiceTagSupport.getRegistrationData().addServiceTag(st);
            NbServiceTagSupport.writeRegistrationXml();
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRegistrationXml() throws IOException {
        File targetFile = null;
        if (svcTagDirNb.exists() && svcTagDirNb.canWrite()) {
            File tmpFile = null;
            try {
                tmpFile = File.createTempFile("regtmp", null, svcTagDirNb);
            }
            catch (IOException exc) {
                LOG.log(Level.INFO, "Warning: Cannot create file in " + svcTagDirNb + " Will use user home dir", exc);
            }
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
                targetFile = regXmlFileNb.exists() ? (regXmlFileNb.delete() ? regXmlFileNb : regXmlFileHome) : regXmlFileNb;
            } else {
                targetFile = regXmlFileHome;
            }
        } else {
            targetFile = regXmlFileHome;
        }
        LOG.log(Level.FINE, "writeRegistrationXml targetFile: " + targetFile);
        try {
            FileOutputStream os = new FileOutputStream(targetFile);
            try {
                BufferedOutputStream out = new BufferedOutputStream(os);
                NbServiceTagSupport.getRegistrationData().storeToXML(out);
                out.close();
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Error: Cannot save registration data to \"" + targetFile + "\":" + ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RegistrationData getRegistrationData() throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        if (registration != null) {
            return registration;
        }
        File srcFile = null;
        if (regXmlFileNb.exists()) {
            if (regXmlFileNb.length() == 0L) {
                if (!regXmlFileHome.exists()) {
                    registration = new RegistrationData();
                    LOG.log(Level.FINE, "Service tag file:" + regXmlFileNb + " is empty.");
                    return registration;
                }
                if (regXmlFileHome.length() == 0L) {
                    registration = new RegistrationData();
                    LOG.log(Level.FINE, "Service tag file:" + regXmlFileHome + " is empty.");
                    return registration;
                }
                srcFile = regXmlFileHome;
            } else {
                srcFile = regXmlFileNb;
                LOG.log(Level.FINE, "Service tag will be loaded from NB install dir: " + srcFile);
            }
        } else {
            if (!regXmlFileHome.exists()) {
                registration = new RegistrationData();
                LOG.log(Level.FINE, "Service tag file not found");
                return registration;
            }
            if (regXmlFileHome.length() == 0L) {
                registration = new RegistrationData();
                LOG.log(Level.FINE, "Service tag file:" + regXmlFileHome + " is empty.");
                return registration;
            }
            srcFile = regXmlFileHome;
            LOG.log(Level.FINE, "Service tag will be loaded from user home dir: " + srcFile);
        }
        try {
            FileInputStream is = new FileInputStream(srcFile);
            try {
                BufferedInputStream in = new BufferedInputStream(is);
                registration = RegistrationData.loadFromXML(in);
                in.close();
                return registration;
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Error: Bad registration data \"" + srcFile + "\":" + ex.getMessage());
            throw ex;
        }
    }

    private static ServiceTag newNbServiceTag(String svcTagSource, String javaVersion) throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.urn");
        String productName = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.name");
        String parentURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.parent.urn");
        String parentName = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), productName, NB_VERSION, productURN, parentName, parentURN, NbServiceTagSupport.getNbProductDefinedId(javaVersion, true), "NetBeans.org", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), svcTagSource);
    }

    private static ServiceTag newJavaFXServiceTag(String svcTagSource, String javaVersion) throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.urn");
        String productName = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.name");
        String productVersion = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.version");
        String parentURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.parent.urn");
        String parentName = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), productName, productVersion, productURN, parentName, parentURN, NbServiceTagSupport.getNbProductDefinedId(javaVersion, false), "NetBeans.org", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), svcTagSource);
    }

    private static ServiceTag newJavaFXSdkServiceTag(String svcTagSource, String javaVersion) throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.urn");
        String productName = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.name");
        String productVersion = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.version");
        String parentURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.parent.urn");
        String parentName = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), productName, productVersion, productURN, parentName, parentURN, NbServiceTagSupport.getNbProductDefinedId(javaVersion, false), "Sun Microsystems", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), svcTagSource);
    }

    private static ServiceTag newCndServiceTag(String svcTagSource, String javaVersion) throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.cnd.urn");
        String productName = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.cnd.name");
        String parentURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.cnd.parent.urn");
        String parentName = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.cnd.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), productName, NB_VERSION, productURN, parentName, parentURN, NbServiceTagSupport.getNbProductDefinedId(javaVersion, false), "NetBeans.org", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), svcTagSource);
    }

    private static ServiceTag newGfServiceTag(String svcTagSource, String jdkHomeUsedByGlassfish, String jdkVersionUsedByGlassfish, String glassfishHome, String gfVersion) throws IOException {
        String key = "";
        if (!"".equals(gfVersion)) {
            key = key + "." + gfVersion;
        }
        String productURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.urn" + key);
        String productName = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.name" + key);
        String productVersion = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.version" + key);
        String parentURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.parent.urn" + key);
        String parentName = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.parent.name" + key);
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), productName, productVersion, productURN, parentName, parentURN, NbServiceTagSupport.getGfProductDefinedId(jdkHomeUsedByGlassfish, jdkVersionUsedByGlassfish, glassfishHome), "Sun Microsystems Inc.", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), svcTagSource);
    }

    private static ServiceTag getNbServiceTag() throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.urn");
        RegistrationData regData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> svcTags = regData.getServiceTags();
        for (ServiceTag st : svcTags) {
            if (!productURN.equals(st.getProductURN())) continue;
            return st;
        }
        return null;
    }

    private static ServiceTag getJavaFXServiceTag() throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.urn");
        RegistrationData regData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> svcTags = regData.getServiceTags();
        for (ServiceTag st : svcTags) {
            if (!productURN.equals(st.getProductURN())) continue;
            return st;
        }
        return null;
    }

    private static ServiceTag getJavaFXSdkServiceTag() throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.urn");
        RegistrationData regData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> svcTags = regData.getServiceTags();
        for (ServiceTag st : svcTags) {
            if (!productURN.equals(st.getProductURN())) continue;
            return st;
        }
        return null;
    }

    private static ServiceTag getCndServiceTag() throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.cnd.urn");
        RegistrationData regData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> svcTags = regData.getServiceTags();
        for (ServiceTag st : svcTags) {
            if (!productURN.equals(st.getProductURN())) continue;
            return st;
        }
        return null;
    }

    private static ServiceTag getGfServiceTag(String gfVersion) throws IOException {
        RegistrationData regData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> svcTags = regData.getServiceTags();
        String key = "";
        if (!"".equals(gfVersion)) {
            key = key + "." + gfVersion;
        }
        String productURN = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.urn" + key);
        for (ServiceTag st : svcTags) {
            if (!st.getProductURN().equals(productURN)) continue;
            return st;
        }
        return null;
    }

    private static ServiceTag getJdkServiceTag() throws IOException {
        RegistrationData regData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> svcTags = regData.getServiceTags();
        for (ServiceTag st : svcTags) {
            if (!st.getProductName().startsWith("J2SE") && !st.getProductName().startsWith("Java SE")) continue;
            return st;
        }
        return null;
    }

    private static String getNbProductDefinedId(String javaVersion, boolean addUuid) {
        StringBuilder definedId = new StringBuilder();
        definedId.append("id=");
        definedId.append(NB_VERSION);
        if (addUuid) {
            definedId.append(",uuid=");
            definedId.append(NbServiceTagSupport.getSuperId());
        }
        definedId.append(",java.version=");
        definedId.append(javaVersion);
        String location = ",dir=" + nbInstallDir.getPath();
        if (definedId.length() + location.length() < 256) {
            definedId.append(location);
        } else {
            LOG.log(Level.INFO, "Warning: Product defined instance ID exceeds the field limit:");
        }
        return definedId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSuperId() {
        String superId = "";
        File f = new File(USER_HOME + File.separator + DEFAULT_NETBEANS_DIR + File.separator + SUPER_IDENTITY_FILE_NAME);
        if (f.exists() && f.length() > 0L) {
            try {
                FileReader r = new FileReader(f);
                try {
                    BufferedReader br = new BufferedReader(r);
                    superId = br.readLine().trim();
                    br.close();
                }
                finally {
                    ((Reader)r).close();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Error: Cannot read from file:" + f, ex);
            }
        } else {
            File dir = new File(USER_HOME + File.separator + DEFAULT_NETBEANS_DIR);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            try {
                FileWriter w = new FileWriter(f);
                try {
                    BufferedWriter bw = new BufferedWriter(w);
                    superId = UUID.randomUUID().toString();
                    bw.write(superId);
                    bw.close();
                }
                finally {
                    ((Writer)w).close();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Error: Cannot write to file:" + f, ex);
            }
        }
        return superId;
    }

    private static String getGfProductDefinedId(String jdkHomeUsedByGlassfish, String jdkVersionUsedByGlassfish, String glassfishHome) {
        StringBuilder definedId = new StringBuilder();
        definedId.append("os.name=");
        definedId.append(System.getProperty("os.name"));
        definedId.append(",os.version=");
        definedId.append(System.getProperty("os.version"));
        definedId.append(",java.version=");
        definedId.append(jdkVersionUsedByGlassfish);
        definedId.append(",glassfish.home=");
        definedId.append(glassfishHome);
        definedId.append(",java.home=");
        definedId.append(jdkHomeUsedByGlassfish);
        return definedId.toString();
    }

    private static String getZoneName() throws IOException {
        String zonename = "global";
        String command = "/usr/bin/zonename";
        File f = new File(command);
        if (f.canExecute()) {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            String output = Util.commandOutput(p);
            if (p.exitValue() == 0) {
                zonename = output.trim();
            }
        }
        return zonename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInstalledURN(String urn) throws IOException {
        if (serviceTagFileNb.exists() || serviceTagFileHome.exists()) {
            File srcFile = null;
            if (serviceTagFileNb.exists()) {
                srcFile = serviceTagFileNb;
            } else if (serviceTagFileHome.exists()) {
                srcFile = serviceTagFileHome;
            }
            FileReader r = new FileReader(srcFile);
            try {
                BufferedReader in = new BufferedReader(r);
                String line = in.readLine();
                while (line != null) {
                    if (urn.equals(line.trim())) {
                        String string = urn;
                        return string;
                    }
                    line = in.readLine();
                }
                in.close();
                String string = "";
                return string;
            }
            finally {
                ((Reader)r).close();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installSystemServiceTag(ServiceTag st) throws IOException {
        File targetFile;
        if (NbServiceTagSupport.getInstalledURN(st.getInstanceURN()).length() > 0) {
            LOG.log(Level.INFO, "ST is already installed ie. we have file servicetag.");
            return;
        }
        if (svcTagDirNb.exists() && svcTagDirNb.canWrite()) {
            File tmpFile = null;
            try {
                tmpFile = File.createTempFile("regtmp", null, svcTagDirNb);
            }
            catch (IOException exc) {
                LOG.log(Level.INFO, "Error: Cannot create file in " + svcTagDirNb + " Will use user home dir", exc);
            }
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
                targetFile = serviceTagFileNb;
            } else {
                targetFile = serviceTagFileHome;
            }
        } else {
            targetFile = serviceTagFileHome;
        }
        if (Registry.isSupported()) {
            if (Registry.getSystemRegistry().getServiceTag(st.getInstanceURN()) != null) {
                LOG.log(Level.FINE, "Service tag: " + st.getInstanceURN() + " is already installed in system registry.");
                return;
            }
            Registry.getSystemRegistry().addServiceTag(st);
            FileWriter w = new FileWriter(targetFile, true);
            try {
                LOG.log(Level.FINE, "Creating file: " + targetFile);
                BufferedWriter out = new BufferedWriter(w);
                out.write(st.getInstanceURN());
                out.newLine();
                out.close();
            }
            finally {
                ((Writer)w).close();
            }
        }
    }

    private static File getRegisterHtmlParent() {
        if (registerHtmlParent == null) {
            registerHtmlParent = svcTagDirHome;
        }
        return registerHtmlParent;
    }

    public static File getServiceTagDirHome() {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        return svcTagDirHome;
    }

    public static File getRegistrationHtmlPage(String product, String[] productNames) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        File parent = NbServiceTagSupport.getRegisterHtmlParent();
        File f = new File(parent, "register.html");
        NbServiceTagSupport.generateRegisterHtml(parent, product, productNames);
        return f;
    }

    private static void deleteRegistrationHtmlPage() {
        File parent = NbServiceTagSupport.getRegisterHtmlParent();
        if (parent == null) {
            return;
        }
        String name = REGISTRATION_HTML_NAME;
        File f = new File(parent, name + ".html");
        if (f.exists()) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateRegisterHtml(File parent, String product, String[] productNames) throws IOException {
        Locale[] locales;
        String[] imgResources;
        RegistrationData regData = NbServiceTagSupport.getRegistrationData();
        String registerURL = NbConnectionSupport.getRegistrationURL(regData.getRegistrationURN(), product).toString();
        String resourcePrefix = "/org/netbeans/modules/reglib/resources/";
        for (String resourceName : imgResources = new String[]{"kz_backg.png", "kz_backh.png", "oracle-white.png", "pg_box_bg_lft_bot.gif", "pg_box_bg_rpt_bot.gif", "pg_box_bg_rt_bot.gif", "pg_box_hder_bg_lft.gif", "pg_box_hder_bg_rpt.gif", "pg_box_hder_bg_rt.gif", "pg_box_side_lft.gif", "pg_box_side_rt.gif", "red-arrow.gif", "red_triangle.gif"}) {
            String resource = resourcePrefix + resourceName;
            File img = new File(svcTagDirHome, resourceName);
            InputStream in = NbServiceTagSupport.class.getResourceAsStream(resource);
            if (in == null) {
                LOG.log(Level.FINE, "Missing resource file: " + resource);
                continue;
            }
            try {
                LOG.log(Level.FINE, "Generating " + img + " from " + resource);
                BufferedInputStream bis = null;
                FileOutputStream fos = null;
                try {
                    int c;
                    bis = new BufferedInputStream(in);
                    fos = new FileOutputStream(img);
                    while ((c = bis.read()) != -1) {
                        fos.write(c);
                    }
                }
                finally {
                    IOException exc = null;
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                    }
                    catch (IOException ex) {
                        exc = ex;
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    if (exc == null) continue;
                    throw exc;
                }
            }
            finally {
                in.close();
            }
        }
        String xml = regData.toString();
        String lineSep = System.getProperty("line.separator");
        String payload = xml.replaceAll("\"", "%22").replaceAll(lineSep, " ");
        String name = REGISTRATION_HTML_NAME;
        File f = new File(parent, name + ".html");
        InputStream in = null;
        Locale l = Locale.getDefault();
        for (Locale locale : locales = new Locale[]{new Locale(l.getLanguage(), l.getCountry(), l.getVariant()), new Locale(l.getLanguage(), l.getCountry()), new Locale(l.getLanguage()), new Locale("")}) {
            String resource = "/org/netbeans/modules/reglib/resources/register" + (locale.toString().equals("") ? "" : "_" + locale) + ".html";
            LOG.log(Level.FINE, "Looking for html in: " + resource);
            in = NbServiceTagSupport.class.getResourceAsStream(resource);
            if (in == null) continue;
            LOG.log(Level.FINE, "Found html in: " + resource);
            break;
        }
        if (in != null) {
            try {
                LOG.log(Level.FINE, "Generating " + f);
                BufferedReader reader = null;
                PrintWriter pw = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    pw = new PrintWriter(f, "UTF-8");
                    String line = null;
                    String productName = "";
                    String productNameTitle = "";
                    for (int i = 0; i < productNames.length; ++i) {
                        if (i > 0) {
                            productName = productName + " " + NbBundle.getMessage(NbServiceTagSupport.class, "MSG_junction") + " ";
                            productNameTitle = productNameTitle + " " + NbBundle.getMessage(NbServiceTagSupport.class, "MSG_junction") + " ";
                        }
                        productName = productName + "<strong>" + productNames[i] + "</strong>";
                        productNameTitle = productNameTitle + productNames[i];
                    }
                    while ((line = reader.readLine()) != null) {
                        String output = line;
                        if (line.contains(PRODUCT_KEY)) {
                            output = line.replace(PRODUCT_KEY, productName);
                        } else if (line.contains(PRODUCT_TITLE_KEY)) {
                            output = line.replace(PRODUCT_TITLE_KEY, productNameTitle);
                        } else if (line.contains(REGISTRATION_URL_KEY)) {
                            output = line.replace(REGISTRATION_URL_KEY, registerURL);
                        } else if (line.contains(REGISTRATION_PAYLOAD_KEY)) {
                            output = line.replace(REGISTRATION_PAYLOAD_KEY, payload);
                        }
                        pw.println(output);
                    }
                }
                finally {
                    if (pw != null) {
                        pw.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            finally {
                in.close();
            }
        }
    }

    static {
        USER_HOME = System.getProperty("user.home");
        USER_DIR = System.getProperty("netbeans.user");
        LOG = Logger.getLogger("org.netbeans.modules.reglib.NbServiceTagSupport");
        inited = false;
    }
}

