/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.ui.wizards.NewJ2SEProjectWizardIterator;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders;
import org.netbeans.modules.java.j2seproject.ui.wizards.SettingsPanel;
import org.netbeans.modules.java.j2seproject.ui.wizards.WizardSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    public static final String PROP_PROJECT_LOCATION = "projectLocation";
    private PanelConfigureProject panel;
    private NewJ2SEProjectWizardIterator.WizardType type;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    public PanelProjectLocationVisual(PanelConfigureProject panel, NewJ2SEProjectWizardIterator.WizardType type) {
        this.initComponents();
        this.panel = panel;
        this.type = type;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSN_projectNameLabel"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSD_projectNameLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSN_projectLocationLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSD_projectLocationLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationVisual.this.browseLocationAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSD_browseButton"));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSN_createdFolderLabel"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSD_createdFolderLabel"));
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSN_PanelProjectLocationVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSD_PanelProjectLocationVisual"));
    }

    private void browseLocationAction(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
            chooser.setDialogTitle(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_NWP1_SelectProjectLocation"));
            chooser.setFileSelectionMode(1);
            String path = this.projectLocationTextField.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    @Override
    boolean valid(WizardDescriptor wizardDescriptor) {
        File projLoc;
        if (this.projectNameTextField.getText().length() == 0 || this.projectNameTextField.getText().indexOf(47) >= 0 || this.projectNameTextField.getText().indexOf(92) >= 0 || this.projectNameTextField.getText().indexOf(58) >= 0 || this.projectNameTextField.getText().indexOf("\"") >= 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        File f = new File(this.projectLocationTextField.getText()).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(f) == null) {
            String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        File cfl = PanelProjectLocationVisual.getCanonicalFile(new File(this.createdFolderTextField.getText()));
        if (Utilities.isUnix() && cfl != null && cfl.getParentFile().getParent() == null) {
            String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectInRootNotSupported");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        File destFolder = new File(this.createdFolderTextField.getText()).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(destFolder) == null) {
            String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        for (projLoc = FileUtil.normalizeFile((File)destFolder); projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderReadOnly"));
            return false;
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            String message = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderExists"));
            return false;
        }
        Project prj = null;
        boolean foundButBroken = false;
        try {
            prj = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)destFolder)));
        }
        catch (IOException ex) {
            foundButBroken = true;
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (prj != null || foundButBroken) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectMightAlreadyExists"));
            return false;
        }
        return true;
    }

    @Override
    void store(WizardDescriptor d) {
        String name = this.projectNameTextField.getText().trim();
        String location = this.projectLocationTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        d.putProperty("projdir", (Object)new File(folder));
        d.putProperty("name", (Object)name);
    }

    @Override
    void read(WizardDescriptor settings) {
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = (String)settings.getProperty("name");
        if (projectName == null) {
            switch (this.type) {
                case APP: {
                    int baseCount = WizardSettings.getNewApplicationCount() + 1;
                    String formatter = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_JavaApplication");
                    while ((projectName = this.validFreeProjectName(projectLocation, formatter, baseCount)) == null) {
                        ++baseCount;
                    }
                    settings.putProperty("nameIndex", (Object)new Integer(baseCount));
                    break;
                }
                default: {
                    int baseCount = WizardSettings.getNewLibraryCount() + 1;
                    String formatter = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_JavaLibrary");
                    while ((projectName = this.validFreeProjectName(projectLocation, formatter, baseCount)) == null) {
                        ++baseCount;
                    }
                    settings.putProperty("nameIndex", (Object)new Integer(baseCount));
                }
            }
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    private static JFileChooser createChooser() {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setName("Select Project Directory");
        return chooser;
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String name = MessageFormat.format(formater, new Integer(index));
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText();
            String projectFolder = this.projectLocationTextField.getText();
            String projFolderPath = FileUtil.normalizeFile((File)new File(projectFolder)).getAbsolutePath();
            if (projFolderPath.endsWith(File.separator)) {
                this.createdFolderTextField.setText(projFolderPath + projectName);
            } else {
                this.createdFolderTextField.setText(projFolderPath + File.separator + projectName);
            }
        }
        this.panel.fireChangeEvent();
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }
}

