/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class FoldersListSettings {
    private static final FoldersListSettings INSTANCE = new FoldersListSettings();
    private static final String NEW_PROJECT_COUNT = "newProjectCount";
    private static final String NEW_APP_COUNT = "newApplicationCount";
    private static final String LAST_USED_CP_FOLDER = "lastUsedClassPathFolder";
    private static final String LAST_USED_ARTIFACT_FOLDER = "lastUsedArtifactFolder";

    public static FoldersListSettings getDefault() {
        return INSTANCE;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(FoldersListSettings.class);
    }

    public String displayName() {
        return NbBundle.getMessage(FoldersListSettings.class, (String)"TXT_RubyProjectFolderList");
    }

    public int getNewProjectCount() {
        return FoldersListSettings.getPreferences().getInt(NEW_PROJECT_COUNT, 0);
    }

    public void setNewProjectCount(int count) {
        FoldersListSettings.getPreferences().putInt(NEW_PROJECT_COUNT, count);
    }

    public int getNewApplicationCount() {
        return FoldersListSettings.getPreferences().getInt(NEW_APP_COUNT, 0);
    }

    public void setNewApplicationCount(int count) {
        FoldersListSettings.getPreferences().putInt(NEW_APP_COUNT, count);
    }

    public File getLastUsedClassPathFolder() {
        return new File(FoldersListSettings.getPreferences().get(LAST_USED_CP_FOLDER, System.getProperty("user.home")));
    }

    public void setLastUsedClassPathFolder(File folder) {
        assert (folder != null) : "ClassPath root can not be null";
        String path = folder.getAbsolutePath();
        FoldersListSettings.getPreferences().put(LAST_USED_CP_FOLDER, path);
    }

    public File getLastUsedArtifactFolder() {
        return new File(FoldersListSettings.getPreferences().get(LAST_USED_ARTIFACT_FOLDER, System.getProperty("user.home")));
    }

    public void setLastUsedArtifactFolder(File folder) {
        assert (folder != null) : "Folder can not be null";
        String path = folder.getAbsolutePath();
        FoldersListSettings.getPreferences().put(LAST_USED_ARTIFACT_FOLDER, path);
    }
}

