/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class BootClassPathProvider
implements ClassPathProvider {
    private Map<FileObject, WeakReference<ClassPath>> sourceClassPathsCache = new WeakHashMap<FileObject, WeakReference<ClassPath>>();

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("ruby/classpath/boot")) {
            for (RubyPlatform platform : RubyPlatformManager.getPlatforms()) {
                FileObject systemRoot;
                if (!platform.isValid() || (systemRoot = platform.getSystemRoot(file)) == null) continue;
                return this.getRubyClassPaths(file, type, systemRoot);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getRubyClassPaths(FileObject file, String type, FileObject systemRoot) {
        BootClassPathProvider bootClassPathProvider = this;
        synchronized (bootClassPathProvider) {
            Reference ref;
            ClassPath cp = null;
            if (!file.isFolder()) {
                file = systemRoot;
            }
            if (file.isFolder() && ((ref = (Reference)this.sourceClassPathsCache.get(file)) == null || (cp = (ClassPath)ref.get()) == null)) {
                cp = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{file});
                this.sourceClassPathsCache.put(file, new WeakReference<ClassPath>(cp));
            }
            return cp;
        }
    }
}

