/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.util.Parameters;

public class CodeUtils {
    public static final String FUNCTION_TYPE_PREFIX = "@fn:";
    public static final String METHOD_TYPE_PREFIX = "@mtd:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "@static.mtd:";
    private static final Logger LOGGER = Logger.getLogger(CodeUtils.class.getName());

    private CodeUtils() {
    }

    public static Identifier extractIdentifier(Expression clsName) {
        Parameters.notNull((CharSequence)"clsName", (Object)clsName);
        if (clsName instanceof Identifier) {
            return (Identifier)clsName;
        }
        if (clsName instanceof NamespaceName) {
            return CodeUtils.extractIdentifier((NamespaceName)clsName);
        }
        assert (false) : "[php5.3] className Expression instead of Identifier";
        return null;
    }

    public static String extractTypeName(Expression clsName) {
        Parameters.notNull((CharSequence)"clsName", (Object)clsName);
        if (clsName instanceof Identifier) {
            return ((Identifier)clsName).getName();
        }
        if (clsName instanceof NamespaceName) {
            return CodeUtils.extractTypeName((NamespaceName)clsName);
        }
        assert (false) : "[php5.3] className Expression instead of Identifier";
        return null;
    }

    public static String extractClassName(StaticDispatch dispatch) {
        Parameters.notNull((CharSequence)"dispatch", (Object)dispatch);
        Expression clsName = dispatch.getClassName();
        return CodeUtils.extractTypeName(clsName);
    }

    public static String extractParameterTypeName(FormalParameter param) {
        Parameters.notNull((CharSequence)"param", (Object)param);
        Expression typeName = param.getParameterType();
        return typeName != null ? CodeUtils.extractTypeName(typeName) : null;
    }

    public static String extractTypeName(CatchClause catchClause) {
        Parameters.notNull((CharSequence)"catchClause", (Object)catchClause);
        Expression typeName = catchClause.getClassName();
        return typeName != null ? CodeUtils.extractTypeName(typeName) : null;
    }

    public static String extractSuperClassName(ClassDeclaration clsDeclaration) {
        Parameters.notNull((CharSequence)"clsDeclaration", (Object)clsDeclaration);
        Expression clsName = clsDeclaration.getSuperClass();
        return clsName != null ? CodeUtils.extractTypeName(clsName) : null;
    }

    public static String extractTypeName(NamespaceName name) {
        NamespaceName namespaceName;
        List segments;
        if (name instanceof NamespaceName && (segments = (namespaceName = name).getSegments()).size() >= 1) {
            return ((Identifier)segments.get(segments.size() - 1)).getName();
        }
        return null;
    }

    public static Identifier extractIdentifier(NamespaceName name) {
        NamespaceName namespaceName;
        List segments;
        if (name instanceof NamespaceName && (segments = (namespaceName = name).getSegments()).size() >= 1) {
            return (Identifier)segments.get(segments.size() - 1);
        }
        return null;
    }

    public static String extractClassName(ClassName clsName) {
        Expression name = clsName.getName();
        while (name instanceof Variable || name instanceof FieldAccess) {
            if (name instanceof Variable) {
                Variable var = (Variable)name;
                name = var.getName();
                continue;
            }
            if (!(name instanceof FieldAccess)) continue;
            FieldAccess fld = (FieldAccess)name;
            name = fld.getField().getName();
        }
        if (name instanceof NamespaceName) {
            return CodeUtils.extractTypeName((NamespaceName)name);
        }
        return name instanceof Identifier ? ((Identifier)name).getName() : "";
    }

    public static String extractClassName(ClassDeclaration clsDeclaration) {
        return clsDeclaration.getName().getName();
    }

    @CheckForNull
    public static String extractVariableName(Variable var) {
        Expression name;
        if (var instanceof ReflectionVariable) {
            name = ((ReflectionVariable)var).getName();
            if (name instanceof Scalar) {
                Scalar scalar = (Scalar)name;
                return scalar.getStringValue();
            }
            if (name instanceof Variable) {
                var = (Variable)name;
                return CodeUtils.extractVariableName(var);
            }
            if (name instanceof FieldAccess) {
                var = ((FieldAccess)name).getField();
                return CodeUtils.extractVariableName(var);
            }
            if (name instanceof InfixExpression) {
                return null;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cannot extract variable name of ReflectionVariable: " + name.getClass().toString());
            }
        }
        if (var.getName() instanceof Identifier) {
            Identifier id = (Identifier)var.getName();
            StringBuilder varName = new StringBuilder();
            if (var.isDollared()) {
                varName.append("$");
            }
            varName.append(id.getName());
            return varName.toString();
        }
        if (var.getName() instanceof Variable) {
            name = (Variable)var.getName();
            return CodeUtils.extractVariableName((Variable)name);
        }
        if (var.getName() instanceof MethodInvocation) {
            return null;
        }
        LOGGER.fine("Cannot extract variable name of type: " + var.getName().getClass().toString());
        return null;
    }
}

