/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;

public class MethodImpl<T>
extends FunctionImpl<T>
implements CsmMethod {
    private final CsmVisibility visibility;
    private static final byte ABSTRACT = 32;
    private static final byte VIRTUAL = 64;
    private static final byte EXPLICIT = -128;

    public MethodImpl(AST aST, ClassImpl classImpl, CsmVisibility csmVisibility) throws AstRendererException {
        this(aST, classImpl, csmVisibility, true, true);
    }

    protected MethodImpl(AST aST, ClassImpl classImpl, CsmVisibility csmVisibility, boolean bl, boolean bl2) throws AstRendererException {
        super(aST, classImpl.getContainingFile(), (CsmScope)classImpl, false, bl2);
        this.visibility = csmVisibility;
        block5: for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            switch (aST2.getType()) {
                case 131: {
                    this.setStatic(true);
                    continue block5;
                }
                case 123: {
                    this.setVirtual(true);
                    continue block5;
                }
                case 124: {
                    this.setExplicit(true);
                }
            }
        }
        if (bl) {
            this.registerInProject();
        }
    }

    public CsmClass getContainingClass() {
        return (CsmClass)this.getScope();
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public boolean isAbstract() {
        return this.hasFlags((byte)32);
    }

    public void setAbstract(boolean bl) {
        this.setFlags((byte)32, bl);
    }

    private void setVirtual(boolean bl) {
        this.setFlags((byte)64, bl);
    }

    private void setExplicit(boolean bl) {
        this.setFlags((byte)-128, bl);
    }

    public boolean isExplicit() {
        return this.hasFlags((byte)-128);
    }

    public boolean isVirtual() {
        return this.hasFlags((byte)64);
    }

    @Override
    public boolean isConst() {
        return super.isConst();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeVisibility(this.visibility, dataOutput);
    }

    public MethodImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.visibility = PersistentUtils.readVisibility(dataInput);
    }
}

