/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProvidesAction
implements ActionProvider {
    private static final String COMMAND_VERIFY = "verify";
    private Project project;
    static Map commands = new HashMap();

    ProvidesAction(Project project) {
        this.project = project;
    }

    public String[] getSupportedActions() {
        return new String[]{"build", "run", COMMAND_VERIFY, "delete", "copy", "move", "rename"};
    }

    public void invokeAction(final String command, final Lookup context) {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        Runnable action = new Runnable(){

            @Override
            public void run() {
                String[] targetNames = ProvidesAction.this.getTargetNames(command, context);
                if (targetNames == null) {
                    return;
                }
                if (targetNames.length == 0) {
                    targetNames = null;
                }
                try {
                    FileObject buildFo = ProvidesAction.this.findBuildXml();
                    if (buildFo == null || !buildFo.isValid()) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProvidesAction.class, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/project/Bundle").getString("LBL_No_Build_XML_Found")), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    } else {
                        ActionUtils.runTarget((FileObject)buildFo, (String[])targetNames, null);
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        };
        action.run();
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        return this.findBuildXml() != null;
    }

    String[] getTargetNames(String command, Lookup context) throws IllegalArgumentException {
        String[] targetNames = (String[])commands.get(command);
        return targetNames;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    static {
        commands.put("build", new String[]{"dist"});
        commands.put("run", new String[]{"run-deploy"});
        commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
    }
}

