/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.memory;

import java.awt.Color;
import java.beans.FeatureDescriptor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.DetailDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.tools.LLDataCollectorConfiguration;
import org.netbeans.modules.dlight.util.BytesFormatter;
import org.netbeans.modules.dlight.util.ValueFormatter;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionName;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.openide.util.NbBundle;

public final class MemoryToolConfigurationProvider
implements DLightToolConfigurationProvider {
    private static final int INDICATOR_POSITION = 200;
    private static final String ID = "dlight.tool.mem";
    private static final String TOOL_NAME = MemoryToolConfigurationProvider.loc("MemoryTool.ToolName", new String[0]);
    private static final String TOOL_NAME_DETAILED = MemoryToolConfigurationProvider.loc("MemoryTool.ToolName.Detailed", new String[0]);
    private static final DataTableMetadata.Column totalColumn;
    private static final DataTableMetadata rawTableMetadata;
    private static final String MAX_HEAP_DETAIL_ID = "max-heap";

    public DLightToolConfiguration create() {
        DLightToolConfiguration toolConfiguration = new DLightToolConfiguration(ID, TOOL_NAME);
        toolConfiguration.setLongName(TOOL_NAME_DETAILED);
        toolConfiguration.setIcon("org/netbeans/modules/dlight/memory/resources/memory.png");
        toolConfiguration.setDescription(MemoryToolConfigurationProvider.loc("MemoryTool.Description", new String[0]));
        FeatureDescriptor descriptor = new FeatureDescriptor();
        descriptor.setValue("dtrace.script", this.getScriptUrl());
        toolConfiguration.setFeatureDescriptor(descriptor);
        DataCollectorConfiguration dcc = this.initSunStudioDataCollectorConfiguration();
        toolConfiguration.addDataCollectorConfiguration(dcc);
        DTDCConfiguration dtcc = this.initDtraceDataCollectorConfiguration();
        toolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)dtcc);
        toolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)dtcc);
        toolConfiguration.addIndicatorDataProviderConfiguration(this.initDtraceIndicatorDataProviderConfiguration());
        toolConfiguration.addIndicatorDataProviderConfiguration(this.initSunStudioIndicatorDataProviderConfiguration());
        LLDataCollectorConfiguration lldcc = this.initLLDataCollectorConfiguration();
        toolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)lldcc);
        toolConfiguration.addIndicatorConfiguration(this.initIndicatorConfiguration());
        return toolConfiguration;
    }

    private DataCollectorConfiguration initSunStudioDataCollectorConfiguration() {
        return new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.MEMORY);
    }

    private DTDCConfiguration initDtraceDataCollectorConfiguration() {
        DTDCConfiguration dataCollectorConfiguration = new DTDCConfiguration(this.getScriptUrl(), Arrays.asList(rawTableMetadata));
        dataCollectorConfiguration.setIndicatorFiringFactor(1);
        dataCollectorConfiguration.setStackSupportEnabled(true);
        dataCollectorConfiguration.setOutputPrefix("mem:");
        return dataCollectorConfiguration;
    }

    private IndicatorDataProviderConfiguration initSunStudioIndicatorDataProviderConfiguration() {
        SunStudioDCConfiguration result = new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.MEMSUMMARY);
        return result;
    }

    private IndicatorDataProviderConfiguration initDtraceIndicatorDataProviderConfiguration() {
        DTDCConfiguration dataCollectorConfiguration = new DTDCConfiguration(this.getScriptUrl(), Arrays.asList(rawTableMetadata));
        dataCollectorConfiguration.setIndicatorFiringFactor(1);
        dataCollectorConfiguration.setScriptArgs(" -DNOSTACK");
        dataCollectorConfiguration.setStackSupportEnabled(true);
        dataCollectorConfiguration.setOutputPrefix("mem:");
        return dataCollectorConfiguration;
    }

    private URL getScriptUrl() {
        return this.getClass().getResource("resources/mem.d");
    }

    private LLDataCollectorConfiguration initLLDataCollectorConfiguration() {
        LLDataCollectorConfiguration memIndicatorDataProvider = new LLDataCollectorConfiguration(LLDataCollectorConfiguration.CollectedData.MEM);
        return memIndicatorDataProvider;
    }

    private IndicatorConfiguration initIndicatorConfiguration() {
        IndicatorMetadata indicatorMetadata = null;
        ArrayList<DataTableMetadata.Column> indicatorColumns = new ArrayList<DataTableMetadata.Column>();
        indicatorColumns.add(SunStudioDCConfiguration.c_leakSize);
        indicatorColumns.addAll(LLDataCollectorConfiguration.MEM_TABLE.getColumns());
        indicatorColumns.addAll(Arrays.asList(totalColumn));
        indicatorMetadata = new IndicatorMetadata(indicatorColumns);
        BytesFormatter formatter = new BytesFormatter();
        TimeSeriesIndicatorConfiguration indicatorConfiguration = new TimeSeriesIndicatorConfiguration(indicatorMetadata, 200);
        indicatorConfiguration.setPersistencePrefix("dlight_mem");
        indicatorConfiguration.setTitle(MemoryToolConfigurationProvider.loc("indicator.title", new String[0]));
        indicatorConfiguration.setGraphScale(1024);
        indicatorConfiguration.addTimeSeriesDescriptors(new TimeSeriesDescriptor[]{new TimeSeriesDescriptor("mem", MemoryToolConfigurationProvider.loc("graph.description", new String[0]), new Color(83, 130, 161), TimeSeriesDescriptor.Kind.LINE)});
        indicatorConfiguration.setDataRowHandler((DataRowToTimeSeries)new DataRowToMemory(indicatorColumns, (ValueFormatter)formatter));
        indicatorConfiguration.addDetailDescriptors(new DetailDescriptor[]{new DetailDescriptor(MAX_HEAP_DETAIL_ID, MemoryToolConfigurationProvider.loc("MemoryTool.Legend.Max", new String[0]), formatter.format(0L))});
        indicatorConfiguration.setActionDisplayName(MemoryToolConfigurationProvider.loc("indicator.action", new String[0]));
        indicatorConfiguration.setActionTooltip(MemoryToolConfigurationProvider.loc("indicator.action.tooltip", new String[0]));
        indicatorConfiguration.setLabelFormatter((ValueFormatter)formatter);
        DataTableMetadata detailedViewTableMetadata = SunStudioDCConfiguration.getMemTableMetadata((DataTableMetadata.Column[])new DataTableMetadata.Column[]{SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_leakSize, SunStudioDCConfiguration.c_leakCount});
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_name.getColumnName(), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.func_name", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.func_name", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_leakSize.getColumnName(), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.leak", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.leak", new String[0]));
        FunctionDatatableDescription functionDesc = new FunctionDatatableDescription(SunStudioDCConfiguration.c_name.getColumnName(), null, SunStudioDCConfiguration.c_name.getColumnName());
        FunctionsListViewVisualizerConfiguration tableVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(detailedViewTableMetadata, functionDesc, Arrays.asList(SunStudioDCConfiguration.c_leakSize, SunStudioDCConfiguration.c_leakCount));
        tableVisualizerConfiguration.setColumnsUIMapping(columnsUIMapping);
        tableVisualizerConfiguration.setEmptyAnalyzeMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        tableVisualizerConfiguration.setEmptyRunningMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        indicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)tableVisualizerConfiguration);
        indicatorConfiguration.addVisualizerConfiguration(this.getDetails(rawTableMetadata));
        return indicatorConfiguration;
    }

    private VisualizerConfiguration getDetails(DataTableMetadata rawTableMetadata) {
        DataTableMetadata.Column metricColumn = new DataTableMetadata.Column("leak", Long.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.leak", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.leak", new String[0]), null);
        List<DataTableMetadata.Column> viewColumns = Arrays.asList(new DataTableMetadata.Column("func_name", FunctionName.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.func_name", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.func_name", new String[0]), null), metricColumn);
        String sql = "SELECT func.func_id AS func_id, func.func_name AS func_name, node.offset AS offset, SUM(leak.size) AS leak FROM (SELECT MAX(timestamp) AS timestamp, address, SUM(kind * size) AS size FROM mem GROUP BY address HAVING SUM(kind * size) > 0) AS leak LEFT JOIN mem ON leak.timestamp = mem.timestamp AND leak.address = mem.address LEFT JOIN node ON mem.stackid = node.node_id LEFT JOIN func ON node.func_id = func.func_id GROUP BY func_id, func_name, offset ORDER BY leak DESC";
        FunctionDatatableDescription functionDesc = new FunctionDatatableDescription("func_name", "offset", "func_id");
        DataTableMetadata viewTableMetadata = new DataTableMetadata("mem", viewColumns, sql, Arrays.asList(rawTableMetadata));
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setColumnUI("func_name", MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.func_name", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.func_name", new String[0]));
        columnsUIMapping.setColumnUI(metricColumn.getColumnName(), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.leak", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.leak", new String[0]));
        FunctionsListViewVisualizerConfiguration tableVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(viewTableMetadata, functionDesc, Arrays.asList(metricColumn));
        tableVisualizerConfiguration.setColumnsUIMapping(columnsUIMapping);
        tableVisualizerConfiguration.setEmptyAnalyzeMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        tableVisualizerConfiguration.setEmptyRunningMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        return tableVisualizerConfiguration;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(MemoryToolConfigurationProvider.class, (String)key, (Object[])params);
    }

    static {
        DataTableMetadata.Column timestampColumn = new DataTableMetadata.Column("timestamp", Time.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.timestamp", new String[0]), null);
        DataTableMetadata.Column kindColumn = new DataTableMetadata.Column("kind", Integer.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.kind", new String[0]), null);
        DataTableMetadata.Column sizeColumn = new DataTableMetadata.Column("size", Integer.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.size", new String[0]), null);
        DataTableMetadata.Column addressColumn = new DataTableMetadata.Column("address", Long.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.address", new String[0]), null);
        DataTableMetadata.Column stackColumn = new DataTableMetadata.Column("stackid", Long.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.stackid", new String[0]), null);
        totalColumn = new DataTableMetadata.Column("total", Integer.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.total", new String[0]), null);
        List<DataTableMetadata.Column> columns = Arrays.asList(timestampColumn, kindColumn, sizeColumn, addressColumn, totalColumn, stackColumn);
        rawTableMetadata = new DataTableMetadata("mem", columns, Arrays.asList(timestampColumn, addressColumn));
    }

    private static final class DataRowToMemory
    implements DataRowToTimeSeries {
        private final List<DataTableMetadata.Column> columns;
        private final ValueFormatter formatter;
        private int max;

        public DataRowToMemory(List<DataTableMetadata.Column> columns, ValueFormatter formatter) {
            this.columns = new ArrayList<DataTableMetadata.Column>(columns);
            this.formatter = formatter;
        }

        public float[] getData(DataRow row) {
            float[] result = null;
            for (String columnName : row.getColumnNames()) {
                for (DataTableMetadata.Column column : this.columns) {
                    if (!column.getColumnName().equals(columnName)) continue;
                    if (result == null) {
                        result = new float[1];
                    }
                    int mem = DataUtil.toInt((Object)row.getData(columnName));
                    result[0] = mem;
                    if (this.max >= mem) continue;
                    this.max = mem;
                }
            }
            return result;
        }

        public Map<String, String> getDetails() {
            return Collections.singletonMap(MemoryToolConfigurationProvider.MAX_HEAP_DETAIL_ID, this.formatter.format((long)this.max));
        }
    }
}

