/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.openide.util.RequestProcessor;

public class DLightExecutorService {
    private static final String PREFIX = "DLIGHT: ";
    private static final RequestProcessor processor = new RequestProcessor("DLIGHT: ", 50);
    private static final Object lock = DLightExecutorService.class.getName() + "Lock";

    private DLightExecutorService() {
    }

    public static <T> Future<T> submit(final Callable<T> task, final String name) {
        FutureTask ftask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                Thread.currentThread().setName(DLightExecutorService.PREFIX + name);
                return task.call();
            }
        });
        processor.post(ftask);
        return ftask;
    }

    public static void submit(final Runnable task, final String name) {
        processor.post(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(DLightExecutorService.PREFIX + name);
                task.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period, TimeUnit unit, String descr) {
        Object object = lock;
        synchronized (object) {
            final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new TaskThreadFactory(descr));
            final ScheduledFuture<?> future = service.scheduleAtFixedRate(task, 0L, period, unit);
            DLightExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    while (!future.isDone()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return service.shutdownNow();
                        }
                    });
                }
            }, descr + " reaper");
            return future;
        }
    }

    static class TaskThreadFactory
    implements ThreadFactory {
        static final AtomicInteger threadNumber = new AtomicInteger(1);
        static final String namePrefix = "DLIGHT: ScheduledExecutorService No. ";
        final String threadName;
        final ThreadGroup group;

        TaskThreadFactory(String threadName) {
            this.threadName = namePrefix + threadNumber.getAndIncrement() + " [ " + threadName + " ]";
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Thread newThread(Runnable r) {
            Object object = lock;
            synchronized (object) {
                Thread t = new Thread(this.group, r, this.threadName, 0L);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        }
    }
}

