/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class JPDAReload
extends Task {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.ant");
    private List filesets = new ArrayList();

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void execute() throws BuildException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JPDAReload.execute(), filesets = " + this.filesets);
        }
        if (this.filesets.size() == 0) {
            throw new BuildException("A nested fileset with class to refresh in VM must be specified.");
        }
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            throw new BuildException("No debugging sessions was found.");
        }
        JPDADebugger debugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            throw new BuildException("Current debugger is not JPDA one.");
        }
        if (!debugger.canFixClasses()) {
            throw new BuildException("The debugger does not support Fix action.");
        }
        if (debugger.getState() == 4) {
            throw new BuildException("The debugger is not running");
        }
        System.out.println("Classes to be reloaded:");
        FileUtils fileUtils = FileUtils.getFileUtils();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        EditorContext editorContext = (EditorContext)DebuggerManager.getDebuggerManager().lookupFirst(null, EditorContext.class);
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] fileNames = ds.getIncludedFiles();
            File baseDir = fs.getDir(this.getProject());
            int k = fileNames.length;
            for (int i = 0; i < k; ++i) {
                FileObject fo;
                File f = fileUtils.resolveFile(baseDir, fileNames[i]);
                if (f == null || (fo = FileUtil.toFileObject((File)f)) == null) continue;
                try {
                    String url = this.classToSourceURL(fo);
                    if (url != null) {
                        editorContext.updateTimeStamp((Object)debugger, url);
                    }
                    InputStream is = fo.getInputStream();
                    long fileSize = fo.getSize();
                    byte[] bytecode = new byte[(int)fileSize];
                    is.read(bytecode);
                    String className = fileNames[i].substring(0, fileNames[i].length() - 6).replace(File.separatorChar, '.');
                    map.put(className, bytecode);
                    System.out.println(" " + className);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Reloaded classes: " + map.keySet());
        }
        if (map.size() == 0) {
            System.out.println(" No class to reload");
            return;
        }
        String error = null;
        try {
            debugger.fixClasses(map);
        }
        catch (UnsupportedOperationException uoex) {
            error = "The virtual machine does not support this operation: " + uoex.getLocalizedMessage();
        }
        catch (NoClassDefFoundError ncdfex) {
            error = "The bytes don't correspond to the class type (the names don't match): " + ncdfex.getLocalizedMessage();
        }
        catch (VerifyError ver) {
            error = "A \"verifier\" detects that a class, though well formed, contains an internal inconsistency or security problem: " + ver.getLocalizedMessage();
        }
        catch (UnsupportedClassVersionError ucver) {
            error = "The major and minor version numbers in bytes are not supported by the VM. " + ucver.getLocalizedMessage();
        }
        catch (ClassFormatError cfer) {
            error = "The bytes do not represent a valid class. " + cfer.getLocalizedMessage();
        }
        catch (ClassCircularityError ccer) {
            error = "A circularity has been detected while initializing a class: " + ccer.getLocalizedMessage();
        }
        if (error != null) {
            this.getProject().log(error, 0);
            throw new BuildException(error);
        }
    }

    private String classToSourceURL(FileObject fo) {
        try {
            FileObject[] sRoots;
            ClassPath sourcePath;
            FileObject rfo;
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
            FileObject root = cp.findOwnerRoot(fo);
            String resourceName = cp.getResourceName(fo, '/', false);
            if (resourceName == null) {
                this.getProject().log("Can not find classpath resource for " + fo + ", skipping...", 0);
                return null;
            }
            int i = resourceName.indexOf(36);
            if (i > 0) {
                resourceName = resourceName.substring(0, i);
            }
            if ((rfo = (sourcePath = ClassPathSupport.createClassPath((FileObject[])(sRoots = SourceForBinaryQuery.findSourceRoots((URL)root.getURL()).getRoots()))).findResource(resourceName + ".java")) == null) {
                return null;
            }
            return rfo.getURL().toExternalForm();
        }
        catch (FileStateInvalidException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

