/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.editor;

import java.io.StringReader;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.core.editor.AsmLanguageHierarchy;
import org.netbeans.modules.cnd.asm.core.editor.AsmModelAccessorImpl;
import org.netbeans.modules.cnd.asm.model.AsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModelAccessor;
import org.netbeans.modules.cnd.asm.model.AsmModelProvider;
import org.netbeans.modules.cnd.asm.model.AsmSyntax;
import org.netbeans.modules.cnd.asm.model.AsmSyntaxProvider;
import org.netbeans.modules.cnd.asm.model.AsmTypesProvider;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.util.Lookup;

public class AsmEditorKit
extends NbEditorKit {
    protected void initDocument(BaseDocument doc) {
        super.initDocument(doc);
        AsmEditorKit.initLanguage((Document)doc);
    }

    public String getContentType() {
        return "text/x-asm";
    }

    private static boolean initLanguage(Document doc) {
        AsmModelAccessor acc = (AsmModelAccessor)doc.getProperty(AsmModelAccessor.class);
        if (acc == null) {
            if (doc.getProperty(Language.class) != null) {
                return true;
            }
            String text = AsmObjectUtilities.getText(doc);
            if (text.length() == 0) {
                text = AsmObjectUtilities.getText(NbEditorUtilities.getFileObject((Document)doc));
            }
            if (text.length() == 0) {
                if (doc.getProperty(LangInitializer.class) == null) {
                    LangInitializer langInitializer = new LangInitializer(doc);
                    doc.putProperty(LangInitializer.class, langInitializer);
                    doc.addDocumentListener(langInitializer);
                }
                return false;
            }
            AsmModelProvider modelProv = null;
            AsmSyntaxProvider syntProv = null;
            Collection idents = Lookup.getDefault().lookup(new Lookup.Template(AsmTypesProvider.class)).allInstances();
            AsmTypesProvider.ResolverResult res = null;
            for (AsmTypesProvider ident : idents) {
                res = ident.resolve(new StringReader(text));
                if (res == null) continue;
                modelProv = res.getModelProvider();
                syntProv = res.getSyntaxProvider();
                Logger.getLogger(AsmEditorKit.class.getName()).log(Level.FINE, "Asm Regognized " + modelProv + " " + syntProv);
            }
            if (res == null || modelProv == null || syntProv == null) {
                return false;
            }
            AsmModel model = modelProv.getModel();
            AsmSyntax synt = syntProv.getSyntax(model);
            acc = new AsmModelAccessorImpl(model, synt, doc);
            doc.putProperty(AsmModelAccessor.class, acc);
            doc.putProperty(AsmModel.class, model);
            doc.putProperty(Language.class, new AsmLanguageHierarchy(synt).language());
            return true;
        }
        return false;
    }

    private static final class LangInitializer
    implements DocumentListener {
        private final Document doc;

        LangInitializer(Document doc) {
            this.doc = doc;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.initLanguage();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.initLanguage();
        }

        private void initLanguage() {
            if (AsmEditorKit.initLanguage(this.doc)) {
                this.doc.removeDocumentListener(this);
                this.doc.putProperty(LangInitializer.class, null);
            }
        }
    }
}

