/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class StackSizeComputer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private boolean[] evaluated = new boolean[1024];
    private int[] stackSizes = new int[1024];
    private boolean exitInstructionBlock;
    private int stackSize;
    private int maxStackSize;

    public boolean isReachable(int n) {
        return this.evaluated[n];
    }

    public int getStackSize(int n) {
        if (!this.evaluated[n]) {
            throw new IllegalArgumentException("Unknown stack size at unreachable instruction offset [" + n + "]");
        }
        return this.stackSizes[n];
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while computing stack sizes:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            throw runtimeException;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int n = codeAttribute.u4codeLength;
        if (this.evaluated.length < n) {
            this.evaluated = new boolean[n];
            this.stackSizes = new int[n];
        } else {
            for (int i = 0; i < n; ++i) {
                this.evaluated[i] = false;
            }
        }
        this.stackSize = 0;
        this.maxStackSize = 0;
        this.evaluateInstructionBlock(clazz, method, codeAttribute, 0);
        codeAttribute.exceptionsAccept(clazz, method, this);
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        byte by = simpleInstruction.opcode;
        this.exitInstructionBlock = by == -84 || by == -83 || by == -82 || by == -81 || by == -80 || by == -79 || by == -65;
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        this.exitInstructionBlock = false;
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        byte by = variableInstruction.opcode;
        this.exitInstructionBlock = by == -87;
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        byte by = branchInstruction.opcode;
        this.evaluateInstructionBlock(clazz, method, codeAttribute, n + branchInstruction.branchOffset);
        if (by == -88 || by == -55) {
            --this.stackSize;
            this.evaluateInstructionBlock(clazz, method, codeAttribute, n + branchInstruction.length(n));
        }
        this.exitInstructionBlock = by == -89 || by == -56 || by == -88 || by == -55;
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
        int[] nArray = switchInstruction.jumpOffsets;
        for (int i = 0; i < nArray.length; ++i) {
            this.evaluateInstructionBlock(clazz, method, codeAttribute, n + nArray[i]);
        }
        this.evaluateInstructionBlock(clazz, method, codeAttribute, n + switchInstruction.defaultOffset);
        this.exitInstructionBlock = true;
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        this.stackSize = 1;
        this.evaluateInstructionBlock(clazz, method, codeAttribute, exceptionInfo.u2handlerPC);
    }

    private void evaluateInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, int n) {
        int n2 = this.stackSize;
        if (this.maxStackSize < this.stackSize) {
            this.maxStackSize = this.stackSize;
        }
        while (!this.evaluated[n]) {
            this.evaluated[n] = true;
            Instruction instruction = InstructionFactory.create(codeAttribute.code, n);
            this.stackSize -= instruction.stackPopCount(clazz);
            if (this.stackSize < 0) {
                throw new IllegalArgumentException("Stack size becomes negative after instruction " + instruction.toString(n) + " in [" + clazz.getName() + "." + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            }
            this.stackSizes[n] = this.stackSize += instruction.stackPushCount(clazz);
            if (this.maxStackSize < this.stackSize) {
                this.maxStackSize = this.stackSize;
            }
            int n3 = n + instruction.length(n);
            instruction.accept(clazz, method, codeAttribute, n, this);
            if (this.exitInstructionBlock) break;
            n = n3;
        }
        this.stackSize = n2;
    }
}

