/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.project;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.KnownProject;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.project.PathCache;
import org.netbeans.modules.cnd.discovery.project.ProjectCreator;
import org.netbeans.modules.cnd.discovery.project.SolarisLogReader;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.tree.ConfigurationFactory;
import org.netbeans.modules.cnd.discovery.wizard.tree.ProjectConfigurationImpl;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OpenSolaris
extends KnownProject {
    private static final boolean TRACE = true;
    static final boolean READ_MAP_FILE_VERS = false;
    public static final String PROJECT_NAME = "open-solaris";
    public static final String LOG_FILE = "nightly-log";
    public static final String BUILD_SCRIPT = "build-script";
    private String root;
    private String nb_root;
    private String nightly_log;
    private String buildScript;
    private List<SourceFileProperties> sources;
    private List<SolarisLogReader.InstallLine> copyHeader;
    TreeMap<String, Set<String>> mapFiles;
    TreeMap<String, Set<String>> libraries;
    Map<String, String> secondLevel = new HashMap<String, String>();

    public OpenSolaris() {
        this.secondLevel.put("lib/gss_mechs/", "os.lib.gss_mechs.");
        this.secondLevel.put("lib/fm/", "os.lib.fm.");
        this.secondLevel.put("lib/hal/", "os.lib.hal.");
        this.secondLevel.put("lib/lvm/", "os.lib.lvm.");
        this.secondLevel.put("lib/libkfm/", "os.lib.libkfm.");
        this.secondLevel.put("lib/openssl/", "os.lib.openssl.");
        this.secondLevel.put("lib/policykit/", "os.lib.policykit.");
        this.secondLevel.put("lib/print/", "os.lib.print.");
        this.secondLevel.put("lib/scsi/", "os.lib.scsi.");
        this.secondLevel.put("lib/smbsrv/", "os.lib.smbsrv.");
        this.secondLevel.put("lib/udapl/", "os.lib.udapl.");
        this.secondLevel.put("cmd/sgs/", "os.cmd.sgs.");
        this.secondLevel.put("cmd/perl/", "os.cmd.perl.");
        this.secondLevel.put("cmd/ssh/", "os.cmd.ssh.");
        this.secondLevel.put("cmd/xntpd/", "os.cmd.xntpd.");
    }

    @Override
    public boolean canCreate(Map<String, String> parameters) {
        if (!PROJECT_NAME.equals(parameters.get("project"))) {
            return false;
        }
        this.root = parameters.get("root");
        if (this.root == null) {
            return false;
        }
        this.nb_root = parameters.get("netbeans-project");
        if (this.nb_root == null) {
            return false;
        }
        this.nightly_log = parameters.get(LOG_FILE);
        if (this.nightly_log == null) {
            this.nightly_log = this.findMakeLog(this.root);
            if (this.nightly_log == null) {
                return false;
            }
        } else {
            File log = new File(this.nightly_log);
            if (!log.exists() || log.isDirectory()) {
                return false;
            }
        }
        this.buildScript = parameters.get(BUILD_SCRIPT);
        if (this.buildScript == null) {
            this.buildScript = "opensolaris.sh";
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(Map<String, String> parameters) {
        try {
            System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"CREATE_PROJECT"));
            System.out.println("project=open-solaris");
            System.out.println("root=" + this.root);
            System.out.println("netbeans-project=" + this.nb_root);
            System.out.println("nightly-log=" + this.nightly_log);
            System.out.println("build-script=" + this.buildScript);
            System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"SCANNING_LOG"));
            this.sources = this.scan(this.nightly_log, this.root);
            if (this.sources == null || this.sources.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.createImpl();
            return bl;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            PathCache.dispose();
        }
    }

    private void createFolders(Map<String, ProjectSources> folders) throws IOException {
        FileObject fo = ProjectCreator.createProjectDir(new File(this.nb_root));
        for (Map.Entry<String, ProjectSources> entry : folders.entrySet()) {
            StringTokenizer st = new StringTokenizer(entry.getKey(), "/");
            FileObject f = fo;
            while (st.hasMoreTokens()) {
                String fn = st.nextToken();
                boolean find = false;
                for (FileObject ff : f.getChildren()) {
                    if (!fn.equals(ff.getNameExt())) continue;
                    f = ff;
                    find = true;
                    break;
                }
                if (find) continue;
                f = f.createFolder(fn);
            }
        }
    }

    private String getSecondlevel(String path) {
        for (String s : this.secondLevel.keySet()) {
            if (!path.startsWith(s)) continue;
            return s;
        }
        return null;
    }

    private boolean createImpl() throws IOException {
        File proto = new File(this.root + "/proto");
        if (!proto.exists()) {
            System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"INSTALLING_PROTO"));
            for (SolarisLogReader.InstallLine il : this.copyHeader) {
                il.install();
            }
        }
        String srcRoot = this.root + "/usr/src/";
        TreeMap<String, ProjectSources> folders = new TreeMap<String, ProjectSources>();
        for (SourceFileProperties s : this.sources) {
            String path = s.getCompilePath();
            if (!path.startsWith(srcRoot)) continue;
            if (this.getSecondlevel(path = path.substring(srcRoot.length())) != null) {
                String g = this.getSecondlevel(path);
                String f = path.substring(g.length());
                int i = f.indexOf(47);
                if (i > 0) {
                    this.addFolder(folders, g + f.substring(0, i), f.substring(0, i), s);
                    continue;
                }
                if (f.length() <= 0) continue;
                this.addFolder(folders, g + f, f, s);
                continue;
            }
            if (path.startsWith("cmd/")) {
                String f = path.substring(4);
                int i = f.indexOf(47);
                if (i > 0) {
                    this.addFolder(folders, "cmd/" + f.substring(0, i), f.substring(0, i), s);
                    continue;
                }
                if (f.length() <= 0) continue;
                this.addFolder(folders, "cmd/" + f, f, s);
                continue;
            }
            if (path.startsWith("lib/")) {
                String f = path.substring(4);
                int i = f.indexOf(47);
                if (i > 0) {
                    this.addFolder(folders, "lib/" + f.substring(0, i), f.substring(0, i), s);
                    continue;
                }
                if (f.length() <= 0) continue;
                this.addFolder(folders, "lib/" + f, f, s);
                continue;
            }
            int i = path.indexOf(47);
            if (i > 0) {
                this.addFolder(folders, path.substring(0, i), path.substring(0, i), s);
                continue;
            }
            this.addFolder(folders, path, path, s);
        }
        this.createFolders(folders);
        Set<String> projectList = folders.keySet();
        for (Map.Entry entry : folders.entrySet()) {
            String r = srcRoot + (String)entry.getKey();
            String n = this.nb_root + "/" + (String)entry.getKey();
            String name = ((ProjectSources)entry.getValue()).name;
            String display = ((ProjectSources)entry.getValue()).name;
            if (this.getSecondlevel((String)entry.getKey()) != null) {
                String g = this.getSecondlevel((String)entry.getKey());
                display = this.secondLevel.get(g) + display;
            } else {
                display = ((String)entry.getKey()).startsWith("cmd/") ? "os.cmd." + display : (((String)entry.getKey()).startsWith("lib/") ? "os.lib." + display : "os." + display);
            }
            System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"CREATING_PROJECT", (Object)n));
            this.createImpl(r, n, name, display, projectList, ((ProjectSources)entry.getValue()).myFileProperties);
        }
        System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"CREATING_COMMANDS", (Object)this.nb_root));
        this.createImpl(srcRoot + "cmd", this.nb_root + "/commands", "commands", "os.commands", projectList, this.sources);
        System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"CREATING_LIBRARIES", (Object)this.nb_root));
        this.createImpl(srcRoot + "lib", this.nb_root + "/libraries", "libraries", "os.libraries", projectList, this.sources);
        System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"CREATING_SOURCES", (Object)this.nb_root));
        this.createImpl(this.root + "/usr/src", this.nb_root + "/sources", "sources", "os.sources", projectList, this.sources);
        return true;
    }

    private void addFolder(Map<String, ProjectSources> folders, String folder, String name, SourceFileProperties s) {
        ProjectSources l = folders.get(folder);
        if (l == null) {
            l = new ProjectSources(name);
            folders.put(folder, l);
        }
        l.myFileProperties.add(s);
    }

    private boolean createImpl(String sourceRoot, String nbRoot, String name, String displayName, Set<String> folders, List<SourceFileProperties> list) {
        DiscoveryProviderImpl provider = new DiscoveryProviderImpl(list, sourceRoot);
        DiscoveryDescriptorImpl discovery = new DiscoveryDescriptorImpl(null, provider, sourceRoot);
        ProjectCreator creator = new ProjectCreator(discovery);
        creator.init(nbRoot, sourceRoot, sourceRoot + "/Makefile", this.buildScript);
        try {
            creator.createProject(name, displayName, folders, this.getLibraries(displayName, sourceRoot, nbRoot));
            this.createGlobalList(sourceRoot, nbRoot, list);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        return true;
    }

    private Set<String> getLibraries(String displayName, String sourceRoot, String nbRoot) {
        HashSet<String> res = new HashSet<String>();
        if (displayName.indexOf(".sources") > 0 || displayName.indexOf(".libraries") > 0 || displayName.indexOf(".uts") > 0 || displayName.indexOf(".commands") > 0) {
            return res;
        }
        SortedMap<String, Set<String>> map = this.libraries.subMap(sourceRoot, sourceRoot + "/z");
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            for (String s : entry.getValue()) {
                res.add(s);
            }
        }
        if (res.size() > 0) {
            System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"REQUIRED_PROJECTS", (Object)("" + res)));
        }
        return res;
    }

    private void createGlobalList(String sourceRoot, String nbRoot, List<SourceFileProperties> list) {
        if (this.mapFiles != null) {
            Properties res = new Properties();
            SortedMap<String, Set<String>> map = this.mapFiles.subMap(sourceRoot, sourceRoot + "/z");
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                for (String s : entry.getValue()) {
                    res.put(s, "");
                }
            }
            if (res.size() == 0) {
                return;
            }
            try {
                System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"WRITING_GLOBALS", (Object)("" + res.size())));
                this.grepDefinitions(res, list);
                FileOutputStream os = new FileOutputStream(nbRoot + "/nbproject/private/globals.xml");
                res.storeToXML(os, "Globals");
                ((OutputStream)os).close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void grepDefinitions(Properties res, List<SourceFileProperties> list) {
        for (SourceFileProperties source : list) {
            String path = source.getItemPath();
            File file = new File(path);
            if (!file.exists() || !file.canRead() || file.isDirectory()) continue;
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(file));
                int lineNo = 0;
                while ((line = in.readLine()) != null) {
                    String id;
                    int i;
                    char c;
                    ++lineNo;
                    if (line.length() == 0 || !Character.isLetter(c = line.charAt(0)) && c != '_' || (i = line.indexOf(40)) < 0 || !res.containsKey(id = line.substring(0, i).trim())) continue;
                    res.put(id, path + ":" + lineNo);
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private List<SourceFileProperties> scan(String log, String root) {
        SolarisLogReader reader = new SolarisLogReader(log, root);
        List<SourceFileProperties> res = reader.getResults();
        this.copyHeader = reader.getInstalls();
        this.libraries = reader.getLibraries();
        return res;
    }

    private String findMakeLog(String root) {
        String latest = null;
        String logfolder = root + "/log";
        File log = new File(logfolder);
        if (log.exists() && log.isDirectory() && log.canRead()) {
            block0: for (File when : log.listFiles()) {
                if (!when.exists() || !when.isDirectory() || !when.canRead()) continue;
                for (File l : when.listFiles()) {
                    String folder2;
                    String current = l.getAbsolutePath();
                    if (!current.endsWith("/nightly.log")) continue;
                    if (latest == null) {
                        latest = current;
                        continue block0;
                    }
                    String folder1 = latest.substring(0, latest.lastIndexOf("/nightly.log"));
                    if (folder1.compareTo(folder2 = current.substring(0, current.lastIndexOf("/nightly.log"))) >= 0) continue block0;
                    latest = current;
                    continue block0;
                }
            }
            return latest;
        }
        return null;
    }

    public static class ProjectSources {
        private List<SourceFileProperties> myFileProperties = new ArrayList<SourceFileProperties>();
        private String name;

        private ProjectSources(String name) {
            this.name = name;
        }
    }

    private static class DiscoveryProviderImpl
    implements DiscoveryProvider {
        private List<SourceFileProperties> sources;
        private String root;

        public DiscoveryProviderImpl(List<SourceFileProperties> sources, String root) {
            this.sources = sources;
            this.root = root;
        }

        @Override
        public String getID() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> getPropertyKeys() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ProviderProperty getProperty(String key) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clean() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isApplicable(ProjectProxy project) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<Configuration> analyze(ProjectProxy project, Progress progress) {
            ArrayList<Configuration> confs = new ArrayList<Configuration>();
            Configuration conf = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;

                @Override
                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration());
                }

                private List<SourceFileProperties> getSourceFileProperties() {
                    ArrayList<SourceFileProperties> res = new ArrayList<SourceFileProperties>();
                    HashSet<String> set = new HashSet<String>();
                    for (SourceFileProperties s : DiscoveryProviderImpl.this.sources) {
                        File file;
                        String p;
                        if (!s.getCompilePath().startsWith(DiscoveryProviderImpl.this.root) || set.contains(p = CndFileUtils.normalizeFile((File)(file = new File(s.getItemPath()))).getAbsolutePath())) continue;
                        res.add(s);
                        set.add(p);
                    }
                    return res;
                }

                @Override
                public List<Configuration> getDependencies() {
                    return null;
                }

                @Override
                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        this.myFileProperties = this.getSourceFileProperties();
                    }
                    return this.myFileProperties;
                }

                @Override
                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> set = new HashSet<String>();
                        for (SourceFileProperties source : this.getSourcesConfiguration()) {
                            set.add(source.getItemPath());
                        }
                        HashSet<String> unique = new HashSet<String>();
                        for (String path : set) {
                            File file = new File(path);
                            if (!CndFileUtils.exists((File)file)) continue;
                            unique.add(CndFileUtils.normalizeFile((File)file).getAbsolutePath());
                        }
                        this.myIncludedFiles = new ArrayList<String>(unique);
                    }
                    return this.myIncludedFiles;
                }
            };
            confs.add(conf);
            return confs;
        }

        @Override
        public void stop() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class DiscoveryDescriptorImpl
    implements DiscoveryDescriptor {
        private Project project;
        private DiscoveryProvider provider;
        private List<Configuration> configurations;
        private List<ProjectConfiguration> projectConfigurations;
        private List<String> includedFiles;
        private String root;

        private DiscoveryDescriptorImpl(Project project, DiscoveryProvider provider, String root) {
            this.project = project;
            this.provider = provider;
            this.root = root;
            this.configurations = provider.analyze(null, null);
        }

        @Override
        public Project getProject() {
            return this.project;
        }

        @Override
        public void setProject(Project project) {
            this.project = project;
        }

        @Override
        public DiscoveryProvider getProvider() {
            return this.provider;
        }

        @Override
        public String getProviderID() {
            return this.provider.getID();
        }

        @Override
        public void setProvider(DiscoveryProvider provider) {
            this.provider = provider;
        }

        @Override
        public String getRootFolder() {
            return this.root;
        }

        @Override
        public void setRootFolder(String root) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getBuildResult() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setBuildResult(String binaryPath) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getAditionalLibraries() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setAditionalLibraries(String binaryPath) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getBuildLog() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setBuildLog(String logFile) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getLevel() {
            return "file";
        }

        @Override
        public void setLevel(String level) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<ProjectConfiguration> getConfigurations() {
            if (this.projectConfigurations == null) {
                this.provider.analyze(null, null);
                this.projectConfigurations = new ArrayList<ProjectConfiguration>();
                for (Configuration conf : this.configurations) {
                    List<ProjectProperties> langList = conf.getProjectConfiguration();
                    for (ProjectProperties pp : langList) {
                        ProjectConfigurationImpl pc = ConfigurationFactory.makeRoot(pp, this.getRootFolder());
                        SelectConfigurationPanel.consolidateModel(pc, this.getLevel());
                        this.projectConfigurations.add(pc);
                    }
                }
            }
            return this.projectConfigurations;
        }

        @Override
        public void setConfigurations(List<ProjectConfiguration> configuration) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> getIncludedFiles() {
            if (this.includedFiles == null) {
                this.includedFiles = new ArrayList<String>();
                for (Configuration conf : this.configurations) {
                    this.includedFiles.addAll(conf.getIncludedFiles());
                }
            }
            return this.includedFiles;
        }

        @Override
        public void setIncludedFiles(List<String> includedFiles) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isInvokeProvider() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setInvokeProvider(boolean invoke) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isSimpleMode() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setSimpleMode(boolean simple) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setMessage(String message) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clean() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getCompilerName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setCompilerName(String compiler) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

