/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.optimizers;

import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrByteValue;
import com.sun.javacard.jcfile.instructions.JcInstrIncrement;
import com.sun.javacard.jcfile.instructions.JcInstruction;

public class SincInstrOptimizer {
    JcPackage jc_package;
    private int index;
    private int const_value;
    private JcInstruction store_instr;

    public SincInstrOptimizer(JcPackage jcPackage) {
        this.jc_package = jcPackage;
    }

    public JcPackage optimize() {
        JcClass[] jcClassArray;
        for (JcClass jcClass : jcClassArray = this.jc_package.getClasses()) {
            JcMethod[] jcMethodArray;
            for (JcMethod jcMethod : jcMethodArray = jcClass.getMethods()) {
                this.optimizeByteCode(jcMethod);
            }
        }
        return this.jc_package;
    }

    private void optimizeByteCode(JcMethod jcMethod) {
        JcInstruction jcInstruction = jcMethod.getCode();
        if (jcInstruction == null) {
            return;
        }
        while (jcInstruction != null) {
            this.reset();
            boolean bl = false;
            bl = this.examinePatten(jcInstruction);
            if (bl) {
                JcInstrIncrement jcInstrIncrement = new JcInstrIncrement(89, this.index, this.const_value);
                int n = jcInstruction.getLabel();
                jcInstrIncrement.setLabel(n);
                int n2 = jcInstruction.getSourceLineNumber();
                jcInstrIncrement.setSourceLineNumber(n2);
                JcInstruction jcInstruction2 = jcInstruction.getPrevInstr();
                if (jcInstruction2 == null) {
                    jcMethod.setCode(jcInstrIncrement);
                } else {
                    jcInstruction2.setNextInstr(jcInstrIncrement);
                    jcInstrIncrement.setPrevInstr(jcInstruction2);
                }
                JcInstruction jcInstruction3 = this.store_instr.getNextInstr();
                jcInstrIncrement.setNextInstr(jcInstruction3);
                if (jcInstruction3 != null) {
                    jcInstruction3.setPrevInstr(jcInstrIncrement);
                }
                jcInstruction = jcInstrIncrement;
            }
            jcInstruction = jcInstruction.getNextInstr();
        }
    }

    private boolean examinePatten(JcInstruction jcInstruction) {
        if (!this.checkLoadInstr(jcInstruction)) {
            return false;
        }
        JcInstruction jcInstruction2 = jcInstruction.getNextInstr();
        if (jcInstruction2.getLabel() != -1) {
            return false;
        }
        if (!this.checkConstantInstr(jcInstruction2)) {
            return false;
        }
        if ((jcInstruction2 = jcInstruction2.getNextInstr()).getLabel() != -1) {
            return false;
        }
        if (!this.checkArithmeticInstr(jcInstruction2)) {
            return false;
        }
        if ((jcInstruction2 = jcInstruction2.getNextInstr()).getLabel() != -1) {
            return false;
        }
        return this.checkStoreInstr(jcInstruction2);
    }

    private boolean checkLoadInstr(JcInstruction jcInstruction) {
        if (jcInstruction == null) {
            return false;
        }
        int n = jcInstruction.getOpcode();
        switch (n) {
            case 28: {
                this.index = 0;
                return true;
            }
            case 29: {
                this.index = 1;
                return true;
            }
            case 30: {
                this.index = 2;
                return true;
            }
            case 31: {
                this.index = 3;
                return true;
            }
            case 22: {
                this.index = ((JcInstrByteIndex)jcInstruction).getIndex();
                return true;
            }
        }
        return false;
    }

    private boolean checkConstantInstr(JcInstruction jcInstruction) {
        if (jcInstruction == null) {
            return false;
        }
        int n = jcInstruction.getOpcode();
        switch (n) {
            case 2: {
                this.const_value = -1;
                return true;
            }
            case 3: {
                this.const_value = 0;
                return true;
            }
            case 4: {
                this.const_value = 1;
                return true;
            }
            case 5: {
                this.const_value = 2;
                return true;
            }
            case 6: {
                this.const_value = 3;
                return true;
            }
            case 7: {
                this.const_value = 4;
                return true;
            }
            case 8: {
                this.const_value = 5;
                return true;
            }
            case 16: {
                this.const_value = ((JcInstrByteValue)jcInstruction).getValue();
                return true;
            }
        }
        return false;
    }

    private boolean checkArithmeticInstr(JcInstruction jcInstruction) {
        if (jcInstruction == null) {
            return false;
        }
        int n = jcInstruction.getOpcode();
        if (n == 65) {
            return true;
        }
        if (n == 67) {
            if (this.const_value == -128) {
                return false;
            }
            this.const_value = -this.const_value;
            return true;
        }
        return false;
    }

    private boolean checkStoreInstr(JcInstruction jcInstruction) {
        if (jcInstruction == null) {
            return false;
        }
        int n = jcInstruction.getOpcode();
        switch (n) {
            case 47: {
                if (this.index == 0) {
                    this.store_instr = jcInstruction;
                    return true;
                }
                return false;
            }
            case 48: {
                if (this.index == 1) {
                    this.store_instr = jcInstruction;
                    return true;
                }
                return false;
            }
            case 49: {
                if (this.index == 2) {
                    this.store_instr = jcInstruction;
                    return true;
                }
                return false;
            }
            case 50: {
                if (this.index == 3) {
                    this.store_instr = jcInstruction;
                    return true;
                }
                return false;
            }
            case 41: {
                int n2 = ((JcInstrByteIndex)jcInstruction).getIndex();
                if (n2 == this.index) {
                    this.store_instr = jcInstruction;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void reset() {
        this.index = 0;
        this.const_value = 0;
        this.store_instr = null;
    }
}

