/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteBinaryService {
    private static final Map<RemoteBinaryID, Future<Boolean>> readiness = Collections.synchronizedMap(new HashMap());

    protected RemoteBinaryService() {
    }

    public static RemoteBinaryID getRemoteBinary(ExecutionEnvironment execEnv, String remotePath) {
        if (execEnv.isLocal()) {
            return new RemoteBinaryID(remotePath);
        }
        RemoteBinaryService rbs = (RemoteBinaryService)Lookup.getDefault().lookup(RemoteBinaryService.class);
        if (rbs == null) {
            return null;
        }
        RemoteBinaryResult result = rbs.getRemoteBinaryImpl(execEnv, remotePath);
        if (result == null) {
            return null;
        }
        RemoteBinaryID id = new RemoteBinaryID(result.localFName);
        Future<Boolean> prevResult = readiness.put(id, result.syncResult);
        if (prevResult != null && prevResult != result.syncResult) {
            prevResult.cancel(true);
        }
        return id;
    }

    public static String getFileName(RemoteBinaryID id) {
        return id.toIDString();
    }

    public static Future<Boolean> getResult(RemoteBinaryID id) {
        return readiness.get(id);
    }

    protected abstract RemoteBinaryResult getRemoteBinaryImpl(ExecutionEnvironment var1, String var2);

    public static class RemoteBinaryID {
        private final String id;

        private RemoteBinaryID(String id) {
            this.id = id;
        }

        public static RemoteBinaryID fromIDString(String str) {
            return new RemoteBinaryID(str);
        }

        public String toIDString() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RemoteBinaryID)) {
                return false;
            }
            RemoteBinaryID that = (RemoteBinaryID)obj;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + (this.id != null ? this.id.hashCode() : 0);
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RemoteBinaryResult {
        public final String localFName;
        public final Future<Boolean> syncResult;

        public RemoteBinaryResult(String localFName, Future<Boolean> syncResult) {
            this.localFName = localFName;
            this.syncResult = syncResult;
        }
    }
}

